/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.ObservableEntityData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ChangeQueue
extends ConcurrentLinkedQueue<EntityChange> {
    private ObservableEntityData parent;
    private QueueChangeListener listener;

    public ChangeQueue(ObservableEntityData parent, Class ... types) {
        this.parent = parent;
        this.listener = new QueueChangeListener(types);
        parent.addEntityComponentListener(this.listener);
    }

    protected EntityComponentListener getListener() {
        return this.listener;
    }

    public void release() {
        this.parent.removeEntityComponentListener(this.listener);
    }

    protected class QueueChangeListener
    implements EntityComponentListener {
        private Set<Class> types = new HashSet<Class>();

        public QueueChangeListener(Class ... types) {
            this.types.addAll(Arrays.asList(types));
        }

        @Override
        public void componentChange(EntityChange change) {
            if (this.types.contains(change.getComponentType())) {
                ChangeQueue.this.add(change);
            }
        }
    }
}

