/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.FractalUtils;
import com.simsilica.fractal.PerlinNoise;
import com.simsilica.fractal.Sampler;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileColumnProcessor;
import java.util.Random;
import mythruna.world.TerrainTypes;
import mythruna.world.WorldFractal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloraColumnProcessor
implements TileColumnProcessor {
    static Logger log = LoggerFactory.getLogger(FloraColumnProcessor.class);
    public static final int FLORA_BITS = CellGenType.Flora.apply(0);
    private static final double INV_SQRT2 = 1.0 / Math.sqrt(2.0);
    private static final double xOffset = 1000000.0;
    private static final double zOffset = 1000000.0;
    private WorldFractal fractal;
    private long seed;
    private Sampler noise1;
    private Sampler noise2;
    private Sampler growth;
    private Sampler floraType;
    private int sandType;
    private int dirtType;
    private int grassType;
    private int dryGrassType;
    private int snowType;
    private int flora1;
    private int flora2;
    private int test1;
    private int test2;
    private int test3;
    private int test4;
    private int test5;
    private Biome[] biomes;
    private PlantType testType;

    public FloraColumnProcessor(long seed, WorldFractal fractal) {
        this.fractal = fractal;
        this.seed = seed;
        this.noise1 = new PerlinNoise(seed);
        this.noise2 = new PerlinNoise(seed + 1L);
        this.growth = new AbstractSampler(0.0, 1.0){

            public double getSample(double x, double y, double z) {
                double result1 = FloraColumnProcessor.this.noise1.getSample((x += 1000000.0) / 8.0, 0.0, (z += 1000000.0) / 8.0);
                double result = FractalUtils.normalize((double)result1, (double)(-INV_SQRT2), (double)INV_SQRT2);
                if (result < 0.0) {
                    return 0.0;
                }
                if (result > 1.0) {
                    return 1.0;
                }
                return result;
            }

            public String toString() {
                return "PlantGrowth[]";
            }
        };
        this.floraType = new AbstractSampler(0.0, 1.0){

            public double getSample(double x, double y, double z) {
                double result2;
                double combined;
                double result;
                double result1 = FloraColumnProcessor.this.noise2.getSample((x += 1000000.0) / 4.0, y / 128.0, (z += 1000000.0) / 4.0);
                if ((result = FractalUtils.normalize((double)(combined = result1 * 1.5 + (result2 = FloraColumnProcessor.this.noise2.getSample(x / 64.0, y / 128.0, z / 64.0)) * 0.5), (double)(-INV_SQRT2 * 2.0), (double)(INV_SQRT2 * 2.0))) < 0.0) {
                    return 0.0;
                }
                if (result > 1.0) {
                    return 1.0;
                }
                return result;
            }

            public String toString() {
                return "PlantGrowth[]";
            }
        };
        this.sandType = BlockTypeIndex.findType((BlockName)new BlockName("sand", "cube"), (int)1);
        this.dirtType = BlockTypeIndex.findType((BlockName)new BlockName("dirt", "cube"), (int)1);
        this.grassType = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"), (int)1);
        this.dryGrassType = BlockTypeIndex.findType((BlockName)new BlockName("dry-grass", "cube"), (int)1);
        this.snowType = BlockTypeIndex.findType((BlockName)new BlockName("snow", "cube"), (int)1);
        this.flora1 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-grass"), (int)1) | FLORA_BITS;
        this.flora2 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS;
        this.test1 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS;
        this.test2 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS;
        this.test3 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-grass"), (int)1) | FLORA_BITS;
        this.test4 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "flowers-1"), (int)1) | FLORA_BITS;
        this.test5 = BlockTypeIndex.findType((BlockName)new BlockName("flora", "glow-flowers-1"), (int)1) | FLORA_BITS;
        PlantType grass = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "medium-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-grass"), (int)1) | FLORA_BITS);
        PlantType brush = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-brush"), (int)1) | FLORA_BITS);
        PlantType flower1 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "flowers-1"), (int)1) | FLORA_BITS);
        PlantType flower2 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "flowers-2"), (int)1) | FLORA_BITS);
        PlantType flower3 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "flowers-3"), (int)1) | FLORA_BITS);
        PlantType flower4 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "wild-flowers"), (int)1) | FLORA_BITS);
        PlantType dryGrass = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "medium-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS);
        PlantType dryBrush = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-brush"), (int)1) | FLORA_BITS);
        PlantType dryFlower1 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "dry-flowers-1"), (int)1) | FLORA_BITS);
        PlantType dryFlower2 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "dry-flowers-2"), (int)1) | FLORA_BITS);
        PlantType dryFlower3 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "dry-flowers-3"), (int)1) | FLORA_BITS);
        PlantType dryFlower4 = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "low-dry-brush"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "dry-wild-flowers"), (int)1) | FLORA_BITS);
        PlantType desertGrass = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS);
        PlantType desertBrush = new PlantType(this, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-grass"), (int)1) | FLORA_BITS, BlockTypeIndex.findType((BlockName)new BlockName("flora", "tall-dry-brush"), (int)1) | FLORA_BITS);
        this.biomes = new Biome[BlockTypeIndex.getTypeCount()];
        this.biomes[this.sandType] = new Biome(this, desertGrass, desertGrass, desertGrass, desertBrush);
        this.biomes[this.dryGrassType] = new Biome(this, dryGrass, dryGrass, dryBrush, dryBrush, dryFlower4, dryFlower1, dryFlower2, dryFlower3);
        this.biomes[this.grassType] = new Biome(this, grass, brush, flower4, flower1, flower2, flower3);
    }

    public boolean apply(ColumnData colData, Tile tile) {
        ColumnId columnId = colData.getColumnId();
        Random rand = new Random(columnId.getId());
        Vec3i world = columnId.getWorld(null);
        Vec3i local = columnId.getTileLocal(null);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluidLevels = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        int size = 32;
        for (int i = 0; i < 32; ++i) {
            for (int k = 0; k < 32; ++k) {
                double roll;
                double growthChance;
                int jGround;
                int yGround;
                short fluidLevel;
                int xp = local.x + i;
                int zp = local.z + k;
                short elevation = terrain.getElevation(xp, zp);
                if (elevation < (fluidLevel = fluidLevels.getElevation(xp, zp))) continue;
                short y = elevation;
                int j = y % 32;
                LeafData leaf = colData.getLeafData((int)y);
                FluidData fluid = colData.getFluidData((int)y);
                int v = leaf.getCell(i, j, k);
                if (v != 0) continue;
                LeafData groundLeaf = j > 0 ? leaf : colData.getLeafData(yGround);
                int vGround = groundLeaf.getCell(i, jGround = (yGround = y - 1) % 32, k);
                if (vGround == 0) continue;
                int groundType = MaskUtils.getType((int)vGround);
                byte type = terrain.getType(xp, zp);
                int baseType = TerrainTypes.getBaseType(type);
                int foliage = TerrainTypes.getFoliageLevel(type);
                int wet = TerrainTypes.getWetnessLevel(type);
                boolean frozen = TerrainTypes.isFrozen(type);
                byte fluidType = fluidLevels.getType(xp, zp);
                Biome biome = this.biomes[groundType];
                if (biome == null) continue;
                double x = world.x + i;
                double z = world.z + k;
                double chance = growthChance = this.growth.getSample(x, (double)y, z);
                double typePenalty = 0.0;
                byte light = terrain.getLight(xp, zp);
                byte shadow = light >= 0 ? (byte)0 : -light;
                double shadowFactor = Math.min(1.0, (double)shadow / 15.0);
                if (groundType == this.sandType) {
                    chance *= (double)wet / 3.0;
                    if (wet > 0) {
                        chance += shadowFactor;
                    }
                } else if (groundType == this.dirtType) {
                    chance = 0.0;
                } else if (groundType == this.dryGrassType) {
                    chance *= (double)foliage / 3.0;
                    chance += shadowFactor;
                } else if (groundType == this.grassType) {
                    chance *= (double)(foliage + wet) / 3.0;
                    typePenalty = shadowFactor;
                    if (shadowFactor >= 0.4 && chance <= 0.25) {
                        biome = this.biomes[this.dryGrassType];
                    }
                }
                if ((roll = rand.nextDouble()) > chance) continue;
                double plantSelector = this.floraType.getSample(x, 0.0, z);
                PlantType plantType = biome.getType(plantSelector -= typePenalty);
                int result = plantType.getType(chance);
                if (shadowFactor > 0.5 && chance > 0.95) {
                    result = this.test5;
                }
                leaf.setCell(i, j, k, result);
            }
        }
        return true;
    }

    private class PlantType {
        int[] levels;
        int count;
        int maxIndex;

        public PlantType(FloraColumnProcessor floraColumnProcessor, int ... levels) {
            this.levels = levels;
            this.count = levels.length;
            this.maxIndex = this.count - 1;
        }

        public int getType(double selector) {
            int index = (int)((double)this.count * selector);
            if (index < 0) {
                index = 0;
            } else if (index > this.maxIndex) {
                index = this.maxIndex;
            }
            return this.levels[index];
        }
    }

    private class Biome {
        PlantType[] types;
        int count;
        int maxType;

        public Biome(FloraColumnProcessor floraColumnProcessor, PlantType ... types) {
            this.types = types;
            this.count = types.length;
            this.maxType = types.length - 1;
        }

        public PlantType getType(double selector) {
            int index = (int)((double)this.count * selector);
            if (index < 0) {
                index = 0;
            } else if (index > this.maxType) {
                index = this.maxType;
            }
            return this.types[index];
        }
    }
}

