/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.name;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.namegen.NameGenerator;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameGeneratorCache {
    static Logger log = LoggerFactory.getLogger(NameGeneratorCache.class);
    public static final String RESOURCE_FEMALE_NAMES = "/people/all-female.nameset";
    public static final String RESOURCE_MALE_NAMES = "/people/all-male.nameset";
    public static final String RESOURCE_LAST_NAMES = "/people/all-last.nameset";
    private static final NameGeneratorCache instance = new NameGeneratorCache();
    private LoadingCache<String, NameGenerator> cache = CacheBuilder.newBuilder().maximumSize(5L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, NameGenerator>(){

        public NameGenerator load(String key) {
            return NameGeneratorCache.this.loadNameGenerator(key);
        }
    });

    protected NameGeneratorCache() {
    }

    public static NameGenerator getGenerator(String key) {
        return (NameGenerator)NameGeneratorCache.instance.cache.getUnchecked((Object)key);
    }

    protected NameGenerator loadNameGenerator(String key) {
        InputStream in = this.getClass().getResourceAsStream(key);
        if (in == null) {
            throw new IllegalArgumentException("No resource found for:" + key);
        }
        try {
            return NameGenerator.read((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading nameset:" + key, e);
        }
    }
}

