/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.BoundaryShape;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellUtils {
    static Logger log = LoggerFactory.getLogger(CellUtils.class);

    public static CellArray reproject(CellArray cells, Vec3i xAxis, Vec3i zAxis) {
        Vec3i size = xAxis.mult(cells.getSizeX()).addLocal(zAxis.mult(cells.getSizeZ()));
        Vec3i start = new Vec3i();
        if (size.x < 0) {
            size.x = Math.abs(size.x);
            start.x = size.x - 1;
        }
        if (size.z < 0) {
            size.z = Math.abs(size.z);
            start.z = size.z - 1;
        }
        CellArray result = new CellArray(size.x, cells.getSizeY(), size.z);
        Vec3i pos = new Vec3i();
        for (int i = 0; i < cells.getSizeX(); ++i) {
            for (int k = 0; k < cells.getSizeZ(); ++k) {
                pos.set(start).addLocal(xAxis.mult(i));
                pos.addLocal(zAxis.mult(k));
                for (int j = 0; j < cells.getSizeY(); ++j) {
                    int val = cells.getCell(i, j, k);
                    int type = MaskUtils.getType(val);
                    result.setCell(pos.x, j, pos.z, type);
                }
            }
        }
        MaskUtils.calculateSideMasks(result);
        return result;
    }

    public static void copy(CellArray src, int xSource, int ySource, int zSource, CellArray dest, int xTarget, int yTarget, int zTarget, int xSize, int ySize, int zSize) {
        if (log.isTraceEnabled()) {
            log.trace("copy(" + src + ", " + xSource + ", " + ySource + ", " + zSource + ", " + dest + ", " + xTarget + ", " + yTarget + ", " + zTarget + ", " + xSize + ", " + ySize + ", " + zSize);
        }
        if (xSource + xSize > src.getSizeX() || ySource + ySize > src.getSizeY() || zSource + zSize > src.getSizeZ()) {
            throw new IllegalArgumentException("Source overflow");
        }
        if (xTarget + xSize > dest.getSizeX() || yTarget + ySize > dest.getSizeY() || zTarget + zSize > dest.getSizeZ()) {
            throw new IllegalArgumentException("Destination overflow");
        }
        CellUtils.copyData(src, xSource, ySource, zSource, dest, xTarget, yTarget, zTarget, xSize, ySize, zSize);
    }

    public static void copyData(CellData src, int xSource, int ySource, int zSource, CellData dest, int xTarget, int yTarget, int zTarget, int xSize, int ySize, int zSize) {
        if (log.isTraceEnabled()) {
            log.trace("copy(" + src + ", " + xSource + ", " + ySource + ", " + zSource + ", " + dest + ", " + xTarget + ", " + yTarget + ", " + zTarget + ", " + xSize + ", " + ySize + ", " + zSize);
        }
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int value = src.getCell(xSource + i, ySource + j, zSource + k);
                    dest.setCell(xTarget + i, yTarget + j, zTarget + k, value);
                }
            }
        }
    }

    public static void copy(CellArray src, int xSource, int ySource, int zSource, CellArray dest, int xTarget, int yTarget, int zTarget, int xSize, int ySize, int zSize, IntCombiner typeCombiner) {
        if (log.isTraceEnabled()) {
            log.trace("copy(" + src + ", " + xSource + ", " + ySource + ", " + zSource + ", " + dest + ", " + xTarget + ", " + yTarget + ", " + zTarget + ", " + xSize + ", " + ySize + ", " + zSize + ", " + typeCombiner + ")");
        }
        if (xSource + xSize > src.getSizeX() || ySource + ySize > src.getSizeY() || zSource + zSize > src.getSizeZ()) {
            throw new IllegalArgumentException("Source overflow");
        }
        if (xTarget + xSize > dest.getSizeX() || yTarget + ySize > dest.getSizeY() || zTarget + zSize > dest.getSizeZ()) {
            throw new IllegalArgumentException("Destination overflow");
        }
        CellUtils.copyData(src, xSource, ySource, zSource, dest, xTarget, yTarget, zTarget, xSize, ySize, zSize, typeCombiner);
    }

    public static void copyData(CellData src, int xSource, int ySource, int zSource, CellData dest, int xTarget, int yTarget, int zTarget, int xSize, int ySize, int zSize, IntCombiner typeCombiner) {
        if (log.isTraceEnabled()) {
            log.trace("copy(" + src + ", " + xSource + ", " + ySource + ", " + zSource + ", " + dest + ", " + xTarget + ", " + yTarget + ", " + zTarget + ", " + xSize + ", " + ySize + ", " + zSize + ", " + typeCombiner + ")");
        }
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int value = src.getCell(xSource + i, ySource + j, zSource + k);
                    int existing = dest.getCell(xTarget + i, yTarget + j, zTarget + k);
                    dest.setCell(xTarget + i, yTarget + j, zTarget + k, typeCombiner.apply(value, existing));
                }
            }
        }
    }

    public static CellArray trim(CellArray cells, int x, int y, int z, int xSize, int ySize, int zSize) {
        CellArray result = new CellArray(xSize, ySize, zSize);
        CellUtils.copy(cells, x, y, z, result, 0, 0, 0, xSize, ySize, zSize);
        return result;
    }

    public static Vec3i[] calculateSize(CellArray cells) {
        Vec3i min = new Vec3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Vec3i max = new Vec3i(0, 0, 0);
        int xSize = cells.getSizeX();
        int ySize = cells.getSizeY();
        int zSize = cells.getSizeZ();
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int val = cells.getCell(i, j, k);
                    if (val == 0) continue;
                    min = min.minLocal(i, j, k);
                    max = max.maxLocal(i, j, k);
                }
            }
        }
        min.minLocal(max);
        return new Vec3i[]{min, max};
    }

    public static String hashString(CellData cells, int x, int y, int z, int xSize, int ySize, int zSize) {
        return CellUtils.hashString(null, cells, x, y, z, xSize, ySize, zSize);
    }

    public static String hashString(String salt, CellData cells, int x, int y, int z, int xSize, int ySize, int zSize) {
        Hasher hasher = Hashing.crc32().newHasher();
        if (salt != null) {
            hasher.putUnencodedChars((CharSequence)salt);
        }
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int type = MaskUtils.getType(cells.getCell(x + i, y + j, z + k));
                    hasher.putInt(type);
                }
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(String.format("%02x%02x%02x", xSize, ySize, zSize));
        result.append(hasher.hash().toString());
        return result.toString();
    }

    public static byte[] hash(CellData cells, int x, int y, int z, int xSize, int ySize, int zSize) {
        return CellUtils.hash(null, cells, x, y, z, xSize, ySize, zSize);
    }

    public static byte[] hash(String salt, CellData cells, int x, int y, int z, int xSize, int ySize, int zSize) {
        Hasher hasher = Hashing.crc32().newHasher();
        if (salt != null) {
            hasher.putUnencodedChars((CharSequence)salt);
        }
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int type = MaskUtils.getType(cells.getCell(x + i, y + j, z + k));
                    hasher.putInt(type);
                }
            }
        }
        byte[] bytes = hasher.hash().asBytes();
        byte[] result = new byte[bytes.length + 3];
        result[0] = (byte)xSize;
        result[1] = (byte)ySize;
        result[2] = (byte)zSize;
        System.arraycopy(bytes, 0, result, 3, bytes.length);
        return result;
    }

    public static int getTypeRotation(int type, int rotate) {
        BlockType start = BlockTypeIndex.get(type);
        if (start == null) {
            return type;
        }
        BlockName name = start.getName();
        if (name.getRotation() == null) {
            return type;
        }
        BlockName find = name.rotate(rotate);
        int index = BlockTypeIndex.findType(find, -1);
        if (index >= 0) {
            return index;
        }
        find = name.rotate(rotate, 2);
        index = BlockTypeIndex.findType(find, -1);
        if (index >= 0) {
            return index;
        }
        return type;
    }

    public static int getTypeMirrorX(int type) {
        BlockType start = BlockTypeIndex.get(type);
        if (start == null) {
            return type;
        }
        BlockName name = start.getName();
        if (name.getRotation() == null) {
            return type;
        }
        BoundaryShape negative = start.getShape(Direction.West);
        BoundaryShape positive = start.getShape(Direction.East);
        if (positive.isMatchingFace(negative)) {
            return type;
        }
        BoundaryShape alt1 = start.getShape(Direction.North).rotate(Direction.North, 2);
        BoundaryShape alt2 = start.getShape(Direction.South).rotate(Direction.South, 2);
        for (int i = 1; i <= 3; ++i) {
            int newType = CellUtils.getTypeRotation(type, i);
            BlockType bt = BlockTypeIndex.get(newType);
            if (alt1 != bt.getShape(Direction.North) && !alt1.isMatchingFace(bt.getShape(Direction.North)) || alt2 != bt.getShape(Direction.South) && !alt2.isMatchingFace(bt.getShape(Direction.South))) continue;
            if (negative == bt.getShape(Direction.East) || negative.isMatchingFace(bt.getShape(Direction.East))) {
                return newType;
            }
            if (positive != bt.getShape(Direction.West) && !positive.isMatchingFace(bt.getShape(Direction.West))) continue;
            return newType;
        }
        return type;
    }

    public static int getTypeMirrorZ(int type) {
        BlockType start = BlockTypeIndex.get(type);
        if (start == null) {
            return type;
        }
        BlockName name = start.getName();
        if (name.getRotation() == null) {
            return type;
        }
        BoundaryShape negative = start.getShape(Direction.North);
        BoundaryShape positive = start.getShape(Direction.South);
        if (positive.isMatchingFace(negative)) {
            return type;
        }
        BoundaryShape alt1 = start.getShape(Direction.East).rotate(Direction.East, 2);
        BoundaryShape alt2 = start.getShape(Direction.West).rotate(Direction.West, 2);
        for (int i = 1; i <= 3; ++i) {
            int newType = CellUtils.getTypeRotation(type, i);
            BlockType bt = BlockTypeIndex.get(newType);
            if (alt1 != bt.getShape(Direction.East) && !alt1.isMatchingFace(bt.getShape(Direction.East)) || alt2 != bt.getShape(Direction.West) && !alt2.isMatchingFace(bt.getShape(Direction.West))) continue;
            if (negative == bt.getShape(Direction.South) || negative.isMatchingFace(bt.getShape(Direction.South))) {
                return newType;
            }
            if (positive != bt.getShape(Direction.North) && !positive.isMatchingFace(bt.getShape(Direction.North))) continue;
            return newType;
        }
        return type;
    }

    public static CellArray rotate(CellArray cells, int rotate) {
        if ((rotate %= 4) < 0) {
            rotate += 4;
        }
        Vec3i xAxis = Direction.East.rotate(rotate).getVec3i();
        Vec3i zAxis = Direction.South.rotate(rotate).getVec3i();
        CellArray results = CellUtils.reproject(cells, xAxis, zAxis);
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        int[] array = results.getArray();
        for (int i = 0; i < array.length; ++i) {
            int val = array[i];
            int type = MaskUtils.getType(val);
            Integer newType = (Integer)remap.get(type);
            if (newType == null) {
                newType = CellUtils.getTypeRotation(type, rotate);
                remap.put(type, newType);
            }
            array[i] = newType;
        }
        return results;
    }

    public static CellArray mirrorX(CellArray cells) {
        Vec3i xAxis = new Vec3i(-1, 0, 0);
        Vec3i zAxis = new Vec3i(0, 0, 1);
        CellArray results = CellUtils.reproject(cells, xAxis, zAxis);
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        int[] array = results.getArray();
        for (int i = 0; i < array.length; ++i) {
            int val = array[i];
            int type = MaskUtils.getType(val);
            Integer newType = (Integer)remap.get(type);
            if (newType == null) {
                newType = CellUtils.getTypeMirrorX(type);
                remap.put(type, newType);
            }
            array[i] = newType;
        }
        return results;
    }

    public static CellArray mirrorZ(CellArray cells) {
        Vec3i xAxis = new Vec3i(1, 0, 0);
        Vec3i zAxis = new Vec3i(0, 0, -1);
        CellArray results = CellUtils.reproject(cells, xAxis, zAxis);
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        int[] array = results.getArray();
        for (int i = 0; i < array.length; ++i) {
            int val = array[i];
            int type = MaskUtils.getType(val);
            Integer newType = (Integer)remap.get(type);
            if (newType == null) {
                newType = CellUtils.getTypeMirrorZ(type);
                remap.put(type, newType);
            }
            array[i] = newType;
        }
        return results;
    }
}

