/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.db;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellArrayId {
    static Logger log = LoggerFactory.getLogger(CellArrayId.class);
    private long id;

    private CellArrayId() {
    }

    public CellArrayId(long id) {
        this.id = id;
    }

    public static CellArrayId fromString(String s) {
        return new CellArrayId(Long.parseUnsignedLong(s, 16));
    }

    public static CellArrayId fromFileName(String s) {
        if (!s.endsWith(".ca")) {
            throw new IllegalArgumentException("String is not in filename form, no .ca extension:" + s);
        }
        s = s.substring(0, s.length() - 3);
        return CellArrayId.fromString(s);
    }

    public long getId() {
        return this.id;
    }

    public String toIdString() {
        return String.format("%x", this.id);
    }

    public String toFileName() {
        return String.format("%x.ca", this.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CellArrayId other = (CellArrayId)o;
        return other.id == this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.id + "]";
    }
}

