/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageType;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewWorldPreloader
implements Runnable {
    static Logger log = LoggerFactory.getLogger(NewWorldPreloader.class);
    private WorldManager worldManager;
    private Vec3i center;
    private int columnRadius = 3;
    private int nearRadius = 2;
    private int farRadius = 7;
    private AtomicBoolean keepGoing = new AtomicBoolean(true);

    public NewWorldPreloader(WorldManager worldManager, Vec3i center) {
        this.worldManager = worldManager;
        this.center = center;
    }

    public NewWorldPreloader(WorldManager worldManager) {
        this(worldManager, worldManager.getInfo().getSpawnPoint().floor());
    }

    public void cancel() {
        log.info("Requesting cancel...");
        this.keepGoing.set(false);
    }

    @Override
    public void run() {
        TileId tileId;
        int z;
        int x;
        log.info("Preloading world data...");
        HashSet<SedectileId> sedectiles = new HashSet<SedectileId>();
        for (int x2 = -this.farRadius; x2 <= this.farRadius; ++x2) {
            for (int z2 = -this.farRadius; z2 <= this.farRadius; ++z2) {
                SedectileId id = SedectileId.fromWorld((Vec3i)this.center.add(x2 * 1024, 0, z2 * 1024));
                sedectiles.add(id);
            }
        }
        for (SedectileId id : sedectiles) {
            if (!this.keepGoing.get()) {
                log.info("Canceling preload.");
                return;
            }
            log.info("Loading:" + id);
            this.worldManager.getSedectileManager().getSedectile(id);
        }
        World world = this.worldManager.getWorld();
        HashSet<TileId> hires = new HashSet<TileId>();
        for (x = -this.nearRadius; x <= this.nearRadius; ++x) {
            for (z = -this.nearRadius; z <= this.nearRadius; ++z) {
                if (!this.keepGoing.get()) {
                    log.info("Canceling preload.");
                    return;
                }
                tileId = TileId.fromWorld((Vec3i)this.center.add(x * 1024, 0, z * 1024));
                hires.add(tileId);
                log.info("Loading tile:" + tileId.getWorld(null) + " terrain...");
                world.getTerrainImage(tileId, TerrainImageType.Terrain, Resolution.High);
                log.info("Loading tile:" + tileId.getWorld(null) + " trees...");
                world.getTrees(tileId, Resolution.High);
                log.info("Loading tile:" + tileId.getWorld(null) + " far buildings...");
                world.getPointCloudLayer(tileId, Resolution.High);
            }
        }
        for (x = -this.farRadius; x <= this.farRadius; ++x) {
            for (z = -this.farRadius; z <= this.farRadius; ++z) {
                if (!this.keepGoing.get()) {
                    log.info("Canceling preload.");
                    return;
                }
                tileId = TileId.fromWorld((Vec3i)this.center.add(x * 1024, 0, z * 1024));
                if (hires.contains(tileId)) continue;
                log.info("Loading tile:" + tileId.getWorld(null) + " low-res terrain...");
                world.getTerrainImage(tileId, TerrainImageType.Terrain, Resolution.Low);
            }
        }
    }
}

