/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.opengl;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolution
implements Comparable<Resolution> {
    static Logger log = LoggerFactory.getLogger(Resolution.class);
    private int width;
    private int height;

    private Resolution() {
    }

    public Resolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String aspectRatioToString() {
        double ratio = (double)this.width / (double)this.height;
        for (int i = 2; i <= 25; ++i) {
            if (!(Math.abs(ratio * (double)i - (double)((int)Math.round(ratio * (double)i))) < 0.001)) continue;
            return String.format("%d:%d", (int)Math.round(ratio * (double)i), i);
        }
        return String.format("%f", ratio);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Resolution other = (Resolution)o;
        if (other.width != this.width) {
            return false;
        }
        return other.height == this.height;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }

    @Override
    public int compareTo(Resolution r) {
        if (this.width < r.width) {
            return -1;
        }
        if (this.width > r.width) {
            return 1;
        }
        if (this.height < r.height) {
            return -1;
        }
        if (this.height > r.height) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return String.format("%d x %d", this.width, this.height);
    }
}

