/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.asset.AssetManager;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.style.ElementId;
import mythruna.GameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPreview
extends Container {
    static Logger log = LoggerFactory.getLogger(MapPreview.class);
    private Label preview = (Label)this.addChild((Node)new Label("Preview", new ElementId("map.preview.image")), new Object[0]);
    private Node overlayRoot;
    private Container legend;

    public MapPreview(AssetManager assets) {
        super(new ElementId("map.preview.container"));
        Texture hex = assets.loadTexture("Textures/hexagon-grid.png");
        hex.setWrap(Texture.WrapMode.Repeat);
        QuadBackgroundComponent hexComp = new QuadBackgroundComponent(hex, 0.0f, 0.0f);
        ((GuiControl)this.preview.getControl(GuiControl.class)).addComponent((GuiComponent)hexComp);
        this.preview.setPreferredSize(new Vector3f(384.0f, 384.0f, 1.0f));
        double previewSize = GameConstants.MAP_PREVIEW_RANGE;
        double hexHeight = 3072.0;
        double hexWidth = 3072.0 * Math.sqrt(3.0);
        hexComp.setTextureCoordinateScale(new Vector2f((float)(previewSize / hexWidth), (float)(previewSize / hexHeight)));
        Node legendRoot = this.overlayRoot = new Node("mapLegend");
        this.preview.attachChild((Spatial)legendRoot);
        legendRoot.move(0.0f, 0.0f, 1.0f);
        this.legend = new Container(new ElementId("map.legend.window"));
        legendRoot.attachChild((Spatial)this.legend);
        float iconScale = 0.2f;
        ((Label)this.legend.addChild((Node)new Label("- Spawn", new ElementId("map.legend.label")), new Object[0])).setIcon((GuiComponent)new IconComponent("Interface/spawn-icon.png", iconScale));
        ((Label)this.legend.addChild((Node)new Label("- 1 day's travel", new ElementId("map.legend.label")), new Object[0])).setIcon((GuiComponent)new IconComponent("Interface/hex-icon.png", iconScale));
        ((Label)this.legend.addChild((Node)new Label("- Desert", new ElementId("map.legend.label")), new Object[0])).setIcon((GuiComponent)new IconComponent("Interface/sand-icon.png", iconScale));
        ((Label)this.legend.addChild((Node)new Label("- Cold desert", new ElementId("map.legend.label")), new Object[0])).setIcon((GuiComponent)new IconComponent("Interface/dirt-icon.png", iconScale));
        ((Label)this.legend.addChild((Node)new Label("- Snow/ice sheet", new ElementId("map.legend.label")), new Object[0])).setIcon((GuiComponent)new IconComponent("Interface/snow-ice-icon.png", iconScale));
        Vector3f pref = this.legend.getPreferredSize();
        Vector3f mapSize = this.preview.getPreferredSize();
        float margin = 5.0f;
        this.legend.setLocalTranslation(margin, -mapSize.y + pref.y + margin, 0.0f);
    }

    public void setLabel(String label) {
        this.preview.setText(label);
    }

    public void setMap(String label, GuiComponent map) {
        this.preview.setText(label);
        this.preview.setIcon(map);
    }

    public Node getOverlayRoot() {
        return this.overlayRoot;
    }
}

