/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.ui.ScreenAnnotation;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.WorldViewState;
import mythruna.es.CharacterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenAnnotationsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ScreenAnnotationsState.class);
    private GameSessionState gameSession;
    private AvatarState avatar;
    private WorldTimeState timeState;
    private EntityData ed;
    private Map<String, Supplier<Object>> values = new HashMap<String, Supplier<Object>>();
    private List<AnnotationView> views = new ArrayList<AnnotationView>();
    private boolean attached = false;
    private VersionedReference<Vec3d> posRef;

    public void addAnnotation(ScreenAnnotation annotation) {
        AnnotationView view = new AnnotationView(annotation);
        if (this.attached) {
            view.resetAttached();
        }
        this.views.add(view);
    }

    public void removeAnnotation(ScreenAnnotation annotation) {
        Iterator<AnnotationView> it = this.views.iterator();
        while (it.hasNext()) {
            AnnotationView view = it.next();
            if (view.annotation != annotation) continue;
            view.detach();
            it.remove();
        }
    }

    protected void initialize(Application app) {
        this.gameSession = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.gameSession.getEntityData();
        this.avatar = (AvatarState)this.getState(AvatarState.class, true);
        this.timeState = (WorldTimeState)this.getState(WorldTimeState.class, true);
        this.posRef = this.avatar.createPositionReference();
        this.values.put("character", () -> {
            EntityId avatarId = this.avatar.getAvatarId();
            Name name = (Name)this.ed.getComponent(avatarId, Name.class);
            if (name != null) {
                return name.getName();
            }
            CharacterName cn = (CharacterName)this.ed.getComponent(avatarId, CharacterName.class);
            return cn == null ? null : cn.getFullName();
        });
        this.values.put("coordinate", () -> {
            Vec3d pos = (Vec3d)this.posRef.get();
            return String.format("%,d x %,d", (int)pos.x, (int)pos.z);
        });
        this.values.put("world.seed", () -> ((WorldViewState)this.getState(WorldViewState.class)).getWorldSeed());
        this.values.put("seed", this.values.get("world.seed"));
        this.values.put("world.name", () -> this.gameSession.getWorldName());
        this.values.put("time", () -> this.timeState.getWorldTime().asFullString());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("Annotations enabled");
        for (AnnotationView view : this.views) {
            view.resetAttached();
        }
        this.attached = true;
    }

    protected void onDisable() {
        log.info("Annotations disabled");
        for (AnnotationView view : this.views) {
            view.detach();
        }
        this.attached = false;
    }

    public void update(float tpf) {
        for (AnnotationView view : this.views) {
            view.update();
        }
    }

    private class AnnotationView {
        private ScreenAnnotation annotation;
        private VersionedReference<String> textRef;
        private VersionedReference<Boolean> enabledRef;
        private float margin = 10.0f;
        private Label label;
        private Vector2f anchor;
        private float angleRads = 0.15f;
        private VersionedReference<String> fontRef;
        private VersionedReference<Float> angleRef;
        private VersionedReference<Float> scaleRef;
        private VersionedReference<ColorRGBA> colorRef;
        private VersionedReference<ColorRGBA> shadowColorRef;
        private VersionedReference<Vector2f> anchorRef;

        public AnnotationView(ScreenAnnotation annotation) {
            this.annotation = annotation;
            this.anchor = annotation.getAnchor();
            this.textRef = annotation.createValueRef();
            this.enabledRef = annotation.createEnabledRef();
            this.angleRads = (float)Math.toRadians(annotation.getAngle());
            this.fontRef = annotation.createFontRef();
            this.angleRef = annotation.createAngleRef();
            this.scaleRef = annotation.createScaleRef();
            this.colorRef = annotation.createColorRef();
            this.shadowColorRef = annotation.createShadowColorRef();
            this.anchorRef = annotation.createAnchorRef();
            this.label = new Label((String)this.textRef.get());
            this.label.setColor(annotation.getColor());
            this.label.setShadowColor(annotation.getShadowColor());
            this.label.setTextHAlignment(HAlignment.Center);
            this.resetFont();
            this.resetAngle();
            this.resetPosition();
        }

        public void resetAttached() {
            if (Boolean.TRUE.equals(this.enabledRef.get())) {
                this.attach();
            } else {
                this.detach();
            }
        }

        public void attach() {
            ((GuiState)ScreenAnnotationsState.this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.label);
        }

        public void detach() {
            this.label.removeFromParent();
        }

        public void update() {
            if (this.enabledRef.update()) {
                this.resetAttached();
            }
            if (!Boolean.TRUE.equals(this.enabledRef.get())) {
                return;
            }
            this.annotation.update(ScreenAnnotationsState.this.values);
            boolean moved = false;
            if (this.colorRef.update()) {
                this.label.setColor(this.annotation.getColor());
            }
            if (this.shadowColorRef.update()) {
                this.label.setShadowColor(this.annotation.getShadowColor());
            }
            if (this.anchorRef.update()) {
                this.anchor = this.annotation.getAnchor();
                moved = true;
            }
            if (this.fontRef.update()) {
                this.resetFont();
                moved = true;
            }
            if (this.angleRef.update()) {
                this.angleRads = (float)Math.toRadians(this.annotation.getAngle());
                this.resetAngle();
                moved = true;
            }
            if (this.scaleRef.update()) {
                this.label.setFontSize(this.label.getFont().getPreferredSize() * this.annotation.getScale());
                moved = true;
            }
            if (this.textRef.update()) {
                this.label.setText((String)this.textRef.get());
                this.label.setSize(this.label.getPreferredSize());
                moved = true;
            }
            if (moved) {
                this.resetPosition();
            }
        }

        protected void resetFont() {
            String font = (String)this.fontRef.get();
            if (font == null) {
                font = "fonts/Scriptina.fnt";
            }
            this.label.setFont(GuiGlobals.getInstance().loadFont(font));
            this.label.setFontSize(this.label.getFont().getPreferredSize() * this.annotation.getScale());
        }

        protected void resetAngle() {
            this.label.setLocalRotation(new Quaternion());
            this.label.rotate(0.0f, 0.0f, this.angleRads);
        }

        protected void resetPosition() {
            if (log.isTraceEnabled()) {
                log.trace("resetPosition()");
            }
            Vector2f guiSize = ((GuiState)ScreenAnnotationsState.this.getState(GuiState.class)).getGuiSize();
            this.label.removeFromParent();
            this.label.setLocalTranslation(0.0f, 0.0f, 0.0f);
            this.label.setSize(this.label.getPreferredSize());
            BoundingBox box = (BoundingBox)this.label.getWorldBound();
            this.resetAttached();
            Vector2f desiredCenter = guiSize.mult(0.5f);
            desiredCenter.x = (float)((double)desiredCenter.x + (double)(this.anchor.x * guiSize.x) * 0.5);
            desiredCenter.y = (float)((double)desiredCenter.y + (double)(this.anchor.y * guiSize.y) * 0.5);
            if (desiredCenter.x - box.getXExtent() - this.margin < 0.0f) {
                desiredCenter.x = box.getXExtent() + this.margin;
            } else if (desiredCenter.x + box.getXExtent() + this.margin > guiSize.x) {
                desiredCenter.x = guiSize.x - (box.getXExtent() + this.margin);
            }
            if (desiredCenter.y - box.getYExtent() - this.margin < 0.0f) {
                desiredCenter.y = box.getYExtent() + this.margin;
            } else if (desiredCenter.y + box.getYExtent() + this.margin > guiSize.y) {
                desiredCenter.y = guiSize.y - (box.getYExtent() + this.margin);
            }
            Vector3f pos = new Vector3f();
            pos.x = desiredCenter.x - box.getCenter().x;
            pos.y = desiredCenter.y - box.getCenter().y;
            this.label.setLocalTranslation(pos);
        }
    }
}

