/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialComponent
extends AbstractGuiComponent
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(SpatialComponent.class);
    private Node holder = new Node("holder");
    private Spatial spatial;
    private float xMargin;
    private float yMargin;
    private float zMargin;
    private Vector3f maxSize;
    private HAlignment hAlign;
    private VAlignment vAlign;
    private Vector3f center;
    private Vector3f extents;
    private Vector3f spatialSize;

    public SpatialComponent(Spatial spatial) {
        this(spatial, 0.0f, 0.0f, 0.0f, HAlignment.Center, VAlignment.Center);
    }

    public SpatialComponent(Spatial spatial, float xMargin, float yMargin, float zMargin, HAlignment hAlign, VAlignment vAlign) {
        this.spatial = spatial;
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.zMargin = zMargin;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public void setSpatial(Spatial spatial) {
        if (this.spatial == spatial) {
            return;
        }
        if (this.spatial != null) {
            this.spatial.removeFromParent();
        }
        this.spatial = spatial;
        this.invalidate();
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public void setMaxSize(double x, double y, double z) {
        this.setMaxSize(new Vector3f((float)x, (float)y, (float)z));
    }

    public void setMaxSize(Vector3f maxSize) {
        this.maxSize = maxSize;
    }

    public Vector3f getMaxSize() {
        return this.maxSize;
    }

    public void setHAlignment(HAlignment a) {
        if (this.hAlign == a) {
            return;
        }
        this.hAlign = a;
        this.invalidate();
    }

    public HAlignment getHAlignment() {
        return this.hAlign;
    }

    public void setVAlignment(VAlignment a) {
        if (this.vAlign == a) {
            return;
        }
        this.vAlign = a;
        this.invalidate();
    }

    public VAlignment getVAlignment() {
        return this.vAlign;
    }

    public void setMargin(float x, float y, float z) {
        this.xMargin = x;
        this.yMargin = y;
        this.zMargin = z;
        this.invalidate();
    }

    public void setMargin(Vector3f margin) {
        if (margin == null) {
            throw new IllegalArgumentException("Margin cannot be null");
        }
        this.setMargin(margin.x, margin.y, margin.z);
    }

    public Vector3f getMargin() {
        return new Vector3f(this.xMargin, this.yMargin, this.zMargin);
    }

    public SpatialComponent clone() {
        SpatialComponent result = (SpatialComponent)super.clone();
        return result;
    }

    public void attach(GuiControl parent) {
        super.attach(parent);
        this.getNode().attachChild((Spatial)this.holder);
    }

    public void detach(GuiControl parent) {
        this.getNode().detachChild((Spatial)this.holder);
        super.detach(parent);
    }

    protected Vector3f toExtents(BoundingVolume vol) {
        if (vol == null) {
            throw new IllegalArgumentException("BoundingVolume cannot be null");
        }
        if (vol instanceof BoundingBox) {
            BoundingBox b = (BoundingBox)vol;
            return new Vector3f(b.getXExtent(), b.getYExtent(), b.getZExtent());
        }
        if (vol instanceof BoundingSphere) {
            BoundingSphere b = (BoundingSphere)vol;
            float r = b.getRadius();
            return new Vector3f(r, r, r);
        }
        throw new IllegalArgumentException("Unsupported bounding box type:" + vol);
    }

    public void calculatePreferredSize(Vector3f size) {
        this.spatial.removeFromParent();
        this.spatial.center();
        BoundingVolume bounds = this.spatial.getWorldBound();
        this.holder.attachChild(this.spatial);
        this.center = bounds.getCenter();
        this.extents = this.toExtents(bounds);
        this.spatialSize = this.extents.mult(2.0f);
        float x = this.maxSize == null ? this.spatialSize.x : Math.min(this.maxSize.x, this.spatialSize.x);
        float y = this.maxSize == null ? this.spatialSize.y : Math.min(this.maxSize.y, this.spatialSize.y);
        switch (this.vAlign) {
            case Top: 
            case Bottom: {
                size.y += y + this.yMargin * 2.0f;
                break;
            }
            case Center: {
                size.y = Math.max(y + this.yMargin * 2.0f, size.y);
            }
        }
        switch (this.hAlign) {
            case Left: 
            case Right: {
                size.x += x + this.xMargin * 2.0f;
                break;
            }
            case Center: {
                size.x = Math.max(x + this.xMargin * 2.0f, size.x);
            }
        }
    }

    public void reshape(Vector3f pos, Vector3f size) {
        float yScale;
        float x = Math.min(this.spatialSize.x, size.x);
        float y = Math.min(this.spatialSize.y, size.y);
        float scale = 1.0f;
        if (this.maxSize != null) {
            x = Math.min(this.maxSize.x, this.spatialSize.x);
            y = Math.min(this.maxSize.y, this.spatialSize.y);
        }
        if (this.spatialSize.x > x && x > 0.0f) {
            scale = x / this.spatialSize.x;
        }
        if (this.spatialSize.y > y && y > 0.0f && (yScale = y / this.spatialSize.y) < scale) {
            scale = yScale;
        }
        x = this.spatialSize.x * scale;
        y = this.spatialSize.y * scale;
        this.holder.setLocalScale(scale);
        x += this.xMargin * 2.0f;
        y += this.yMargin * 2.0f;
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        switch (this.hAlign) {
            case Left: {
                cx = pos.x + this.extents.x * scale + this.xMargin;
                pos.x += x;
                size.x -= x;
                break;
            }
            case Right: {
                cx = pos.x + size.x - this.extents.x * scale - this.xMargin;
                size.x -= x;
                break;
            }
            case Center: {
                cx = pos.x + size.x * 0.5f;
            }
        }
        switch (this.vAlign) {
            case Top: {
                cy = pos.y - this.extents.y * scale - this.yMargin;
                pos.y -= y;
                size.y -= y;
                break;
            }
            case Bottom: {
                cy = pos.y - size.y + this.extents.y * scale + this.yMargin;
                size.y -= y;
                break;
            }
            case Center: {
                cy = pos.y - size.y * 0.5f;
            }
        }
        cz = pos.z + size.z * 0.5f;
        this.holder.setLocalTranslation(cx -= this.center.x, cy -= this.center.y, cz -= this.center.z);
    }
}

