/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.net;

import com.jme3.network.serializing.Serializer;
import com.jme3.network.serializing.SerializerRegistration;
import com.jme3.network.serializing.serializers.StringSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ClassFieldSerializer
extends Serializer {
    private StringSerializer delegate = new StringSerializer();

    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        SerializerRegistration reg = ClassFieldSerializer.readClass((ByteBuffer)data);
        if (reg == null || reg.getType() == Void.class) {
            return null;
        }
        Class type = reg.getType();
        String name = this.delegate.readObject(data, String.class);
        try {
            Field result = type.getDeclaredField(name);
            return c.cast(result);
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Error resolving field:" + name + " on:" + type, e);
        }
    }

    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        Field field = (Field)object;
        ClassFieldSerializer.writeClass((ByteBuffer)buffer, field.getDeclaringClass());
        this.delegate.writeObject(buffer, (Object)field.getName());
    }
}

