/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.RigTypeInitializer;
import com.simsilica.crig.jme.SpatialRigType;
import com.simsilica.crig.jme.VariationHandler;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasCellVariationInitializer
implements RigTypeInitializer,
Serializable {
    static Logger log = LoggerFactory.getLogger(AtlasCellVariationInitializer.class);
    static final long serialVersionUID = 42L;
    private String variantName;
    private String materialName;
    private String materialParameter;
    private int atlasWidth;
    private int atlasHeight;

    private AtlasCellVariationInitializer() {
    }

    public AtlasCellVariationInitializer(String variantName, String materialName, String materialParameter, int atlasSize) {
        this(variantName, materialName, materialParameter, atlasSize, atlasSize);
    }

    public AtlasCellVariationInitializer(String variantName, String materialName, String materialParameter, int atlasWidth, int atlasHeight) {
        this.variantName = variantName;
        this.materialName = materialName;
        this.materialParameter = materialParameter;
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
    }

    @Override
    public void initializeRigType(SpatialRigType rigType) {
        rigType.setVariationHandler(this.variantName, new Handler(this.variantName, this.materialName, this.materialParameter, this.atlasWidth, this.atlasHeight));
    }

    public static class Handler
    implements VariationHandler,
    Serializable {
        static final long serialVersionUID = 42L;
        private String variantName;
        private String materialName;
        private String materialParameter;
        private int atlasWidth;
        private int atlasHeight;

        public Handler(String variantName, String materialName, String materialParameter, int atlasWidth, int atlasHeight) {
            this.variantName = variantName;
            this.materialName = materialName;
            this.materialParameter = materialParameter;
            this.atlasWidth = atlasWidth;
            this.atlasHeight = atlasHeight;
        }

        @Override
        public boolean setVariationType(AnimComposerRig rig, String name, int index) {
            Spatial spatial = rig.getAnimComposer().getSpatial();
            int row = index / this.atlasWidth;
            int col = index % this.atlasWidth;
            final Vector2f offset = new Vector2f((float)col / (float)this.atlasWidth, (float)row / (float)this.atlasHeight);
            if (log.isTraceEnabled()) {
                log.trace("setVariationType(" + name + ", " + index + ") row:" + row + ", col:" + col + ", offset:" + offset);
            }
            if (this.materialName == null) {
                MatParamOverride existing = this.findOverride(spatial, this.materialParameter);
                if (existing != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("removing:" + existing);
                    }
                    spatial.removeMatParamOverride(existing);
                }
                MatParamOverride mp = new MatParamOverride(VarType.Vector2, this.materialParameter, (Object)offset);
                if (log.isTraceEnabled()) {
                    log.trace("adding:" + mp);
                }
                spatial.addMatParamOverride(mp);
            } else {
                spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                    public void visit(Geometry geom) {
                        if (log.isTraceEnabled()) {
                            log.trace("visit(" + geom + ")");
                        }
                        Material mat = geom.getMaterial();
                        if (log.isTraceEnabled()) {
                            log.trace("material:" + mat + "  name:" + mat.getName());
                        }
                        if (!Objects.equals(materialName, mat.getName())) {
                            return;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Setting " + materialParameter + " to:" + offset);
                        }
                        mat.setVector2(materialParameter, offset);
                    }
                });
            }
            return true;
        }

        protected MatParamOverride findOverride(Spatial spatial, String name) {
            for (MatParamOverride mp : (MatParamOverride[])spatial.getLocalMatParamOverrides().getArray()) {
                if (!name.equals(mp.getName())) continue;
                return mp;
            }
            return null;
        }
    }
}

