/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.fsm.StateMachine;
import com.simsilica.input.MovementState;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mworld.World;
import com.simsilica.mworld.view.FarTerrainState;
import com.simsilica.mworld.view.PointCloudState;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.TreeState;
import com.simsilica.sim.Blackboard;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.CameraState;
import com.simsilica.state.CommandConsoleState;
import com.simsilica.state.CompositeAppState;
import com.simsilica.state.GameSystemsState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mythruna.GameConstants;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.ClientGameSystemManager;
import mythruna.client.ClientModManagerState;
import mythruna.client.GameSettingsState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.NetworkState;
import mythruna.client.net.TimeState;
import mythruna.client.net.WorldPreloader;
import mythruna.client.sound.SoundState;
import mythruna.client.ui.ContainerViewState;
import mythruna.client.ui.FlyOverState;
import mythruna.client.ui.HelpMenuState;
import mythruna.client.ui.InGameMenuState;
import mythruna.client.ui.OverlaySettingsState;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.ScreenAnnotationsState;
import mythruna.client.ui.UserPromptState;
import mythruna.client.ui.detail.DetailViewState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.DebugShapeViewState;
import mythruna.client.view.EnvironmentState;
import mythruna.client.view.HudStatsState;
import mythruna.client.view.PhysicsDebugState;
import mythruna.client.view.PickState;
import mythruna.client.view.SoundViewState;
import mythruna.client.view.TerrainMaterials;
import mythruna.client.view.VisionEffectState;
import mythruna.client.view.WorldMarkerState;
import mythruna.client.view.WorldTimeState;
import mythruna.client.view.WorldViewState;
import mythruna.client.view.geom.MythrunaGeometryFactory;
import mythruna.client.view.input.ActivationInputState;
import mythruna.client.view.input.BlockTypeSelectionState;
import mythruna.client.view.input.ShellState;
import mythruna.client.view.object.CharacterAnimationState;
import mythruna.client.view.object.ClaimAreaState;
import mythruna.client.view.object.ClaimViewState;
import mythruna.client.view.object.ModelViewState;
import mythruna.client.view.object.MorphViewState;
import mythruna.client.view.object.ObjectTextViewState;
import mythruna.net.DataSession;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.client.GameSessionClientService;
import mythruna.shape.ShapeCache;
import mythruna.shape.ShapeRegistryBuilder;
import mythruna.sim.time.WorldTimeSettingsSystem;
import mythruna.world.WorldTime;
import mythruna.world.es.WorldAge;
import mythruna.world.es.WorldSeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameSessionState
extends CompositeAppState {
    static Logger log = LoggerFactory.getLogger(GameSessionState.class);
    public static final String SESSION_BLACKBOARD = "session";
    private GameSessionClientService session;
    private WorldPreloader preloader;
    private boolean singlePlayer;
    private Map<String, Material> materials;
    private GeometryFactory geomFactory;
    private GeometryFactory modelGeomFactory;
    private Set<String> uncarvable = new HashSet<String>();
    private Predicate<Geometry> carveIncludes = new Predicate<Geometry>(){

        @Override
        public boolean test(Geometry geom) {
            return !GameSessionState.this.uncarvable.contains(geom.getMaterial().getName());
        }
    };
    private ShapeFactoryRegistry<MBlockShape> shapeFactoryRegistry;
    private ShapeFactory<MBlockShape> shapeFactory;
    private StateMachine<String, String> uiFsm;
    private WorldTimeSettingsSystem timeSettings;
    private String worldName;
    private boolean test = true;
    public static final String T_EXIT = "exit";
    public static final String T_RETURN_TO_GAME = "returnToGame";
    public static final String T_OPEN_GAME_MENU = "openGameMenu";
    public static final String T_OPEN_PLAYER_BOOK = "openPlayerBook";
    public static final String T_CLOSE_PLAYER_BOOK = "closePlayerBook";
    public static final String T_OPEN_CONTAINER_VIEW = "openContainerView";
    public static final String T_OPEN_SETTINGS_MENU = "openSettingsMenu";
    public static final String T_SELECT_TYPE = "selectType";
    public static final String T_OPEN_HELP = "openHelp";
    public static final String T_OPEN_PROMPT = "openPrompt";
    public static final String T_CLOSE_PROMPT = "closePrompt";
    public static final String T_OPEN_MISC_POPUP = "openMiscPopup";
    public static final String T_CLOSE_MISC_POPUP = "closeMiscPopup";
    public static final String T_OPEN_CONSOLE = "openConsole";
    public static final String T_CLOSE_CONSOLE = "closeConsole";
    public static final String STATE_IN_GAME = "In Game";
    public static final String STATE_GAME_MENU = "Game Menu";
    public static final String STATE_PLAYER_BOOK = "Player Book";
    public static final String STATE_CONTAINER_VIEW = "Container View";
    public static final String STATE_SETTINGS = "Settings";
    public static final String STATE_SELECT_TYPE = "Select Type";
    public static final String STATE_HELP = "Help";
    public static final String STATE_PROMPT = "Prompt";
    public static final String STATE_CONSOLE = "Console";
    public static final String T_OPEN_DETAIL_VIEW = "openDetailView";
    public static final String STATE_DETAIL_VIEW = "Detail View";
    public static final String STATE_BOOK_PROMPT = "Book Prompt";
    public static final String STATE_MISC_POPUP = "Misc. Popup";
    private Spatial miscPopup;

    public GameSessionState(WorldPreloader preloader, boolean singlePlayer) {
        super(new AppState[]{new MovementState(), new CameraState(), new BlackboardState(SESSION_BLACKBOARD)});
        this.preloader = preloader;
        this.singlePlayer = singlePlayer;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public GameSession getGameSession() {
        return this.session;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geomFactory;
    }

    public GeometryFactory getModelGeometryFactory() {
        return this.modelGeomFactory;
    }

    public Predicate<Geometry> getCarveIncludes() {
        return this.carveIncludes;
    }

    public ShapeFactory<MBlockShape> getShapeFactory() {
        return this.shapeFactory;
    }

    public Map<String, Material> getBlockMaterials() {
        return this.materials;
    }

    public World getWorld() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
    }

    public EntityId getWorldEntity() {
        return this.preloader.getWorldEntity();
    }

    public EntityData getEntityData() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
    }

    public DataSession getDataSession() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getService(DataSession.class);
    }

    public TimeSource getTimeSource() {
        return ((ConnectionState)this.getState(ConnectionState.class, true)).getRemoteTimeSource();
    }

    public WorldTimeSettingsSystem getTimeSettings() {
        return this.timeSettings;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void addGameSessionListener(GameSessionListener l) {
        this.session.addGameSessionListener(l);
    }

    public void removeGameSessionListener(GameSessionListener l) {
        this.session.removeGameSessionListener(l);
    }

    protected void clearCache() {
        log.info("clearCache()");
        this.preloader.release();
        this.test = false;
    }

    public void exit() {
        log.info("exit()");
        ((SoundState)this.getState(SoundState.class)).stopAll(5.0f);
        this.uiFsm.trigger((Object)T_EXIT);
        log.info("disabling self");
        this.setEnabled(false);
        log.info("Triggering network state EXIT");
        ((NetworkState)this.getState(NetworkState.class)).trigger(T_EXIT);
        log.info("detaching self");
        this.getApplication().getStateManager().detach((AppState)this);
    }

    protected void initialize(Application app) {
        log.info("initialize()");
        this.addChild((AppState)new BackgroundRetrieverState("regularWorkers"));
        ClientGameSystemManager systems = new ClientGameSystemManager(((TimeState)this.getState(TimeState.class, true)).getTimeSource());
        this.addChild((AppState)new GameSystemsState((GameSystemManager)systems, false));
        systems.register(EntityData.class, this.getEntityData());
        systems.register(World.class, this.getWorld());
        systems.register(SpawnPosition.class, this.preloader.getPlayerStart());
        systems.register(WorldAge.class, this.preloader.getWorldAge());
        systems.register(WorldSeed.class, this.preloader.getWorldSeed());
        this.worldName = this.preloader.getWorldName();
        WorldTime worldTime = new WorldTime();
        systems.register(WorldTime.class, worldTime);
        this.timeSettings = new WorldTimeSettingsSystem();
        systems.register(WorldTimeSettingsSystem.class, this.timeSettings);
        Blackboard blackboard = ((BlackboardState)this.getState(SESSION_BLACKBOARD, BlackboardState.class, true)).getBlackboard();
        blackboard.set(World.class, (Object)this.getWorld());
        this.addChild((AppState)new WorldTimeState());
        this.addChild((AppState)new AvatarState());
        this.addChild((AppState)new VisionEffectState());
        this.addChild((AppState)new ActivationInputState());
        this.addChild((AppState)new WorldViewState());
        this.addChild((AppState)new EnvironmentState(this.timeSettings));
        this.addChild((AppState)new ModelViewState(), true);
        this.addChild((AppState)new DebugShapeViewState());
        this.addChild((AppState)new MorphViewState());
        this.addChild((AppState)new ObjectTextViewState());
        this.addChild((AppState)new PickState());
        this.addChild((AppState)new SoundViewState());
        this.addChild((AppState)new ClaimAreaState());
        this.addChild((AppState)new ClaimViewState(), true);
        this.addChild((AppState)new WorldMarkerState());
        this.addChild((AppState)new CharacterAnimationState());
        this.addChild((AppState)new TerrainState(blackboard));
        this.addChild((AppState)new FarTerrainState(blackboard));
        this.addChild((AppState)new TreeState(blackboard));
        this.addChild((AppState)new PointCloudState(blackboard, true).workerPoolId("backgroundWorkers"), true);
        this.addChild((AppState)new HudStatsState(), true);
        this.addChild((AppState)new InGameMenuState(), true);
        this.addChild((AppState)new PlayerMenuState(), true);
        this.addChild((AppState)new BlockTypeSelectionState(), true);
        this.addChild((AppState)new ShellState());
        this.addChild((AppState)new HelpMenuState(), true);
        this.addChild((AppState)new FlyOverState(), true);
        this.addChild((AppState)new ContainerViewState(), true);
        this.addChild((AppState)new DetailViewState(), true);
        this.addChild((AppState)new UserPromptState(), true);
        this.addChild((AppState)new ClientModManagerState());
        this.addChild((AppState)new ScreenAnnotationsState());
        this.addChild((AppState)new OverlaySettingsState());
        ((CameraState)this.getState(CameraState.class)).setFieldOfView(GameConstants.DEFAULT_FOV);
        ((CameraState)this.getState(CameraState.class)).setNear(0.1f);
        ((CameraState)this.getState(CameraState.class)).setFar(8000.0f);
        ((MovementState)this.getState(MovementState.class)).setWalkSpeed(1.0);
        ((MovementState)this.getState(MovementState.class)).setRunSpeed(2.0);
        ((TerrainState)this.getChild(TerrainState.class)).setMaterialFactory(TerrainMaterials.terrainMaterial(app));
        ((FarTerrainState)this.getChild(FarTerrainState.class)).setMaterialFactory(TerrainMaterials.farTerrainMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setMaterialFactory(TerrainMaterials.treeBillboardMaterial(app));
        ((PointCloudState)this.getChild(PointCloudState.class)).setMaterialFactory(TerrainMaterials.pointCloudMaterial(app));
        ((TreeState)this.getChild(TreeState.class)).setClipDistance(3072.0f);
        ((PointCloudState)this.getChild(PointCloudState.class)).setClipDistance(3072.0f);
        float pointScale = 1.0f;
        AppSettings appSettings = app.getContext().getSettings();
        if (appSettings.getSamples() != 0) {
            int samples = appSettings.getSamples();
            log.info("samples:" + samples);
            if (samples == 16) {
                pointScale = 2.0f;
            }
        }
        ((PointCloudState)this.getChild(PointCloudState.class)).setPointScale(pointScale);
        log.info("pointScale:" + ((PointCloudState)this.getChild(PointCloudState.class)).getPointScale());
        this.session = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(GameSessionClientService.class);
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host != null) {
            this.addChild((AppState)new PhysicsDebugState(host), true);
        }
        this.materials = this.preloader.getMaterials();
        for (String s : this.materials.keySet()) {
            if (!s.startsWith("light-")) continue;
            this.uncarvable.add(s);
        }
        this.uncarvable.add("leaves");
        this.uncarvable.add("leaves2");
        this.uncarvable.add("hay-framed");
        this.uncarvable.add("hay");
        this.uncarvable.add("pine-branch");
        this.uncarvable.add("glass");
        this.geomFactory = new MythrunaGeometryFactory(false, this.materials);
        this.modelGeomFactory = new MythrunaGeometryFactory(true, this.materials);
        EntityData ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        DataSession dataSession = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(DataSession.class);
        this.shapeFactoryRegistry = ShapeRegistryBuilder.clientRegistry((EntityData)ed, (DataSession)dataSession);
        this.shapeFactory = new ShapeCache(this.shapeFactoryRegistry);
        this.configureUiStateMachine();
        app.enqueue(() -> ((JobState)this.getState(JobState.class)).execute(new Job(){

            public void runOnWorker() {
            }

            public double runOnUpdate() {
                int queued = ((JobState)GameSessionState.this.getState(JobState.class)).getQueuedCount();
                int active = ((JobState)GameSessionState.this.getState(JobState.class)).getActiveCount();
                log.info("queued:" + queued + "  active:" + active);
                int poolSize = ((JobState)GameSessionState.this.getState(JobState.class)).getPoolSize();
                if (queued == 0 && active <= poolSize) {
                    log.info("Done with initial load.");
                    GameSessionState.this.clearCache();
                    return 0.0;
                }
                log.info("Trying again...");
                ((JobState)GameSessionState.this.getState(JobState.class)).execute((Job)this);
                return 0.0;
            }
        }));
    }

    protected void cleanup(Application app) {
        log.info("cleanup()");
    }

    protected void onEnable() {
        log.info("onEnable()");
        super.onEnable();
        this.uiFsm.start();
        log.info("uiFsm.isRunning():" + this.uiFsm.isRunning());
        log.info("uiFsm.currentState:" + this.uiFsm.getCurrentState());
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(STATE_IN_GAME);
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_MENU, (Object)this, T_OPEN_GAME_MENU);
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_MENU, (Object)this, "openPlayerMenu");
        inputMapper.addDelegate(MainGameFunctions.F_INVENTORY, (Object)this, "openInventory");
        inputMapper.addDelegate(MainGameFunctions.F_DETAIL, (Object)this, T_OPEN_DETAIL_VIEW);
        inputMapper.addDelegate(MainGameFunctions.F_PLAYER_EQUIPMENT, (Object)this, "selectBlockType");
        inputMapper.addDelegate(MainGameFunctions.F_IN_GAME_HELP, (Object)this, T_OPEN_HELP);
        inputMapper.addDelegate(MainGameFunctions.F_MAP, (Object)this, "toggleMap");
        inputMapper.addDelegate(MainGameFunctions.F_JOURNAL, (Object)this, "toggleJournal");
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
        log.info("onDisable()");
        super.onDisable();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(STATE_IN_GAME);
        inputMapper.removeDelegate(MainGameFunctions.F_IN_GAME_MENU, (Object)this, T_OPEN_GAME_MENU);
        inputMapper.removeDelegate(MainGameFunctions.F_PLAYER_MENU, (Object)this, "openPlayerMenu");
        inputMapper.removeDelegate(MainGameFunctions.F_INVENTORY, (Object)this, "openInventory");
        inputMapper.removeDelegate(MainGameFunctions.F_DETAIL, (Object)this, T_OPEN_DETAIL_VIEW);
        inputMapper.removeDelegate(MainGameFunctions.F_PLAYER_EQUIPMENT, (Object)this, "selectBlockType");
        inputMapper.removeDelegate(MainGameFunctions.F_IN_GAME_HELP, (Object)this, T_OPEN_HELP);
        inputMapper.removeDelegate(MainGameFunctions.F_MAP, (Object)this, "toggleMap");
        inputMapper.removeDelegate(MainGameFunctions.F_JOURNAL, (Object)this, "toggleJournal");
    }

    public void trigger(String transition) {
        log.info("trigger(" + transition + ") state:" + this.uiFsm.getCurrentState());
        this.uiFsm.trigger((Object)transition);
    }

    public void openGameMenu() {
        this.trigger(T_OPEN_GAME_MENU);
    }

    public void openPlayerMenu() {
        log.info("openPlayerMenu() this:" + this + "   isEnabled():" + this.isEnabled());
        this.trigger(T_OPEN_PLAYER_BOOK);
    }

    public void closePlayerMenu() {
        log.info("closePlayerMenu() this:" + this + "   isEnabled():" + this.isEnabled());
        this.trigger(T_CLOSE_PLAYER_BOOK);
    }

    public void openConsole() {
        log.info("openConsole()");
        this.trigger(T_OPEN_CONSOLE);
    }

    public void closeConsole() {
        log.info("closeConsole() currentState:" + this.uiFsm.getCurrentState() + " console state:Console");
        if (STATE_CONSOLE.equals(this.uiFsm.getCurrentState().getId())) {
            this.trigger(T_CLOSE_CONSOLE);
        } else {
            log.info("Console already closed.");
        }
    }

    public void toggleMap() {
        log.info("toggleMap() currentState:" + this.uiFsm.getCurrentState() + "  Desired state:Player Book");
        if (!STATE_PLAYER_BOOK.equals(this.uiFsm.getCurrentState().getId())) {
            this.trigger(T_OPEN_PLAYER_BOOK);
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).selectSubmenu("Map");
        } else if (((PlayerMenuState)this.getState(PlayerMenuState.class)).isSelected("Map")) {
            this.trigger(T_CLOSE_PLAYER_BOOK);
        } else {
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).selectSubmenu("Map");
        }
    }

    public void toggleJournal() {
        log.info("toggleJournal() currentState:" + this.uiFsm.getCurrentState() + "  Desired state:Player Book");
        if (!STATE_PLAYER_BOOK.equals(this.uiFsm.getCurrentState().getId())) {
            this.trigger(T_OPEN_PLAYER_BOOK);
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).selectSubmenu("Journal");
        } else if (((PlayerMenuState)this.getState(PlayerMenuState.class)).isSelected("Journal")) {
            this.trigger(T_CLOSE_PLAYER_BOOK);
        } else {
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).selectSubmenu("Journal");
        }
    }

    public void closeMap() {
        this.trigger(T_CLOSE_PLAYER_BOOK);
    }

    public void openInventory() {
        this.trigger(T_OPEN_CONTAINER_VIEW);
    }

    public void openDetailView() {
        this.trigger(T_OPEN_DETAIL_VIEW);
    }

    public void openPrompt() {
        this.trigger(T_OPEN_PROMPT);
    }

    public void closePrompt() {
        if (STATE_PROMPT.equals(this.uiFsm.getCurrentState().getId())) {
            this.trigger(T_CLOSE_PROMPT);
        }
    }

    public void selectBlockType() {
        this.trigger(T_SELECT_TYPE);
    }

    public void openHelp() {
        this.trigger(T_OPEN_HELP);
    }

    public void openMiscPopup(Spatial popup) {
        if (this.miscPopup != null) {
            this.miscPopup.removeFromParent();
        }
        this.miscPopup = popup;
        this.trigger(T_OPEN_MISC_POPUP);
    }

    public void closeMiscPopup() {
        this.trigger(T_CLOSE_MISC_POPUP);
    }

    protected void configureUiStateMachine() {
        log.info("configureUiStateMachine()");
        this.uiFsm = new StateMachine();
        StateMachine<String, String> fsm = this.uiFsm;
        fsm.addDefaultTermination((Object)T_EXIT);
        fsm.addDefaultTransition((Object)T_RETURN_TO_GAME, (Object)STATE_IN_GAME);
        fsm.addDefaultTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_GAME_MENU);
        fsm.addDefaultTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_PLAYER_BOOK);
        fsm.addDefaultTransition((Object)T_OPEN_CONTAINER_VIEW, (Object)STATE_CONTAINER_VIEW);
        fsm.addDefaultTransition((Object)T_OPEN_SETTINGS_MENU, (Object)STATE_SETTINGS);
        fsm.addDefaultTransition((Object)T_SELECT_TYPE, (Object)STATE_SELECT_TYPE);
        fsm.addDefaultTransition((Object)T_OPEN_HELP, (Object)STATE_HELP);
        fsm.addDefaultTransition((Object)T_OPEN_PROMPT, (Object)STATE_PROMPT);
        fsm.addDefaultTransition((Object)T_OPEN_MISC_POPUP, (Object)STATE_MISC_POPUP);
        fsm.addDefaultTransition((Object)T_OPEN_CONSOLE, (Object)STATE_CONSOLE);
        fsm.addDefaultTransition((Object)T_OPEN_DETAIL_VIEW, (Object)STATE_DETAIL_VIEW);
        fsm.setStart((Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_GAME_MENU).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_PLAYER_BOOK).addTransition((Object)T_OPEN_PLAYER_BOOK, (Object)STATE_IN_GAME).addTransition((Object)T_OPEN_PROMPT, (Object)STATE_BOOK_PROMPT).addTransition((Object)T_CLOSE_PLAYER_BOOK, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_CONTAINER_VIEW).addTransition((Object)T_OPEN_CONTAINER_VIEW, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_DETAIL_VIEW).addTransition((Object)T_OPEN_DETAIL_VIEW, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_BOOK_PROMPT).addTransition((Object)T_OPEN_PROMPT, (Object)STATE_BOOK_PROMPT).addTransition((Object)T_CLOSE_PROMPT, (Object)STATE_PLAYER_BOOK);
        fsm.getState((Object)STATE_SETTINGS).addTransition((Object)T_OPEN_GAME_MENU, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_SELECT_TYPE).addTransition((Object)T_OPEN_PROMPT, (Object)STATE_SELECT_TYPE).addTransition((Object)T_SELECT_TYPE, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_HELP).addTransition((Object)T_OPEN_HELP, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_PROMPT).addTransition((Object)T_CLOSE_PROMPT, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_MISC_POPUP).addTransition((Object)T_CLOSE_MISC_POPUP, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_CONSOLE).addTransition((Object)T_OPEN_CONSOLE, (Object)STATE_IN_GAME).addTransition((Object)T_CLOSE_CONSOLE, (Object)STATE_IN_GAME);
        fsm.getState((Object)STATE_IN_GAME).onEnter(() -> {
            ((MovementState)this.getState(MovementState.class)).setEnabled(true);
            ((ActivationInputState)this.getState(ActivationInputState.class)).setEnabled(true);
        }).onExit(() -> {
            ((MovementState)this.getState(MovementState.class)).setEnabled(false);
            ((ActivationInputState)this.getState(ActivationInputState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_GAME_MENU).onEnter(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(true)).onExit(() -> ((InGameMenuState)this.getState(InGameMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_PLAYER_BOOK).onEnter(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(true)).onExit(() -> ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_CONTAINER_VIEW).onEnter(() -> {
            ((ContainerViewState)this.getState(ContainerViewState.class)).setEnabled(true);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true);
        }).onExit(() -> {
            ((ContainerViewState)this.getState(ContainerViewState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_DETAIL_VIEW).onEnter(() -> {
            ((DetailViewState)this.getState(DetailViewState.class)).setEnabled(true);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true);
        }).onExit(() -> {
            ((DetailViewState)this.getState(DetailViewState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_BOOK_PROMPT).onEnter(() -> {
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(true);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true);
        }).onExit(() -> {
            ((PlayerMenuState)this.getState(PlayerMenuState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false);
        });
        fsm.getState((Object)STATE_SETTINGS).onEnter(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(true);
        }).onExit(() -> {
            ((GameSettingsState)this.getState(GameSettingsState.class)).setEnabled(false);
            ((GameSettingsState)this.getState(GameSettingsState.class)).setCentered(true);
        });
        fsm.getState((Object)STATE_SELECT_TYPE).onEnter(() -> {
            ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).open();
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true);
            ((UserPromptState)this.getState(UserPromptState.class)).setDisableAutoclose(true);
        }).onExit(() -> {
            ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false);
            ((UserPromptState)this.getState(UserPromptState.class)).setDisableAutoclose(false);
        });
        fsm.getState((Object)STATE_HELP).onEnter(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(true)).onExit(() -> ((HelpMenuState)this.getState(HelpMenuState.class)).setEnabled(false));
        fsm.getState((Object)STATE_PROMPT).onEnter(() -> ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(true)).onExit(() -> ((UserPromptState)this.getState(UserPromptState.class)).setEnabled(false));
        fsm.getState((Object)STATE_MISC_POPUP).onExit(() -> {
            if (this.miscPopup != null) {
                this.miscPopup.removeFromParent();
                this.miscPopup = null;
            }
        });
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        fsm.getState((Object)STATE_CONSOLE).onEnter(() -> {
            ((CommandConsoleState)this.getState(CommandConsoleState.class)).setEnabled(true);
            inputMapper.activateGroup("Console Open");
        }).onExit(() -> {
            ((CommandConsoleState)this.getState(CommandConsoleState.class)).setEnabled(false);
            inputMapper.deactivateGroup("Console Open");
        });
    }
}

