/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.ColorChooser;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.namegen.Cluster;
import com.simsilica.thread.Job;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mythruna.character.BodyConfig;
import mythruna.character.ClothingTemplate;
import mythruna.character.ClothingTemplateIndex;
import mythruna.character.RaceType;
import mythruna.client.character.CharacterDecorator;
import mythruna.client.character.CharacterDecorators;
import mythruna.client.net.character.AbstractCharacterPage;
import mythruna.client.net.character.CharacterEditor;
import mythruna.client.net.character.CharacterEditorFunctions;
import mythruna.client.net.character.Clothing;
import mythruna.client.net.character.ClothingEditor;
import mythruna.es.ClothingInfo;
import mythruna.es.HairColor;
import mythruna.es.ObjectName;
import mythruna.es.Race;
import mythruna.es.SkinColor;
import mythruna.fabric.ClothingAccumulator;
import mythruna.fabric.FabricUtils;
import mythruna.shape.ShapeName;
import mythruna.world.name.NameGeneratorCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppearancePage
extends AbstractCharacterPage {
    static Logger log = LoggerFactory.getLogger(AppearancePage.class);
    public static final ColorRGBA DEFAULT_HAIR_COLOR = new ColorRGBA(0.29803923f, 0.08627451f, 0.03529412f, 1.0f);
    public static final ColorRGBA DEFAULT_SKIN_COLOR = new ColorRGBA(0.6313726f, 0.4745098f, 0.28235295f, 1.0f);
    private EntityData ed;
    private Label view;
    private GuiControlListener viewListener = new ViewListener();
    private TextField nameField;
    private ColorRGBA hairColor = new ColorRGBA(DEFAULT_HAIR_COLOR);
    private ColorRGBA defaultHairColor = new ColorRGBA(DEFAULT_HAIR_COLOR);
    private ActionButton hairColorButton;
    private QuadBackgroundComponent hairQuad;
    private ColorRGBA skinColor = new ColorRGBA(DEFAULT_SKIN_COLOR);
    private ColorRGBA defaultSkinColor = new ColorRGBA(DEFAULT_HAIR_COLOR);
    private ActionButton skinColorButton;
    private QuadBackgroundComponent skinQuad;
    private Container colorChooserPopup;
    private ColorChooser colorChooser;
    private VersionedReference<ColorRGBA> colorRef;
    private ColorRGBA target;
    private Map<String, String> clothingShapes = new HashMap<String, String>();
    private VersionedList<ClothingTemplate> availableTemplates = new VersionedList();
    private VersionedList<Clothing> wornClothing = new VersionedList();
    private Clothing defaultShirt;
    private Clothing defaultShorts;
    private ClothingEditor clothingConfig;
    private ListBox<Clothing> wornClothingList;
    private ClothingAccumulator clothingAccumulator = new ClothingAccumulator(32, 32, 32);
    private long clothingVersion = 1L;
    private long lastFab = 0L;
    private InputMapper inputMapper;
    private InputHandler inputHandler = new InputHandler();
    private float yaw = 0.7853982f;
    private float pitch = 0.0f;
    private float minPitch = -0.5f;
    private float maxPitch = 0.5f;
    private String lastModelName;
    private Spatial model;
    private CharacterDecorator decorator;
    private ModelUpdater updater = new ModelUpdater();

    public AppearancePage() {
        super("Appearance");
        this.setNextActions(new Action[]{new CheckFieldsAction()});
        this.view = new Label("");
        ((GuiControl)this.view.getControl(GuiControl.class)).addListener(this.viewListener);
        this.view.setPreferredSize(new Vector3f(400.0f, 600.0f, 0.0f));
        this.view.setBackground((GuiComponent)new QuadBackgroundComponent(GuiGlobals.getInstance().loadTexture("Interface/old-paper-flattened.png", false, false)));
        this.inputMapper = GuiGlobals.getInstance().getInputMapper();
        ElementId baseId = this.getElementId().child("form");
        this.colorChooserPopup = new Container(baseId.child("popup"));
        this.colorChooser = (ColorChooser)this.colorChooserPopup.addChild((Node)new ColorChooser(baseId.child("colorChooser")), new Object[0]);
        Container buttons = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.First, FillMode.None));
        this.colorChooserPopup.addChild((Node)buttons, new Object[0]);
        buttons.addChild((Node)new Label(""), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Ok", (Object)this, "closeColorPopup")), new Object[0]);
        this.colorRef = this.colorChooser.getModel().createReference();
        Container props = (Container)this.addChild((Node)new Container(baseId.child("container")), new Object[0]);
        props.addChild((Node)new Label("Name:", baseId.child("name.label")), new Object[0]);
        this.nameField = (TextField)props.addChild((Node)new TextField("", baseId.child("value.textField")), new Object[]{1});
        this.nameField.setPreferredWidth(200.0f);
        props.addChild((Node)new ActionButton((Action)new CallMethodAction("Random", (Object)this, "randomizeName"), baseId.child("value.button")), new Object[]{2});
        props.addChild((Node)new Label("  "), new Object[0]);
        props.addChild((Node)new Label("Hair Color:", baseId.child("name.label")), new Object[0]);
        this.hairColorButton = (ActionButton)props.addChild((Node)new ActionButton((Action)new CallMethodAction("", (Object)this, "changeHairColor"), baseId.child("value.color.button")), new Object[]{1});
        this.hairQuad = new QuadBackgroundComponent(this.hairColor);
        this.hairColorButton.setBackground((GuiComponent)this.hairQuad);
        props.addChild((Node)new ActionButton((Action)new CallMethodAction("Reset", (Object)this, "resetHairColor"), baseId.child("value.button")), new Object[]{2});
        props.addChild((Node)new Label("Skin Color:", baseId.child("name.label")), new Object[0]);
        this.skinColorButton = (ActionButton)props.addChild((Node)new ActionButton((Action)new CallMethodAction("", (Object)this, "changeSkinColor"), baseId.child("value.color.button")), new Object[]{1});
        this.skinQuad = new QuadBackgroundComponent(this.skinColor);
        this.skinColorButton.setBackground((GuiComponent)this.skinQuad);
        props.addChild((Node)new ActionButton((Action)new CallMethodAction("Reset", (Object)this, "resetSkinColor"), baseId.child("value.button")), new Object[]{2});
        this.addChild((Node)new Label("Available Clothing:"), new Object[0]);
        this.clothingConfig = (ClothingEditor)this.addChild((Node)new ClothingEditor(this.availableTemplates), new Object[0]);
        this.addChild((Node)new ActionButton((Action)new CallMethodAction("Wear", (Object)this, "wearClothing")), new Object[0]);
        this.addChild((Node)new Label("Worn Clothing:"), new Object[0]);
        this.wornClothingList = (ListBox)this.addChild((Node)new ListBox(this.wornClothing), new Object[0]);
        this.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "removeClothing")), new Object[0]);
    }

    @Override
    protected void onInitialize(CharacterEditor editor) {
        this.ed = this.getCharacterEditor().getEntityData();
    }

    @Override
    protected boolean onSetCharacter(Entity character) {
        if (character == null) {
            this.decorator = null;
            return false;
        }
        this.loadAvailableClothing(character);
        boolean shouldEdit = false;
        Name name = this.getBaseComponent(Name.class);
        if (name == null) {
            shouldEdit = true;
            this.nameField.setText("");
        } else {
            this.nameField.setText(name.getName());
        }
        SkinColor skin = this.getBaseComponent(SkinColor.class);
        if (skin != null) {
            this.skinColor.set(skin.getColor());
        } else {
            shouldEdit = true;
        }
        HairColor hair = this.getBaseComponent(HairColor.class);
        if (hair != null) {
            this.hairColor.set(hair.getColor());
        } else {
            this.setComponent((EntityComponent)new HairColor(this.hairColor));
            shouldEdit = true;
        }
        log.info("********* shouldEdit:" + shouldEdit);
        if (shouldEdit) {
            this.decorator = CharacterDecorators.standardDecorators(this.getCharacterEditor().getApplication().getAssetManager(), this::lookupCellArray);
            this.updater.setDecorator(this.decorator);
        }
        return shouldEdit;
    }

    protected CellArray lookupCellArray(CellArrayId id) {
        log.info("lookupCellArray(" + id + ")");
        return this.clothingAccumulator.getCells();
    }

    @Override
    public Panel getView() {
        return this.view;
    }

    protected Vector3f getTopRight(Panel p) {
        Vector3f size = p.getSize();
        Vector3f scale = p.getWorldScale();
        Vector3f pos = p.getWorldTranslation().clone();
        pos.x += size.x * scale.x;
        return GuiGlobals.getInstance().getPopupState().screenToGui(pos);
    }

    protected Vector3f getTopLeft(Panel p) {
        Vector3f pos = p.getWorldTranslation().clone();
        return GuiGlobals.getInstance().getPopupState().screenToGui(pos);
    }

    protected void resetHairColor() {
        this.hairColor.set(this.defaultHairColor);
    }

    protected void changeHairColor() {
        Vector3f pos = this.getTopLeft((Panel)this.hairColorButton);
        this.colorChooserPopup.setLocalTranslation(pos);
        this.target = this.hairColor;
        this.colorChooser.setColor(this.target);
        GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.colorChooserPopup);
    }

    protected void resetSkinColor() {
        this.skinColor.set(this.defaultSkinColor);
    }

    protected void changeSkinColor() {
        Vector3f pos = this.getTopLeft((Panel)this.skinColorButton);
        this.colorChooserPopup.setLocalTranslation(pos);
        this.target = this.skinColor;
        this.colorChooser.setColor(this.target);
        GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.colorChooserPopup);
    }

    protected void closeColorPopup() {
        this.colorChooserPopup.removeFromParent();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean appearanceChanged = false;
        if (this.colorRef.update()) {
            this.target.set((ColorRGBA)this.colorRef.get());
            if (this.target == this.hairColor) {
                this.updateHairColor();
            } else if (this.target == this.skinColor) {
                this.updateSkinColor();
            }
            appearanceChanged = true;
        }
        if (appearanceChanged || this.clothingVersion > this.lastFab) {
            this.updateAppearance(false);
        }
    }

    protected void updateHairColor() {
        HairColor existing = this.getComponent(HairColor.class);
        if (existing != null && Objects.equals(existing.getColor(), this.hairColor)) {
            return;
        }
        this.setComponent((EntityComponent)new HairColor(this.hairColor));
    }

    protected void updateSkinColor() {
        SkinColor existing = this.getComponent(SkinColor.class);
        if (existing != null && Objects.equals(existing.getColor(), this.skinColor)) {
            return;
        }
        this.setComponent((EntityComponent)new SkinColor(this.skinColor));
    }

    @Override
    protected void onAttach() {
        HairColor hair;
        log.info("onAttach()");
        Race race = this.getComponent(Race.class);
        String raceId = race.getTypeName(this.ed);
        BodyConfig config = this.getCharacterEditor().getBodyConfigs().getFirst(raceId);
        if (config != null) {
            this.defaultSkinColor.set(config.getSkinColor());
            this.defaultHairColor.set(config.getHairColor());
        } else {
            this.defaultSkinColor.set(DEFAULT_SKIN_COLOR);
            this.defaultHairColor.set(DEFAULT_HAIR_COLOR);
        }
        SkinColor skin = this.getBaseComponent(SkinColor.class);
        if (skin == null) {
            this.skinColor.set(this.defaultSkinColor);
            this.setComponent((EntityComponent)new SkinColor(this.skinColor));
        }
        if ((hair = this.getBaseComponent(HairColor.class)) == null) {
            this.hairColor.set(this.defaultHairColor);
            this.setComponent((EntityComponent)new HairColor(this.hairColor));
        }
        this.updateAppearance(true);
        this.getCharacterEditor().openViewport();
        this.inputMapper.activateGroup("Character Editor");
        this.inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterEditorFunctions.F_PAN, CharacterEditorFunctions.F_CRANE, CharacterEditorFunctions.F_ZOOM});
    }

    @Override
    protected void onDetach() {
        log.info("onDetach()");
        this.getCharacterEditor().closeViewport();
        this.inputMapper.deactivateGroup("Character Editor");
        this.inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterEditorFunctions.F_PAN, CharacterEditorFunctions.F_CRANE, CharacterEditorFunctions.F_ZOOM});
    }

    protected void updateRotation(Spatial model) {
        if (model == null) {
            return;
        }
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        model.setLocalRotation(rot);
    }

    protected void updateAppearance(boolean now) {
        EntityComponent[] components = new EntityComponent[]{this.getComponent(Race.class), this.getComponent(HairColor.class), this.getComponent(SkinColor.class)};
        String shapeId = this.getCharacterEditor().getCharacterSession().getCharacterPreviewShapeId(components);
        ShapeName name = ShapeName.parse((String)shapeId);
        log.info("shapeName before:" + name);
        if (this.clothingVersion > this.lastFab) {
            this.repaintClothing();
            this.lastFab = this.clothingVersion;
        }
        ShapeName existing = name.findAddOnType("fab");
        name.getAddOns().remove(existing);
        ShapeName fabric = new ShapeName("fab", String.valueOf(this.clothingVersion));
        name.getAddOns().add(fabric);
        log.info("Replaced:" + existing + " with:" + fabric);
        log.info("shapeName after:" + name);
        if (this.updater != null) {
            this.updater.setShapeName(name);
        }
        if (now) {
            this.updater.runOnWorker();
            this.updater.runOnUpdate();
        } else {
            this.updater.enqueueIfNeeded();
        }
    }

    protected void loadAvailableClothing(Entity character) {
        log.info("loadAvailableClothing(" + character + ")");
        this.clothingShapes.clear();
        this.availableTemplates.clear();
        this.wornClothing.clear();
        EntityId worldEntity = this.getCharacterEditor().getWorldEntity();
        log.info("worldEntity:" + worldEntity);
        ComponentFilter filter = Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)worldEntity);
        for (EntityId entity : this.ed.findEntities(filter, new Class[]{ClothingInfo.class, ObjectName.class, ShapeInfo.class})) {
            ObjectName objectName = (ObjectName)this.ed.getComponent(entity, ObjectName.class);
            String on = objectName.getName(this.ed);
            if (Objects.equals("!private!", on)) {
                log.info("   skipping !private! clothing design");
                continue;
            }
            ClothingInfo info = (ClothingInfo)this.ed.getComponent(entity, ClothingInfo.class);
            ShapeInfo shapeInfo = (ShapeInfo)this.ed.getComponent(entity, ShapeInfo.class);
            String shapeName = shapeInfo.getShapeName(this.ed);
            this.clothingShapes.put(info.getName(), shapeName);
        }
        ClothingTemplateIndex index = this.getCharacterEditor().getClothingTemplateIndex();
        this.availableTemplates.addAll((Collection)index.getTemplates());
        for (ClothingTemplate template : this.availableTemplates) {
            if ("Burlap Shirt".equals(template.getInfoName())) {
                this.defaultShirt = ClothingEditor.fromTemplate(template);
                continue;
            }
            if (!"Burlap Shorts".equals(template.getInfoName())) continue;
            this.defaultShorts = ClothingEditor.fromTemplate(template);
        }
        if (this.wornClothing.isEmpty()) {
            if (this.defaultShirt != null) {
                this.wornClothing.add((Object)this.defaultShirt);
                this.availableTemplates.remove((Object)this.defaultShirt.getTemplate());
            }
            if (this.defaultShorts != null) {
                this.wornClothing.add((Object)this.defaultShorts);
                this.availableTemplates.remove((Object)this.defaultShorts.getTemplate());
            }
        }
        Collections.sort(this.availableTemplates);
        log.info("Available templates:");
        for (ClothingTemplate c : this.availableTemplates) {
            log.info("   " + c);
        }
    }

    protected void wearClothing() {
        Clothing clothing = this.clothingConfig.createClothing();
        if (clothing == null) {
            return;
        }
        this.availableTemplates.remove((Object)clothing.getTemplate());
        this.wornClothing.add((Object)clothing);
        ++this.clothingVersion;
    }

    protected void removeClothing() {
        Clothing clothing = (Clothing)this.wornClothingList.getSelectedItem();
        if (clothing == null) {
            return;
        }
        this.availableTemplates.add((Object)clothing.getTemplate());
        this.wornClothing.remove((Object)clothing);
        Collections.sort(this.availableTemplates);
        ++this.clothingVersion;
    }

    protected void repaintClothing() {
        log.info("repaintClothing()");
        this.clothingAccumulator.clear();
        for (Clothing c : this.wornClothing) {
            Map<Integer, Integer> remap;
            String shapeName = this.clothingShapes.get(c.getTemplate().getInfoName());
            if (shapeName == null) {
                log.error("Missing shape name for:" + c.getTemplate().getInfoName());
                continue;
            }
            ShapeName shape = ShapeName.parse((String)shapeName);
            if (log.isTraceEnabled()) {
                log.trace("  shape:" + shape);
            }
            CellArrayId cellArrayId = CellArrayId.fromString((String)shape.getName());
            if (log.isTraceEnabled()) {
                log.trace("  id:" + cellArrayId);
            }
            CellArray cells = this.getDataSession().getCellArray(cellArrayId);
            if (log.isTraceEnabled()) {
                log.trace("  cells:" + cells);
            }
            if (!(remap = c.calculateRemap()).isEmpty()) {
                cells = FabricUtils.remap((CellArray)cells, remap);
            }
            this.clothingAccumulator.addCells(cells);
        }
    }

    protected static void fixLocalLighting(Spatial spatial) {
        final ColorRGBA localLighting = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                log.info("geom:" + geom.getName() + " ------- mat:" + mat.getName());
                if (mat.getMaterialDef().getMaterialParam("LocalLighting") != null) {
                    mat.setColor("LocalLighting", localLighting);
                }
            }
        });
    }

    protected void randomizeName() {
        RaceType raceType;
        Race race = this.getComponent(Race.class);
        String key = "/people/all-male.nameset";
        if (race != null && "Female".equals((raceType = this.getCharacterEditor().getRaces().getRace(race.getTypeName(this.ed))).getSubtype())) {
            key = "/people/all-female.nameset";
        }
        log.info("Race:" + race + "  key:" + key);
        List clusters = NameGeneratorCache.getGenerator((String)key).generateWord(3, 8, new Random());
        String word = Cluster.toWords((List)clusters);
        this.nameField.setText(word);
    }

    private class ViewListener
    extends AbstractGuiControlListener {
        private ViewListener() {
        }

        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            log.info("reshape(" + pos + ", " + size + ")");
            AppearancePage.this.getCharacterEditor().resizeViewport((Panel)AppearancePage.this.view);
        }
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == CharacterEditorFunctions.F_PAN) {
                AppearancePage.this.yaw = (float)((double)AppearancePage.this.yaw + -value * tpf);
                if (AppearancePage.this.yaw < 0.0f) {
                    AppearancePage.this.yaw += (float)Math.PI * 2;
                } else if (AppearancePage.this.yaw >= (float)Math.PI * 2) {
                    AppearancePage.this.yaw -= (float)Math.PI * 2;
                }
                AppearancePage.this.updateRotation(AppearancePage.this.updater.getModel());
            } else if (func == CharacterEditorFunctions.F_CRANE) {
                AppearancePage.this.pitch = (float)((double)AppearancePage.this.pitch + value * tpf);
                if (AppearancePage.this.pitch < AppearancePage.this.minPitch) {
                    AppearancePage.this.pitch = AppearancePage.this.minPitch;
                } else if (AppearancePage.this.pitch > AppearancePage.this.maxPitch) {
                    AppearancePage.this.pitch = AppearancePage.this.maxPitch;
                }
                AppearancePage.this.updateRotation(AppearancePage.this.updater.getModel());
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    protected class ModelUpdater
    implements Job {
        private ShapeName shapeName;
        private CharacterDecorator decorator;
        private int changeCount;
        private int changeCountRef;
        private boolean working;
        private Spatial currentModel;
        private String lastModelName;
        private volatile Spatial newModel;

        public Spatial getModel() {
            return this.currentModel;
        }

        public void setDecorator(CharacterDecorator decorator) {
            this.decorator = decorator;
            ++this.changeCount;
        }

        public synchronized void setShapeName(ShapeName shapeName) {
            log.info("ModelUpdater.setShapeName(" + shapeName + ")");
            if (Objects.equals(this.shapeName, shapeName)) {
                return;
            }
            this.shapeName = shapeName;
            ++this.changeCount;
        }

        public synchronized void enqueueIfNeeded() {
            if (this.working) {
                return;
            }
            if (this.changeCount <= this.changeCountRef) {
                return;
            }
            this.working = true;
            AppearancePage.this.getCharacterEditor().getJobState().execute((Job)this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnWorker() {
            Spatial oldModel;
            ShapeName name;
            ModelUpdater modelUpdater = this;
            synchronized (modelUpdater) {
                name = this.shapeName;
                oldModel = this.currentModel;
                this.changeCountRef = this.changeCount;
            }
            if (this.decorator == null || name == null) {
                return;
            }
            String assetName = name.getFullName() + ".j3o";
            if (oldModel == null || !Objects.equals(this.lastModelName, assetName)) {
                log.info("Loading model:" + assetName);
                this.newModel = AppearancePage.this.getCharacterEditor().getApplication().getAssetManager().loadModel(assetName);
                this.lastModelName = assetName;
                AppearancePage.fixLocalLighting(this.newModel);
            } else if (oldModel != null) {
                this.newModel = oldModel.clone(true);
            }
            this.decorator.setSpatial(this.newModel);
            this.decorator.setShapeName(name);
            this.decorator.apply();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double runOnUpdate() {
            if (this.newModel == null) {
                return 0.0;
            }
            if (this.currentModel != null) {
                this.currentModel.removeFromParent();
            }
            this.currentModel = this.newModel;
            AppearancePage.this.getCharacterEditor().getViewportRoot().attachChild(this.currentModel);
            AppearancePage.this.updateRotation(this.currentModel);
            ModelUpdater modelUpdater = this;
            synchronized (modelUpdater) {
                this.working = false;
                this.enqueueIfNeeded();
            }
            return 0.0;
        }
    }

    protected class CheckFieldsAction
    extends EmptyAction {
        public CheckFieldsAction() {
            super("Save and Continue");
        }

        public void execute(Button source) {
            String name = AppearancePage.this.nameField.getText().trim();
            if (name.length() == 0) {
                AppearancePage.this.getCharacterEditor().showPopupMessage("Unable To Save", "Please enter a character name.");
                return;
            }
            AppearancePage.this.setComponent((EntityComponent)new Name(name));
            AppearancePage.this.getCharacterEditor().setWorn((List<Clothing>)AppearancePage.this.wornClothing);
            AppearancePage.this.getCharacterEditor().saveCharacter();
            AppearancePage.this.getCharacterEditor().nextPage();
        }
    }
}

