/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.util.ArrayList;
import java.util.List;
import mythruna.character.ClothingTemplate;
import mythruna.character.FabricName;
import mythruna.character.FabricOption;
import mythruna.client.net.character.Clothing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(ClothingEditor.class);
    private VersionedList<ClothingTemplate> availableTemplates;
    private ClothingTemplate template;
    private Label selectorLabel;
    private Selector<ClothingTemplate> baseSelector;
    private VersionedReference<ClothingTemplate> baseSelectorRef;
    private List<OptionEditor> options = new ArrayList<OptionEditor>();

    public ClothingEditor(VersionedList<ClothingTemplate> availableTemplates) {
        super((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last), new ElementId("editor.container"));
        this.availableTemplates = availableTemplates;
        this.selectorLabel = new Label("Clothing:");
        this.baseSelector = new Selector(availableTemplates);
        this.baseSelector.setValueRenderer((ValueRenderer)new DefaultValueRenderer(i -> i == null ? "null" : i.getInfoName()));
        this.baseSelectorRef = this.baseSelector.createSelectedItemReference();
        this.refreshChildren();
    }

    public static Clothing fromTemplate(ClothingTemplate source) {
        return new Clothing(source, source.getInfoName(), source.getName(), source.getName(), null);
    }

    public Clothing createClothing() {
        Clothing result = ClothingEditor.fromTemplate(this.template);
        for (OptionEditor editor : this.options) {
            FabricName replace = editor.option.getTargetFabric();
            FabricName with = (FabricName)editor.selector.getSelectedItem();
            if (with == null || with.equals((Object)replace)) continue;
            result.addTransform(replace, with);
        }
        return result;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.baseSelectorRef.update()) {
            this.setClothingTemplate((ClothingTemplate)this.baseSelectorRef.get());
        }
    }

    public void setClothingTemplate(ClothingTemplate template) {
        if (this.template == template) {
            return;
        }
        this.template = template;
        this.refreshChildren();
    }

    protected void refreshChildren() {
        this.clearChildren();
        this.options.clear();
        this.addChild((Node)this.selectorLabel, new Object[0]);
        this.addChild((Node)this.baseSelector, new Object[]{1});
        if (this.template == null) {
            return;
        }
        for (FabricOption option : this.template.getOptions()) {
            this.addChild((Node)new Label(option.getName() + ":"), new Object[0]);
            OptionEditor editor = new OptionEditor(this, option);
            this.options.add(editor);
            this.addChild((Node)editor.selector, new Object[]{1});
        }
    }

    private class OptionEditor {
        private FabricOption option;
        private VersionedList<FabricName> list;
        private Selector<FabricName> selector;

        public OptionEditor(ClothingEditor clothingEditor, FabricOption option) {
            this.option = option;
            this.list = new VersionedList(option.getFabrics());
            this.selector = new Selector(this.list);
            this.selector.setSelectedItem((Object)option.getTargetFabric());
        }
    }
}

