/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.util.SafeArrayList;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.jme.AttachmentControl;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.sim.SimTime;
import com.simsilica.state.BlackboardState;
import com.simsilica.state.GameSystemsState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import mythruna.character.RaceType;
import mythruna.character.RaceTypeIndex;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.GameSessionState;
import mythruna.client.view.input.ShellState;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelListener;
import mythruna.client.view.object.ModelViewState;
import mythruna.es.CharacterName;
import mythruna.es.CharacterRelationship;
import mythruna.es.DebugText;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.Race;
import mythruna.es.StatusText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTextViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ObjectTextViewState.class);
    private static final ColorRGBA NAME_LABEL_COLOR = ColorRGBA.Cyan;
    private static final ColorRGBA NAME_SHADOW_COLOR = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private EntityData ed;
    private EntityId avatarId;
    private BackgroundRetrieverState retriever;
    private ModelViewState models;
    private VersionedReference<ComponentFilter<SpawnPosition>> positionFilterRef;
    private ModelObserver modelObserver = new ModelObserver();
    private ConcurrentLinkedQueue<Runnable> updates = new ConcurrentLinkedQueue();
    private Camera cam;
    private SimTime time;
    private Map<String, String> npcNameAliases;
    private RaceTypeIndex races;
    private Consumer<Boolean> objectNameSetter = b -> this.setShowObjectNames((boolean)b);
    private Consumer<Boolean> characterNameSetter = b -> this.setShowCharacterNames((boolean)b);
    private Consumer<Boolean> playerNameSetter = b -> this.setShowPlayerNames((boolean)b);
    private Consumer<Boolean> statusSetter = b -> this.setShowStatusText((boolean)b);
    private Consumer<Boolean> debugSetter = b -> this.setShowDebugText((boolean)b);
    private ObjectNameContainer objectNames;
    private boolean showObjectNames;
    private float nameScale = 0.005f;
    private float nameOffset = 0.0f;
    private float nameMinDist = 1.0f;
    private float nameMaxDist = 5.0f;
    private CharacterNameContainer characterNames;
    private RelationshipContainer relationships;
    private boolean showCharacterNames = true;
    private ObjectTypeInfo playerType;
    private PlayerNameContainer playerNames;
    private boolean showPlayerNames = true;
    private StatusTextContainer statuses;
    private boolean showStatusText = true;
    private DebugTextContainer debugText;
    private boolean showDebugText = false;
    private Map<EntityId, TopTextView> topViewIndex = new HashMap<EntityId, TopTextView>();
    private SafeArrayList<TopTextView> topViews = new SafeArrayList(TopTextView.class);
    private SafeArrayList<LabelFader> faders = new SafeArrayList(LabelFader.class);

    public void setShowObjectNames(boolean showObjectNames) {
        if (this.showObjectNames == showObjectNames) {
            return;
        }
        this.showObjectNames = showObjectNames;
        if (this.objectNames == null || !this.isEnabled()) {
            return;
        }
        if (showObjectNames && !this.objectNames.isStarted()) {
            this.objectNames.start();
        } else if (!showObjectNames && this.objectNames.isStarted()) {
            this.objectNames.stop();
        }
    }

    public void setShowCharacterNames(boolean showCharacterNames) {
        if (this.showCharacterNames == showCharacterNames) {
            return;
        }
        this.showCharacterNames = showCharacterNames;
        if (this.characterNames == null || !this.isEnabled()) {
            return;
        }
        for (CharacterNameHolder holder : this.characterNames.getArray()) {
            holder.resetVisibility();
        }
    }

    public void setShowPlayerNames(boolean showPlayerNames) {
        if (this.showPlayerNames == showPlayerNames) {
            return;
        }
        this.showPlayerNames = showPlayerNames;
        if (this.playerNames == null || !this.isEnabled()) {
            return;
        }
        if (showPlayerNames && !this.playerNames.isStarted()) {
            this.playerNames.start();
        } else if (!showPlayerNames && this.playerNames.isStarted()) {
            this.playerNames.stop();
        }
    }

    public void setShowStatusText(boolean showStatusText) {
        if (this.showStatusText == showStatusText) {
            return;
        }
        this.showStatusText = showStatusText;
        if (this.statuses == null || !this.isEnabled()) {
            return;
        }
        if (showStatusText && !this.statuses.isStarted()) {
            this.statuses.start();
        } else if (!showStatusText && this.statuses.isStarted()) {
            this.statuses.stop();
        }
    }

    public void setShowDebugText(boolean showDebugText) {
        if (this.showDebugText == showDebugText) {
            return;
        }
        this.showDebugText = showDebugText;
        if (this.debugText == null || !this.isEnabled()) {
            return;
        }
        if (showDebugText && !this.debugText.isStarted()) {
            this.debugText.start();
        } else if (!showDebugText && this.debugText.isStarted()) {
            this.debugText.stop();
        }
    }

    protected void initialize(Application app) {
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = sessionState.getEntityData();
        this.retriever = (BackgroundRetrieverState)this.getState(BackgroundRetrieverState.class, true);
        this.models = (ModelViewState)this.getState(ModelViewState.class, true);
        this.objectNames = new ObjectNameContainer(this.ed);
        this.characterNames = new CharacterNameContainer(this.ed);
        this.relationships = new RelationshipContainer(this.ed);
        this.playerNames = new PlayerNameContainer(this.ed);
        this.statuses = new StatusTextContainer(this.ed);
        this.debugText = new DebugTextContainer(this.ed);
        this.cam = app.getCamera();
        this.time = ((GameSystemsState)this.getState(GameSystemsState.class, true)).getStepTime();
        this.npcNameAliases = ((ShellState)this.getState(ShellState.class)).getNpcAliases();
        this.avatarId = sessionState.getGameSession().getAvatar();
        this.races = RaceTypeIndex.create(id -> sessionState.getDataSession().getText(id), (boolean)true);
        BlackboardState blackboard = (BlackboardState)this.getState("global", BlackboardState.class, true);
        blackboard.watch("settings.objectNames.enabled", this.objectNameSetter);
        blackboard.watch("settings.characterNames.enabled", this.characterNameSetter);
        blackboard.watch("settings.playerNames.enabled", this.playerNameSetter);
        blackboard.watch("settings.statusText.enabled", this.statusSetter);
        blackboard.watch("settings.debugText.enabled", this.debugSetter);
        this.positionFilterRef = ((ModelViewState)this.getState(ModelViewState.class, true)).createPositionFilterRef();
        this.updateFilters((ComponentFilter<SpawnPosition>)((ComponentFilter)this.positionFilterRef.get()));
        ((ModelViewState)this.getState(ModelViewState.class, true)).addModelListener(this.modelObserver);
        this.playerType = ObjectTypeInfo.create((String)"PlayerCharacter", (EntityData)this.ed);
    }

    protected void cleanup(Application app) {
        if (this.getState(ModelViewState.class) != null) {
            ((ModelViewState)this.getState(ModelViewState.class)).removeModelListener(this.modelObserver);
        }
        BlackboardState blackboard = (BlackboardState)this.getState("global", BlackboardState.class, true);
        blackboard.unwatch("settings.objectNames.enabled", this.objectNameSetter);
        blackboard.unwatch("settings.characterNames.enabled", this.characterNameSetter);
        blackboard.unwatch("settings.playerNames.enabled", this.playerNameSetter);
        blackboard.unwatch("settings.statusText.enabled", this.statusSetter);
        blackboard.unwatch("settings.debugText.enabled", this.debugSetter);
    }

    protected void onEnable() {
        if (this.showObjectNames) {
            this.objectNames.start();
        }
        this.characterNames.start();
        this.relationships.start();
        if (this.showPlayerNames) {
            this.playerNames.start();
        }
        if (this.showStatusText) {
            this.statuses.start();
        }
        if (this.showDebugText) {
            this.debugText.start();
        }
    }

    public void update(float tpf) {
        if (this.positionFilterRef.update()) {
            this.updateFilters((ComponentFilter<SpawnPosition>)((ComponentFilter)this.positionFilterRef.get()));
        }
        while (!this.updates.isEmpty()) {
            ObjectNameView[] update = this.updates.poll();
            update.run();
        }
        if (this.showObjectNames) {
            this.objectNames.update();
            for (ObjectNameView view : this.objectNames.getArray()) {
                view.update(tpf);
            }
        }
        this.characterNames.update();
        this.relationships.updateFilter();
        this.relationships.update();
        if (this.showPlayerNames) {
            this.playerNames.update();
        }
        if (this.showStatusText) {
            this.statuses.update();
        }
        if (this.showDebugText) {
            this.debugText.update();
        }
        long frameTime = this.time.getTime();
        for (TopTextView view : (TopTextView[])this.topViews.getArray()) {
            view.update(frameTime, tpf);
        }
        for (LabelFader fader : (LabelFader[])this.faders.getArray()) {
            fader.update(frameTime);
        }
    }

    protected void onDisable() {
        if (this.showObjectNames) {
            this.objectNames.stop();
        }
        this.characterNames.stop();
        this.relationships.stop();
        if (this.showPlayerNames) {
            this.playerNames.stop();
        }
        if (this.showStatusText) {
            this.statuses.stop();
        }
        if (this.showDebugText) {
            this.debugText.stop();
        }
    }

    protected void updateFilters(ComponentFilter<SpawnPosition> filter) {
        if (filter == null) {
            ComponentFilter filter1 = SpawnPosition.binFilter((long)0L);
            ComponentFilter filter2 = SpawnPosition.binFilter((long)1L);
            filter = Filters.and(SpawnPosition.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2});
        }
        this.objectNames.setFilter(filter);
        this.characterNames.setFilter(filter);
        this.playerNames.setFilter(filter);
        this.statuses.setFilter(filter);
        this.debugText.setFilter(filter);
    }

    protected void setViewModel(EntityId id, Model model) {
        this.objectNames.setModel(id, model);
        TopTextView top = this.topViewIndex.get(id);
        if (top != null) {
            top.setModel(model);
        }
    }

    protected TopTextView getTopText(EntityId entityId, boolean create) {
        TopTextView view = this.topViewIndex.get(entityId);
        if (create && view == null) {
            view = new TopTextView(entityId);
            this.topViewIndex.put(entityId, view);
            this.topViews.add((Object)view);
        }
        return view;
    }

    public static float getTopOffset(BoundingVolume bv) {
        if (bv instanceof BoundingBox) {
            return ((BoundingBox)bv).getYExtent();
        }
        if (bv instanceof BoundingSphere) {
            return ((BoundingSphere)bv).getRadius();
        }
        return 0.0f;
    }

    public CharacterRelationship getPlayerRelationship(EntityId target) {
        ComponentFilter filter = CharacterRelationship.linkFilter((EntityId)this.avatarId, (EntityId)target);
        EntityId result = this.ed.findEntity(filter, new Class[]{CharacterRelationship.class});
        return result == null ? null : (CharacterRelationship)this.ed.getComponent(result, CharacterRelationship.class);
    }

    private class ModelObserver
    implements ModelListener {
        private ModelObserver() {
        }

        @Override
        public void modelCreated(Model model) {
            ObjectTextViewState.this.updates.add(() -> ObjectTextViewState.this.setViewModel(model.getEntityId(), model));
        }

        @Override
        public void modelReleased(Model model) {
            ObjectTextViewState.this.updates.add(() -> ObjectTextViewState.this.setViewModel(model.getEntityId(), null));
        }
    }

    private class TopTextView {
        private EntityId entityId;
        private Node topNode;
        private Model model;
        private VersionedReference<Spatial> spatialRef;
        private Spatial objectSpatial;
        private AttachmentPoint top;
        private int useCount = 0;
        private SafeArrayList<ViewLabel> staticLabels = new SafeArrayList(ViewLabel.class);
        private SafeArrayList<ViewLabel> dynamicLabels = new SafeArrayList(ViewLabel.class);
        private boolean invalid = false;

        public TopTextView(EntityId entityId) {
            if (log.isDebugEnabled()) {
                log.debug("TopTextView(" + entityId + ")");
            }
            this.entityId = entityId;
            this.topNode = new Node("top:" + entityId);
            this.topNode.move(0.0f, ObjectTextViewState.this.nameOffset, 0.0f);
            this.setModel(ObjectTextViewState.this.models.getModel(entityId));
        }

        public ViewLabel addStaticLabel(String text, String elementId) {
            ViewLabel label = new ViewLabel(ObjectTextViewState.this, this, text, elementId);
            this.staticLabels.add((Object)label);
            this.topNode.attachChild((Spatial)label);
            this.invalid = true;
            return label;
        }

        public ViewLabel addDynamicLabel(String text, String elementId) {
            ViewLabel label = new ViewLabel(ObjectTextViewState.this, this, text, elementId);
            this.dynamicLabels.add((Object)label);
            this.topNode.attachChild((Spatial)label);
            this.invalid = true;
            return label;
        }

        public void remove(ViewLabel label) {
            this.staticLabels.remove((Object)label);
            this.dynamicLabels.remove((Object)label);
            label.label.removeFromParent();
            this.invalid = true;
        }

        public void setModel(Model model) {
            this.model = model;
            VersionedReference<Spatial> versionedReference = this.spatialRef = model != null ? model.createSpatialRef() : null;
            if (this.spatialRef != null) {
                this.setSpatial((Spatial)this.spatialRef.get());
            }
        }

        public void setSpatial(Spatial objectSpatial) {
            if (this.objectSpatial == objectSpatial) {
                return;
            }
            this.objectSpatial = objectSpatial;
            this.invalid = true;
            if (objectSpatial != null) {
                AttachmentControl attachments = (AttachmentControl)objectSpatial.getControl(AttachmentControl.class);
                if (attachments != null) {
                    this.top = attachments.getAttachment("head.top");
                }
            } else {
                this.top = null;
            }
        }

        protected void validate() {
            boolean attach;
            if (!this.invalid) {
                return;
            }
            this.invalid = false;
            boolean bl = attach = this.objectSpatial != null;
            if (this.staticLabels.isEmpty() && this.dynamicLabels.isEmpty()) {
                attach = false;
            }
            if (attach) {
                float yBase = 0.0f;
                for (ViewLabel label : (ViewLabel[])this.staticLabels.getArray()) {
                    label.yOffset = yBase;
                    label.setLocalTranslation(0.0f, yBase, 0.0f);
                    yBase += label.height;
                }
                for (ViewLabel label : (ViewLabel[])this.dynamicLabels.getArray()) {
                    label.yOffset = yBase;
                }
            }
            if (attach && this.topNode.getParent() == null) {
                log.info("attaching:" + this.entityId);
                ObjectTextViewState.this.models.getObjectRoot().attachChild((Spatial)this.topNode);
            } else if (!attach && this.topNode.getParent() != null) {
                log.info("detaching:" + this.entityId);
                this.topNode.removeFromParent();
            }
        }

        public void update(long frameTime, float tpf) {
            if (this.spatialRef != null && this.spatialRef.update()) {
                this.setSpatial((Spatial)this.spatialRef.get());
            }
            this.validate();
            if (this.objectSpatial != null) {
                Vector3f v;
                if (this.top != null) {
                    this.top.update();
                    v = this.top.getTranslation().toVector3f();
                } else {
                    BoundingVolume bounds = this.objectSpatial.getWorldBound();
                    float yOffset = ObjectTextViewState.getTopOffset(bounds);
                    v = bounds.getCenter().add(0.0f, yOffset, 0.0f);
                }
                this.topNode.setLocalTranslation(v);
                this.topNode.move(0.0f, ObjectTextViewState.this.nameOffset, 0.0f);
            }
        }
    }

    private class LabelFader {
        private ViewLabel label;
        private long startTime;
        private long endTime;

        public LabelFader(ViewLabel label, long startTime, double duration) {
            this.label = label;
            this.startTime = startTime;
            this.endTime = startTime + ObjectTextViewState.this.time.toSimTime(duration);
        }

        public void update(long frameTime) {
            if (frameTime >= this.endTime) {
                this.release();
                return;
            }
            double t = (double)(frameTime - this.startTime) / (double)(this.endTime - this.startTime);
            float alpha = 1.0f;
            if (t > 0.5) {
                alpha = (float)((1.0 - t) / 0.5);
                this.label.label.setAlpha(alpha);
            }
            t = t * t * t;
            this.label.setLocalTranslation(0.0f, (float)((double)this.label.yOffset + t * 0.2), 0.0f);
        }

        public void release() {
            ObjectTextViewState.this.faders.remove((Object)this);
            this.label.release();
        }
    }

    private class ObjectNameContainer
    extends EntityContainer<ObjectNameView> {
        public ObjectNameContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, ObjectName.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        public void setModel(EntityId entityId, Model model) {
            ObjectNameView view = (ObjectNameView)this.getObject(entityId);
            if (view != null) {
                view.setModel(model);
            }
        }

        public ObjectNameView[] getArray() {
            return (ObjectNameView[])super.getArray();
        }

        protected ObjectNameView addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add ObjectNameView:" + e.getId());
            }
            ObjectNameView object = new ObjectNameView(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(ObjectNameView object, Entity e) {
            object.setObjectName((ObjectName)e.get(ObjectName.class));
        }

        protected void removeObject(ObjectNameView object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove ObjectNameView:" + e.getId());
            }
            object.release();
        }
    }

    private class CharacterNameContainer
    extends EntityContainer<CharacterNameHolder> {
        public CharacterNameContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, CharacterName.class, Race.class});
        }

        public CharacterNameHolder[] getArray() {
            return (CharacterNameHolder[])super.getArray();
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected CharacterNameHolder addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add CharacterName:" + e.getId());
            }
            TopTextView top = ObjectTextViewState.this.getTopText(e.getId(), true);
            ObjectTextViewState.this.relationships.addCharacter(e.getId());
            return new CharacterNameHolder(top, e);
        }

        protected void updateObject(CharacterNameHolder object, Entity e) {
            object.updateText(((CharacterName)e.get(CharacterName.class)).getFullName());
            int raceId = ((Race)e.get(Race.class)).getTypeId();
            ObjectTextViewState.this.retriever.getString(raceId, object::updateRace);
        }

        protected void removeObject(CharacterNameHolder object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("release CharacterName:" + e.getId());
            }
            object.release();
            ObjectTextViewState.this.relationships.removeCharacter(e.getId());
        }
    }

    private class CharacterNameHolder {
        private TopTextView top;
        private Entity entity;
        private String fullName;
        private String race;
        private String aliasKey;
        private ViewLabel label;
        private boolean visible;

        public CharacterNameHolder(TopTextView top, Entity entity) {
            this.top = top;
            this.entity = entity;
            this.aliasKey = "NPC:" + entity.getId().getId();
            this.fullName = ((CharacterName)entity.get(CharacterName.class)).getFullName();
            int raceId = ((Race)entity.get(Race.class)).getTypeId();
            ObjectTextViewState.this.retriever.getString(raceId, this::updateRace);
            ObjectTextViewState.this.retriever.query(this, () -> ObjectTextViewState.this.getPlayerRelationship(entity.getId()), this::updateRelationship);
        }

        protected void updateRelationship(CharacterRelationship rel) {
            log.info(this.entity.getId() + ".updateRelationship(" + rel + ")");
            this.setVisible(rel != null && rel.getLevel() > 0);
        }

        public void setVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            this.resetVisibility();
        }

        public void resetVisibility() {
            if (!this.visible || !ObjectTextViewState.this.showCharacterNames) {
                if (this.label != null) {
                    this.label.release();
                    this.label = null;
                }
            } else {
                this.label = this.top.addStaticLabel(this.fullName, "object.character.label");
            }
            this.updateAlias();
        }

        public void updateText(String fullName) {
            this.fullName = fullName;
            if (this.label != null) {
                this.label.updateText(fullName);
            }
        }

        public void updateRace(String race) {
            this.race = race;
            this.updateAlias();
        }

        protected void updateAlias() {
            if (this.visible) {
                ObjectTextViewState.this.npcNameAliases.put(this.aliasKey, this.fullName);
            } else {
                RaceType type = ObjectTextViewState.this.races.getRace(this.race);
                if (type != null) {
                    ObjectTextViewState.this.npcNameAliases.put(this.aliasKey, type.getFullName());
                } else {
                    ObjectTextViewState.this.npcNameAliases.put(this.aliasKey, "Unknown");
                }
            }
        }

        public void release() {
            if (this.label != null) {
                this.label.release();
            }
            ObjectTextViewState.this.npcNameAliases.remove(this.aliasKey);
        }
    }

    private class PlayerNameContainer
    extends EntityContainer<ViewLabel> {
        public PlayerNameContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, Name.class, ObjectTypeInfo.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected ViewLabel addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add CharacterName:" + e.getId());
            }
            if (ObjectTextViewState.this.playerType.getTypeId() == ((ObjectTypeInfo)e.get(ObjectTypeInfo.class)).getTypeId()) {
                TopTextView top = ObjectTextViewState.this.getTopText(e.getId(), true);
                ViewLabel label = top.addStaticLabel(((Name)e.get(Name.class)).getName(), "object.player.label");
                return label;
            }
            return null;
        }

        protected void updateObject(ViewLabel object, Entity e) {
            if (object != null) {
                object.updateText(((Name)e.get(Name.class)).getName());
            }
        }

        protected void removeObject(ViewLabel object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("release CharacterName:" + e.getId());
            }
            if (object != null) {
                object.release();
            }
        }
    }

    private class StatusTextContainer
    extends EntityContainer<TopTextView> {
        public StatusTextContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, StatusText.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected TopTextView addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add StatusText:" + e.getId());
            }
            TopTextView object = ObjectTextViewState.this.getTopText(e.getId(), true);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(TopTextView object, Entity e) {
            StatusText status = (StatusText)e.get(StatusText.class);
            ViewLabel view = object.addDynamicLabel(status.getText(), "object.status.label");
            switch (status.getType()) {
                case 0: {
                    view.label.setColor(ColorRGBA.White);
                    break;
                }
                case 1: {
                    view.label.setColor(ColorRGBA.Red);
                }
            }
            ObjectTextViewState.this.faders.add((Object)new LabelFader(view, status.getStartTime(), status.getDuration()));
        }

        protected void removeObject(TopTextView object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("release StatusText:" + e.getId());
            }
            for (LabelFader fader : (LabelFader[])ObjectTextViewState.this.faders.getArray()) {
                if (fader.label.parent != object) continue;
                log.info("Removing fader for:" + fader.label.parent.entityId);
                fader.release();
            }
        }
    }

    private class DebugTextContainer
    extends EntityContainer<ViewLabel> {
        public DebugTextContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, ShapeInfo.class, DebugText.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected ViewLabel addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add DebugText:" + e.getId());
            }
            TopTextView top = ObjectTextViewState.this.getTopText(e.getId(), true);
            ViewLabel label = top.addStaticLabel(((DebugText)e.get(DebugText.class)).getText(), "object.debug.label");
            return label;
        }

        protected void updateObject(ViewLabel object, Entity e) {
            object.updateText(((DebugText)e.get(DebugText.class)).getText());
        }

        protected void removeObject(ViewLabel object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("release DebugText:" + e.getId());
            }
            object.release();
        }
    }

    private class RelationshipContainer
    extends EntityContainer<CharacterRelationship> {
        private Set<EntityId> characters;
        private boolean resetFilter;

        public RelationshipContainer(EntityData ed) {
            super(ed, new Class[]{CharacterRelationship.class});
            this.characters = new HashSet<EntityId>();
            this.resetFilter = true;
        }

        public void start() {
            this.resetFilter = true;
            super.start();
        }

        public void addCharacter(EntityId character) {
            if (this.characters.add(character)) {
                this.resetFilter = true;
            }
        }

        public void removeCharacter(EntityId character) {
            if (this.characters.remove(character)) {
                this.resetFilter = true;
            }
        }

        public void updateFilter() {
            if (!this.resetFilter) {
                return;
            }
            this.resetFilter = false;
            log.info("RelationshipContainer.updateFilter(" + this.characters + ")");
            if (this.characters.isEmpty()) {
                this.setFilter(Filters.and(CharacterRelationship.class, (ComponentFilter[])new ComponentFilter[]{CharacterRelationship.sourceFilter((EntityId)new EntityId(0L)), CharacterRelationship.sourceFilter((EntityId)new EntityId(1L))}));
                return;
            }
            ComponentFilter playerFilter = CharacterRelationship.sourceFilter((EntityId)ObjectTextViewState.this.avatarId);
            ArrayList<ComponentFilter> charFilters = new ArrayList<ComponentFilter>();
            for (EntityId id : this.characters) {
                charFilters.add(CharacterRelationship.targetFilter((EntityId)id));
            }
            this.setFilter(Filters.and(CharacterRelationship.class, (ComponentFilter[])new ComponentFilter[]{playerFilter, Filters.or(CharacterRelationship.class, (ComponentFilter[])charFilters.toArray(new ComponentFilter[0]))}));
        }

        protected CharacterRelationship addObject(Entity e) {
            log.info("addRelationship(" + e + ")");
            CharacterRelationship rel = (CharacterRelationship)e.get(CharacterRelationship.class);
            this.updateObject(rel, e);
            return rel;
        }

        protected void updateObject(CharacterRelationship object, Entity e) {
            log.info("updateRelationship(" + e + ")");
            CharacterNameHolder nameHolder = (CharacterNameHolder)ObjectTextViewState.this.characterNames.getObject(object.getTarget());
            if (nameHolder != null) {
                nameHolder.updateRelationship((CharacterRelationship)e.get(CharacterRelationship.class));
            }
        }

        protected void removeObject(CharacterRelationship object, Entity e) {
            log.info("removeRelationship(" + e + ")");
            CharacterNameHolder nameHolder = (CharacterNameHolder)ObjectTextViewState.this.characterNames.getObject(object.getTarget());
            if (nameHolder != null) {
                nameHolder.updateRelationship(null);
            }
        }
    }

    private class ObjectNameView {
        private Entity entity;
        private ObjectName objectName;
        private Label label;
        private Node centerNode;
        private Model model;
        private VersionedReference<Spatial> spatialRef;
        private Spatial objectSpatial;
        private AttachmentPoint centerOfMass;

        public ObjectNameView(Entity entity) {
            if (log.isDebugEnabled()) {
                log.debug("ObjectNameView(" + entity + ")");
            }
            this.entity = entity;
            this.label = new Label("", new ElementId("object.name.label"));
            this.label.setLocalScale(ObjectTextViewState.this.nameScale);
            this.label.setQueueBucket(RenderQueue.Bucket.Translucent);
            this.centerNode = new Node("name:" + entity.getId());
            this.centerNode.attachChild((Spatial)this.label);
            this.centerNode.addControl((Control)new BillboardControl());
            this.setModel(ObjectTextViewState.this.models.getModel(entity.getId()));
        }

        public void setObjectName(ObjectName objectName) {
            if (Objects.equals(this.objectName, objectName)) {
                return;
            }
            this.objectName = objectName;
            if (objectName != null) {
                ObjectTextViewState.this.retriever.getString(objectName.getNameId(), this::updateText);
            } else {
                this.label.setText("");
            }
        }

        public void setModel(Model model) {
            this.model = model;
            VersionedReference<Spatial> versionedReference = this.spatialRef = model != null ? model.createSpatialRef() : null;
            if (this.spatialRef != null) {
                this.setSpatial((Spatial)this.spatialRef.get());
            }
        }

        public void setSpatial(Spatial objectSpatial) {
            if (this.objectSpatial == objectSpatial) {
                return;
            }
            this.objectSpatial = objectSpatial;
            if (objectSpatial != null) {
                ObjectTextViewState.this.models.getObjectRoot().attachChild((Spatial)this.centerNode);
                AttachmentControl attachments = (AttachmentControl)objectSpatial.getControl(AttachmentControl.class);
                if (attachments != null) {
                    this.centerOfMass = attachments.getAttachment("com");
                }
            } else {
                this.centerOfMass = null;
            }
        }

        protected void updateText(String s) {
            if (log.isTraceEnabled()) {
                log.trace(this.objectName + "->" + s);
            }
            this.label.setText(s);
            Vector3f pref = this.label.getPreferredSize();
            this.label.setLocalTranslation(-pref.x * 0.5f * ObjectTextViewState.this.nameScale, pref.y * 0.5f * ObjectTextViewState.this.nameScale, 0.0f);
        }

        public void update(float tpf) {
            if (this.spatialRef != null && this.spatialRef.update()) {
                this.setSpatial((Spatial)this.spatialRef.get());
            }
            if (this.objectSpatial != null) {
                Vector3f v;
                this.centerNode.setLocalScale(1.0f);
                if (this.centerOfMass != null) {
                    this.centerOfMass.update();
                    v = this.centerOfMass.getTranslation().toVector3f();
                } else {
                    v = this.objectSpatial.getWorldBound().getCenter();
                }
                this.centerNode.setLocalTranslation(v);
                float dist = v.distance(ObjectTextViewState.this.cam.getLocation());
                this.centerNode.setLocalScale(dist * 0.5f);
                if (dist > ObjectTextViewState.this.nameMaxDist) {
                    this.label.setCullHint(Spatial.CullHint.Always);
                } else {
                    this.label.setCullHint(Spatial.CullHint.Inherit);
                    float alpha = dist < ObjectTextViewState.this.nameMinDist ? 1.0f : (ObjectTextViewState.this.nameMaxDist - dist) / (ObjectTextViewState.this.nameMaxDist - ObjectTextViewState.this.nameMinDist);
                    this.label.setAlpha(alpha);
                }
            }
        }

        public void release() {
            this.centerNode.removeFromParent();
        }
    }

    private class ViewLabel
    extends Node {
        private TopTextView parent;
        private Label label;
        private float height;
        private float yOffset = 0.0f;

        public ViewLabel(ObjectTextViewState objectTextViewState, TopTextView parent, String text, String elementId) {
            super("viewLabel:" + parent.entityId);
            this.parent = parent;
            LayerComparator.setLayer((Spatial)this, (int)9);
            this.label = new Label("", new ElementId(elementId));
            this.label.setQueueBucket(RenderQueue.Bucket.Transparent);
            this.label.setLocalScale(objectTextViewState.nameScale);
            this.attachChild((Spatial)this.label);
            this.addControl((Control)new BillboardControl());
            this.updateText(text);
        }

        protected void updateText(String s) {
            Vector3f scale = this.label.getLocalScale();
            this.label.setText(s);
            Vector3f pref = this.label.getPreferredSize().mult(scale);
            this.height = pref.y;
            this.label.setLocalTranslation(-pref.x * 0.5f, pref.y, 0.0f);
        }

        public void release() {
            this.parent.remove(this);
        }
    }
}

