#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Parallax.glsllib"
#import "Common/ShaderLib/Optics.glsllib"
#ifndef VERTEX_LIGHTING
    #import "Common/ShaderLib/BlinnPhongLighting.glsllib"
    #import "Common/ShaderLib/Lighting.glsllib"
#endif

varying vec3 vPos;

// fog - jayfella
#ifdef USE_FOG
#import "Common/ShaderLib/MaterialFog.glsllib"
varying float fog_distance;
uniform vec4 m_FogColor;

#ifdef FOG_LINEAR
uniform vec2 m_LinearFog;
#endif

#ifdef FOG_EXP
uniform float m_ExpFog;
#endif

#ifdef FOG_EXPSQ
uniform float m_ExpSqFog;
#endif

#endif // end fog

#ifdef HAS_FADE_DISTANCE
uniform float m_FadeDistance;
#endif

varying vec2 texCoord;
#ifdef SEPARATE_TEXCOORD
  varying vec2 texCoord2;
#endif

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;

varying vec4 modelLight;
//uniform vec3 g_CameraDirection;
varying vec3 localLightDir;

#ifdef CARVE_SCALE
varying float textureDepth;
flat varying int textureDirection;
#endif

#ifndef VERTEX_LIGHTING
  uniform vec4 g_LightDirection;
  //varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
  varying vec3 lightVec;
#else
  varying vec2 vertexLightValues;
#endif

#ifdef DIFFUSEMAP
  uniform sampler2D m_DiffuseMap;
#endif

#ifdef DIFFUSEMAP2
  uniform sampler2D m_DiffuseMap2;
#endif

#ifdef HAS_INNER_MAP
  uniform sampler2D m_InnerDiffuseMap;
#endif
#ifdef HAS_INNER_UP_MAP
  uniform sampler2D m_InnerUpDiffuseMap;
#endif
#ifdef HAS_OUTER_UP_MAP
  uniform sampler2D m_OuterUpDiffuseMap;
#endif

#ifdef MATERIAL_COLORS
    // For local lighting to use also
    uniform vec4 m_Diffuse;
    uniform vec4 m_Ambient;
    uniform vec4 m_Specular;
#endif

#ifdef HAS_EMISSIVE
    uniform vec4 m_Emissive;
#endif

#ifdef HAS_EMISSIVE_MAP
    uniform sampler2D m_EmissiveMap;
#endif


#ifdef SPECULARMAP
  uniform sampler2D m_SpecularMap;
#endif

#ifdef PARALLAXMAP
  uniform sampler2D m_ParallaxMap;
#endif
#if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING)
    uniform float m_ParallaxHeight;
    varying vec3 vViewDirPrlx;
#endif

#ifdef LIGHTMAP
  uniform sampler2D m_LightMap;
#endif

#ifdef NORMALMAP
  uniform sampler2D m_NormalMap;
#endif

#ifdef NORMALMAP2
  uniform sampler2D m_NormalMap2;
#endif

#if !defined(NORMALMAP) || !defined(NORMALMAP2)
  varying vec3 vNormal;
#endif

#ifdef ALPHAMAP
  uniform sampler2D m_AlphaMap;
#endif

#ifdef COLORRAMP
  uniform sampler2D m_ColorRamp;
#endif

uniform float m_AlphaDiscardThreshold;

#ifndef VERTEX_LIGHTING
    uniform float m_Shininess;
    #ifdef USE_REFLECTION
        uniform float m_ReflectionPower;
        uniform float m_ReflectionIntensity;
        varying vec4 refVec;

        uniform ENVMAP m_EnvMap;
    #endif
#endif

// I don't remember why I have this and Mac M1's don't like
// it so I'm going to hang it off of test mode so I can turn
// it on/off to see what it does.
// It was added with the glass specular stuff and may have been
// related to the screen door transparency that I was testing.
//#ifdef TEST_MODE
////layout(pixel_center_integer) in vec4 gl_FragCoord;
////layout(pixel_center_integer) vec4 gl_FragCoord;
//layout(pixel_center_integer) in vec4 gl_FragCoord;
//// It appears to make no difference at all.
//// I'm going to leave it off by default and hooked to "test mode"
//// so I can play with it if I want to.
//#endif

#if 1
vec3 mod289(vec3 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x) {
     return mod289(((x*34.0)+10.0)*x);
}

vec4 taylorInvSqrt(vec4 r)
{
  return 1.79284291400159 - 0.85373472095314 * r;
}

float snoise(vec3 v)
  {
  const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;
  const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);

// First corner
  vec3 i  = floor(v + dot(v, C.yyy) );
  vec3 x0 =   v - i + dot(i, C.xxx) ;

// Other corners
  vec3 g = step(x0.yzx, x0.xyz);
  vec3 l = 1.0 - g;
  vec3 i1 = min( g.xyz, l.zxy );
  vec3 i2 = max( g.xyz, l.zxy );

  //   x0 = x0 - 0.0 + 0.0 * C.xxx;
  //   x1 = x0 - i1  + 1.0 * C.xxx;
  //   x2 = x0 - i2  + 2.0 * C.xxx;
  //   x3 = x0 - 1.0 + 3.0 * C.xxx;
  vec3 x1 = x0 - i1 + C.xxx;
  vec3 x2 = x0 - i2 + C.yyy; // 2.0*C.x = 1/3 = C.y
  vec3 x3 = x0 - D.yyy;      // -1.0+3.0*C.x = -0.5 = -D.y

// Permutations
  i = mod289(i);
  vec4 p = permute( permute( permute(
             i.z + vec4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0 ))
           + i.x + vec4(0.0, i1.x, i2.x, 1.0 ));

// Gradients: 7x7 points over a square, mapped onto an octahedron.
// The ring size 17*17 = 289 is close to a multiple of 49 (49*6 = 294)
  float n_ = 0.142857142857; // 1.0/7.0
  vec3  ns = n_ * D.wyz - D.xzx;

  vec4 j = p - 49.0 * floor(p * ns.z * ns.z);  //  mod(p,7*7)

  vec4 x_ = floor(j * ns.z);
  vec4 y_ = floor(j - 7.0 * x_ );    // mod(j,N)

  vec4 x = x_ *ns.x + ns.yyyy;
  vec4 y = y_ *ns.x + ns.yyyy;
  vec4 h = 1.0 - abs(x) - abs(y);

  vec4 b0 = vec4( x.xy, y.xy );
  vec4 b1 = vec4( x.zw, y.zw );

  //vec4 s0 = vec4(lessThan(b0,0.0))*2.0 - 1.0;
  //vec4 s1 = vec4(lessThan(b1,0.0))*2.0 - 1.0;
  vec4 s0 = floor(b0)*2.0 + 1.0;
  vec4 s1 = floor(b1)*2.0 + 1.0;
  vec4 sh = -step(h, vec4(0.0));

  vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

  vec3 p0 = vec3(a0.xy,h.x);
  vec3 p1 = vec3(a0.zw,h.y);
  vec3 p2 = vec3(a1.xy,h.z);
  vec3 p3 = vec3(a1.zw,h.w);

//Normalise gradients
  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;

// Mix final noise value
  vec4 m = max(0.5 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  m = m * m;
  return 105.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1),
                                dot(p2,x2), dot(p3,x3) ) );
}
#endif


float fractal1( vec3 pos ) {
    float noise1 = snoise(pos/4.0);
    float noise2 = snoise(pos/1.0);
    float noise3 = snoise(pos * 4.0);

    return noise1 * noise2 + noise3 * 0.1;
}

#ifdef DIFFUSEMAP2
vec4 calculateOverlay( vec4 lightDir, vec3 viewDir ) {

    vec2 newTexCoord;

    #if (defined(PARALLAXMAP2) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP2))) && !defined(VERTEX_LIGHTING)

       #ifdef STEEP_PARALLAX
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map
               newTexCoord = steepParallaxOffset(m_NormalMap2, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = steepParallaxOffset(m_ParallaxMap2, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #endif
       #else
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map
               newTexCoord = classicParallaxOffset(m_NormalMap2, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = classicParallaxOffset(m_ParallaxMap2, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #endif
       #endif
    #else
       newTexCoord = texCoord;
    #endif

    #ifdef CARVE_SCALE
        vec4 diffuseColor2;

        #if defined(DIFFUSEMAP)
            diffuseColor2 = texture2D(m_DiffuseMap2, newTexCoord);
        #else
            diffuseColor2 = vec4(1.0);
        #endif
    #else
        #ifdef DIFFUSEMAP
            vec4 diffuseColor2 = texture2D(m_DiffuseMap2, newTexCoord);
        #else
            vec4 diffuseColor2 = vec4(1.0);
        #endif
    #endif

    #if defined(NORMALMAP2) && !defined(VERTEX_LIGHTING)
      vec4 normalHeight2 = texture2D(m_NormalMap2, newTexCoord);
      //Note the -2.0 and -1.0. We invert the green channel of the normal map,
      //as it's complient with normal maps generated with blender.
      //see http://hub.jmonkeyengine.org/forum/topic/parallax-mapping-fundamental-bug/#post-256898
      //for more explanation.
      vec3 normal2 = normalize((normalHeight2.xyz * vec3(2.0,-2.0,2.0) - vec3(1.0,-1.0,1.0)));
      #ifdef LATC
        normal2.z = sqrt(1.0 - (normal2.x * normal2.x) - (normal2.y * normal2.y));
      #endif
    #elif !defined(VERTEX_LIGHTING)
      vec3 normal2 = vNormal;
      #if !defined(LOW_QUALITY) && !defined(V_TANGENT)
         normal2 = normalize(normal2);
      #endif
    #endif

    #ifdef SPECULARMAP2
      vec4 specularColor2 = texture2D(m_SpecularMap2, newTexCoord);
    #else
      vec4 specularColor2 = vec4(1.0);
    #endif


    vec4 overlayColor = vec4(0.0);

    float spotFallOff = 1.0;
    float shininess2 = m_Shininess;

    vec2   sunlight2 = computeLighting(normal2, viewDir, lightDir.xyz, lightDir.w * spotFallOff, shininess2);
    vec2   localLight2 = computeLighting(normal2, viewDir, localLightDir, 1.0, shininess2);

    float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.a * sunlight2.x + length(AmbientSum.rgb) * modelLight.a);
    float localContrib = max(0.0, min(1.0, 1.25 - sunContrib));

    vec4 ambientColor2 = diffuseColor2;

    #ifdef MATERIAL_COLORS
        ambientColor2 *= m_Ambient;
        diffuseColor2 *= m_Diffuse;
        specularColor2 *= m_Specular;
    #endif

    // Sunlight contribution
    overlayColor.rgb =  AmbientSum      * ambientColor2.rgb  +
                        DiffuseSum.rgb  * diffuseColor2.rgb  * vec3(sunlight2.x) +
                        SpecularSum.rgb * specularColor2.rgb * vec3(sunlight2.y) * modelLight.a;

    //#ifdef GLASS_SPECULAR
    //    alpha = max(0.0, alpha) + max(sunlight2.y, localLight2.y);
    //#endif

    // Local light contribution
    overlayColor.rgb += modelLight.xyz * 0.25 * diffuseColor2.rgb * localContrib
                          + modelLight.xyz * diffuseColor2.rgb * vec3(localLight2.x) * localContrib
                          + modelLight.xyz * specularColor2.rgb * vec3(localLight2.y) * localContrib;

    return overlayColor;
}
#endif


void main(){
    vec2 newTexCoord;

    #if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING)

       #ifdef STEEP_PARALLAX
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map
               newTexCoord = steepParallaxOffset(m_NormalMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = steepParallaxOffset(m_ParallaxMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #endif
       #else
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map
               newTexCoord = classicParallaxOffset(m_NormalMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = classicParallaxOffset(m_ParallaxMap, vViewDirPrlx, texCoord, m_ParallaxHeight);
           #endif
       #endif
    #else
       newTexCoord = texCoord;
    #endif

    #ifdef CARVE_SCALE
        float shellDist = abs(textureDepth - round(textureDepth));
        vec4 diffuseColor;

        if( textureDirection == 0 ) {
            #if defined(HAS_OUTER_UP_MAP)
                if( shellDist < SHELL_MARGIN ) {
                    diffuseColor = texture2D(m_OuterUpDiffuseMap, newTexCoord);
                } else {
                    #if HAS_INNER_UP_MAP
                        diffuseColor = texture2D(m_InnerUpDiffuseMap, newTexCoord);
                    #else
                        diffuseColor = texture2D(m_OuterUpDiffuseMap, newTexCoord);
                    #endif
                }
            #elif defined(HAS_INNER_UP_MAP)
                diffuseColor = texture2D(m_InnerUpDiffuseMap, newTexCoord);
            #elif defined(DIFFUSEMAP)
                diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
            #else
                diffuseColor = vec4(1.0);
            #endif
        } else {
            #if defined(DIFFUSEMAP) && defined(HAS_INNER_MAP)
                if( shellDist < SHELL_MARGIN ) {
                    diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
                } else {
                    diffuseColor = texture2D(m_InnerDiffuseMap, newTexCoord);
                }
            #elif defined(DIFFUSEMAP)
                diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
            #else
                diffuseColor = vec4(1.0);
            #endif
        }
    #else
        #ifdef DIFFUSEMAP
            vec4 diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
        #else
            vec4 diffuseColor = vec4(1.0);
        #endif
    #endif

    /*
    // Goofing around with screen door transparency
    float on = step(600.0, gl_FragCoord.x) * mod(gl_FragCoord.x, 2) * mod(gl_FragCoord.y, 2);
    diffuseColor *= (1.0 - on);
    //diffuseColor *= mod(gl_FragCoord.x, 2);
    //diffuseColor *= mod(gl_FragCoord.y, 2);
    //diffuseColor *= step(2, mod(gl_FragCoord.x, 3));
    //diffuseColor *= step(2, mod(gl_FragCoord.y, 3));

    //alpha = (mod(gl_FragCoord.x, 8) / 8.0) * alpha;
    */

    float alpha = DiffuseSum.a * diffuseColor.a;

    #ifdef ALPHAMAP
       alpha = alpha * texture2D(m_AlphaMap, newTexCoord).r;
    #endif

    #ifndef GLASS_SPECULAR
        // Then we can discard early
        #ifdef DISCARD_ALPHA
            if(alpha < m_AlphaDiscardThreshold){
                discard;
            }
        #endif
    #endif



    // ***********************
    // Read from textures
    // ***********************
    #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
      vec4 normalHeight = texture2D(m_NormalMap, newTexCoord);
      //Note the -2.0 and -1.0. We invert the green channel of the normal map,
      //as it's complient with normal maps generated with blender.
      //see http://hub.jmonkeyengine.org/forum/topic/parallax-mapping-fundamental-bug/#post-256898
      //for more explanation.
      vec3 normal = normalize((normalHeight.xyz * vec3(2.0,-2.0,2.0) - vec3(1.0,-1.0,1.0)));
      #ifdef LATC
        normal.z = sqrt(1.0 - (normal.x * normal.x) - (normal.y * normal.y));
      #endif
    #elif !defined(VERTEX_LIGHTING)
      vec3 normal = vNormal;
      #if !defined(LOW_QUALITY) && !defined(V_TANGENT)
         normal = normalize(normal);
      #endif
    #endif

    #ifdef SPECULARMAP
      vec4 specularColor = texture2D(m_SpecularMap, newTexCoord);
    #else
      vec4 specularColor = vec4(1.0);
    #endif

    #ifdef LIGHTMAP
       vec3 lightMapColor;
       #ifdef SEPARATE_TEXCOORD
          lightMapColor = texture2D(m_LightMap, texCoord2).rgb;
       #else
          lightMapColor = texture2D(m_LightMap, texCoord).rgb;
       #endif
       specularColor.rgb *= lightMapColor;
       diffuseColor.rgb  *= lightMapColor;
    #endif

    #ifdef VERTEX_LIGHTING
       vec2 light = vertexLightValues.xy;
       #ifdef COLORRAMP
            diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
            specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
            light.xy = vec2(1.0);
       #endif

       gl_FragColor.rgb =  AmbientSum     * diffuseColor.rgb +
                           DiffuseSum.rgb * diffuseColor.rgb  * vec3(light.x) +
                           SpecularSum    * specularColor.rgb * vec3(light.y);
    #else
       vec4 lightDir = vLightDir;
       lightDir.xyz = normalize(lightDir.xyz);
       vec3 viewDir = normalize(vViewDir);
       float spotFallOff = 1.0;

       #if __VERSION__ >= 110
        // allow use of control flow
        if(g_LightDirection.w != 0.0){
       #endif
          spotFallOff =  computeSpotFalloff(g_LightDirection, lightVec);
       #if __VERSION__ >= 110
          if(spotFallOff <= 0.0){
              gl_FragColor.rgb = AmbientSum * diffuseColor.rgb;
              gl_FragColor.a   = alpha;
              return;
          }
         }
       #endif

       float shininess = m_Shininess;
       vec2   sunlight = computeLighting(normal, viewDir, lightDir.xyz, lightDir.w * spotFallOff, shininess) ;
       vec2   localLight = computeLighting(normal, viewDir, localLightDir, 1.0, shininess) ;
       #ifdef COLORRAMP
            shouldn't work right now because it doesn't use local light yet
            diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(sunlight.x, 0.0)).rgb;
            specularColor.rgb *= texture2D(m_ColorRamp, vec2(sunlight.y, 0.0)).rgb;
            sunlight.xy = vec2(1.0);
       #endif

       // Workaround, since it is not possible to modify varying variables
       vec4 SpecularSum2 = vec4(SpecularSum, 1.0);
       #ifdef USE_REFLECTION
            vec4 refColor = Optics_GetEnvColor(m_EnvMap, refVec.xyz);

            // Interpolate light specularity toward reflection color
            // Multiply result by specular map
            //specularColor = mix(SpecularSum2 * sunlight.y, refColor, refVec.w) * specularColor;
            // Kilroy to see if this is ever used
            specularColor = vec4(1.0, 0.0, 0.0, 1.0);

            SpecularSum2 = vec4(1.0);
            sunlight.y = 1.0;
       #endif

        vec4 ambientColor = diffuseColor;

        #ifdef MATERIAL_COLORS
            ambientColor *= m_Ambient;
            diffuseColor *= m_Diffuse;
            specularColor *= m_Specular;
        #endif

       // Sunlight contribution
       gl_FragColor.rgb =  AmbientSum       * ambientColor.rgb  +
                           DiffuseSum.rgb   * diffuseColor.rgb  * vec3(sunlight.x) +
                           SpecularSum2.rgb * specularColor.rgb * vec3(sunlight.y) * modelLight.a;

        #ifdef GLASS_SPECULAR
            alpha = max(0.0, alpha) + max(sunlight.y, localLight.y);
        #endif

       // We want to dull the local light contribution in direct daylight.
       float sunContrib = min(1.0, length(DiffuseSum.rgb) * modelLight.a * sunlight.x + length(AmbientSum.rgb) * modelLight.a);
       //float localContrib = length(modelLight.xyz) * localLight.x;
       //float localContrib = min(1.25 - (sunlight.x * modelLight.a), length(modelLight.xyz));
       float localContrib = max(0.0, min(1.0, 1.25 - sunContrib));

       // Local light contribution
       gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb * localContrib
                           + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x) * localContrib
                           + modelLight.xyz * specularColor.rgb * vec3(localLight.y) * localContrib;
       //gl_FragColor.rgb += modelLight.xyz * 0.25 * diffuseColor.rgb
       //                      + modelLight.xyz * diffuseColor.rgb * vec3(localLight.x)
       //                      + 1.0 * specularColor.rgb * vec3(localLight.y);

        #ifdef TEST_MODE
        #else
        // Emissive happens regardless of other lighting settings or local/sun though
        // we will mute it in full daylight... which is precisely what "localContrib"
        // should be doing.
        #ifdef HAS_EMISSIVE
            vec4 emissiveColor;
            #ifdef HAS_EMISSIVE_MAP
                emissiveColor = texture2D(m_EmissiveMap, newTexCoord);
            #else
                emissiveColor = diffuseColor;
            #endif
            emissiveColor *= m_Emissive;
            gl_FragColor.rgb += emissiveColor.rgb * emissiveColor.a * localContrib;
        #endif
        #endif

       //gl_FragColor.rgb = vec3(sunContrib);

       //gl_FragColor.rgb = specularColor.rgb;

    #endif

    #ifdef DIFFUSEMAP2
        vec4 overlayColor = calculateOverlay(lightDir, viewDir);

        float noise = fractal1(vPos);

        float margin = 0.25;
        float featherSize = 0.05;
        float feather = smoothstep(margin - featherSize, margin, noise);
        //noise = step(margin, noise);
        noise = smoothstep(margin - 0.01, margin, noise);

        feather = feather * (1.0 - noise);

        //gl_FragColor.rgb = mix(vec3(1.0), vec3(1.0, 0.0, 0.0), noise);
        //gl_FragColor.rgb = mix(vec3(1.0), gl_FragColor.rgb, noise);
        //gl_FragColor.rgb = mix(vec3(0.73, 0.71, 0.7), gl_FragColor.rgb, noise);
        gl_FragColor.rgb = mix(overlayColor.rgb, gl_FragColor.rgb, noise);
        //gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0.0, 0.0, 1.0), feather);
        //gl_FragColor.rgb = mix(gl_FragColor.rgb, vec3(0.5, 0.47, 0.44), feather);
        gl_FragColor.rgb = mix(gl_FragColor.rgb, overlayColor.rgb * 0.5, feather);
    #endif

    // add fog after the lighting because shadows will cause the fog to darken
    // which just results in the geometry looking like it's changed color
    float atmosphere = modelLight.a;
    //atmosphere = 1.0 - atmosphere;
    //atmosphere *= atmosphere;
    //atmosphere = 1.0 - atmosphere;
    atmosphere = clamp(atmosphere * 2.0, 0.0, 1.0);
    vec4 fogColor = m_FogColor * atmosphere;
    #ifdef USE_FOG
        #ifdef FOG_LINEAR
            gl_FragColor = getFogLinear(gl_FragColor, fogColor, m_LinearFog.x, m_LinearFog.y, fog_distance);
        #endif
        #ifdef FOG_EXP
            gl_FragColor = getFogExp(gl_FragColor, fogColor, m_ExpFog, fog_distance);
        #endif
        #ifdef FOG_EXPSQ
            gl_FragColor = getFogExpSquare(gl_FragColor, fogColor, m_ExpSqFog, fog_distance);
        #endif

        #ifdef HAS_FADE_DISTANCE
            // We use the fog distance for clip so we require fog for clipping to work
            float clip = min(1.0, fog_distance/m_FadeDistance);
            clip *= clip;
            clip = 1.0 - clip;

            // Shift the curve a bit so that near objects never have fractional distance-based alpha
            // For example, if the clip is 100 and the object is 25 units away then
            // the initial clip is 0.25... which we'll square: 0.0625 and subtract from
            // 1: 0.9375
            // * 1.2 = 1.125... clamped to 1.
            // In our above example, for a multiplier of 1.2, the switch over point is 0.9129
            // so for 9 meters everything is as solid as it wants to be.
            // 1.5 gives us more: 0.816
            clip = min(1.0, 1.5 * clip);

            alpha *= clip;

            #ifdef DISCARD_ALPHA
                if(alpha < m_AlphaDiscardThreshold){
                    discard;
                }
            #endif
        #endif
    #endif // end fog

    gl_FragColor.a = alpha;

    #ifdef GLASS_SPECULAR
        #ifdef DISCARD_ALPHA
            if(alpha < m_AlphaDiscardThreshold){
                discard;
            }
        #endif
    #endif

}
