#import "Common/ShaderLib/GLSLCompat.glsllib"

uniform vec4 m_Color;
uniform vec2 m_ClipRadius;

#ifdef HAS_TEXTURE
    uniform sampler2D m_Texture;
#endif

varying vec3 vModelPos;
varying vec2 vTexCoord1;
varying vec2 vTexCoord2;
varying vec4 vColor;


void main(){

    if( vModelPos.x < -m_ClipRadius.x || vModelPos.x > m_ClipRadius.x ) {
        discard;
    }

    if( vModelPos.y < -m_ClipRadius.y || vModelPos.y > m_ClipRadius.y ) {
        discard;
    }

    #ifdef HAS_TEXTURE
        vec4 color = texture2D(m_Texture, vTexCoord1);
    #else
        vec4 color = vec4(1.0);
    #endif
    color *= m_Color;
    color *= vColor;
    if( color.a < 0.01 ) {
        discard;
    }

    gl_FragColor = color; //vec4(1.0, 0.0, 0.0, 1.0);
}
