/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.jme3.scene.Spatial;
import com.simsilica.crig.CharacterRig;
import java.util.Objects;
import mythruna.client.character.CharacterDecorator;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariationDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(VariationDecorator.class);
    private String type;
    private String target;
    private CharacterRig rig;
    private ShapeName mainName;
    private ShapeName variationName;
    private volatile boolean needsApply;

    public VariationDecorator(String type, String target) {
        this.type = type;
        this.target = target;
    }

    @Override
    public void setRig(CharacterRig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        this.needsApply = true;
    }

    @Override
    public void setSpatial(Spatial spatial) {
    }

    @Override
    public void setShapeName(ShapeName name) {
        this.mainName = name;
        this.setVariationName(this.find(this.type, name));
    }

    protected void setVariationName(ShapeName variationName) {
        if (Objects.equals(this.variationName, variationName)) {
            return;
        }
        this.variationName = variationName;
        this.needsApply = true;
    }

    @Override
    public boolean apply() {
        if (!this.needsApply) {
            return false;
        }
        int index = 0;
        if (this.variationName != null) {
            index = Integer.parseInt(this.variationName.getName());
        }
        if (!this.rig.hasVariation(this.target)) {
            if (index == 0) {
                return false;
            }
            log.warn("Missing variation type:" + this.target + " to:" + index + " on:" + this.rig + " mainName:" + this.mainName);
            return false;
        }
        if (this.rig != null) {
            if (log.isTraceEnabled()) {
                log.trace("setting rig varation for:" + this.target + " to:" + index + " on:" + this.rig + " mainName:" + this.mainName);
            }
            this.rig.setVariation(this.target, index);
        }
        this.needsApply = false;
        return true;
    }

    protected ShapeName find(String type, ShapeName name) {
        if (type.equals(name.getType())) {
            return name;
        }
        for (ShapeName sub : name.getAddOns()) {
            if (!type.equals(sub.getType())) continue;
            return sub;
        }
        return null;
    }
}

