/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TileChangeEvent;
import com.simsilica.mworld.tile.TileListener;
import com.simsilica.mworld.tile.pc.Point;
import com.simsilica.mworld.tile.pc.PointCloudData;
import com.simsilica.mworld.tile.pc.PointCloudLayer;
import com.simsilica.mworld.tile.pc.PointType;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.MaterialFactories;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.ViewMask;
import com.simsilica.sim.Blackboard;
import com.simsilica.state.BlackboardState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PointCloudState.class);
    private Node viewRoot;
    private Blackboard blackboard;
    private World world;
    private String workerPoolId = "regularWorkers";
    private JobState workers;
    private int basePriority = 500;
    private VersionedReference<Vec3d> posRef;
    private Function<PointType, Material> materialFactory;
    private int viewRadius = 2;
    private int conveyorSize = this.viewRadius * 2 + 1;
    private Slot[] slots;
    private Vec3i center = new Vec3i(0, 100, 0);
    private Vec3i centerWorld = new Vec3i();
    private ViewMask viewMask;
    private VersionedReference<Vec3i> maskCenter;
    private SafeArrayList<TileGeometry> fadingTiles = new SafeArrayList(TileGeometry.class);
    private boolean xzLockedCamera = false;
    private PointCloudObserver pcObserver = new PointCloudObserver();
    private ConcurrentLinkedQueue<TileId> invalidTiles = new ConcurrentLinkedQueue();
    private FogSettings fogSettings;
    private VersionedReference<FogSettings> fogSettingsRef;
    private float clipDistance = 6000.0f;
    private float pointScale = 1.0f;

    public PointCloudState() {
        this(null, true);
    }

    public PointCloudState(boolean enabled) {
        this(null, enabled);
    }

    public PointCloudState(Blackboard blackboard) {
        this(blackboard, true);
    }

    public PointCloudState(Blackboard blackboard, boolean enabled) {
        this.setEnabled(enabled);
        this.blackboard = blackboard;
    }

    public PointCloudState xzLockedCamera(boolean xzLockedCamera) {
        this.setXzLockedCamera(xzLockedCamera);
        return this;
    }

    public PointCloudState workerPoolId(String workerPoolId) {
        this.workerPoolId = workerPoolId;
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot change the worker pool once initialized");
        }
        return this;
    }

    public void setXzLockedCamera(boolean f) {
        this.xzLockedCamera = f;
    }

    public boolean isXzLockedCamera() {
        return this.xzLockedCamera;
    }

    public void setClipDistance(float distance) {
        if (this.clipDistance == distance) {
            return;
        }
        this.clipDistance = distance;
        this.resetFog();
    }

    public float getClipDistance() {
        return this.clipDistance;
    }

    public void setFogSettings(FogSettings fogSettings) {
        this.fogSettings = fogSettings;
        this.fogSettingsRef = fogSettings == null ? null : fogSettings.createReference();
        this.resetFog();
    }

    public FogSettings getFogSettings() {
        return this.fogSettings;
    }

    public void setPointScale(float pointScale) {
        log.info("setPointScale(" + pointScale + ")");
        if (this.pointScale == pointScale) {
            return;
        }
        this.pointScale = pointScale;
        if (this.slots != null) {
            for (Slot slot : this.slots) {
                if (slot.tile == null) continue;
                slot.tile.setPointScale(pointScale);
            }
        }
    }

    public float getPointScale() {
        return this.pointScale;
    }

    protected int getFogDistance() {
        return this.fogSettings == null ? 0 : this.fogSettings.getFogDistance();
    }

    protected void resetFog() {
        if (this.viewRoot != null) {
            TerrainState.updateFogDistance((Spatial)this.viewRoot, this.getFogDistance(), this.clipDistance);
        }
    }

    public void setMaterialFactory(Function<PointType, Material> materialFactory) {
        if (this.materialFactory == materialFactory) {
            return;
        }
        this.materialFactory = materialFactory;
        if (this.slots != null) {
            for (Slot slot : this.slots) {
                if (slot.tile == null) continue;
                slot.tile.updateMaterial(materialFactory);
            }
        }
    }

    public Function<PointType, Material> getMaterialFactory() {
        return this.materialFactory;
    }

    protected void setViewMask(ViewMask viewMask) {
        this.viewMask = viewMask;
        this.maskCenter = viewMask.createReference();
        if (this.slots != null) {
            for (Slot slot : this.slots) {
                if (slot.tile == null) continue;
                slot.tile.updateViewMask();
            }
        }
    }

    protected void initializeSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        int radius = this.viewRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                list.add(new Slot(x, z));
            }
        }
        Collections.sort(list);
        this.slots = list.toArray(new Slot[0]);
    }

    protected void initialize(Application app) {
        this.viewRoot = new Node("PointCloudRoot");
        this.initializeSlots();
        if (this.getMaterialFactory() == null) {
            log.warn("No material factory configured.  Using a default pointCloudMaterial()");
            this.setMaterialFactory(MaterialFactories.pointCloudMaterial(this.getApplication()));
        }
        if (this.blackboard == null) {
            this.blackboard = ((BlackboardState)this.getState(BlackboardState.class, true)).getBlackboard();
        }
        this.world = (World)this.blackboard.get(World.class);
        this.blackboard.onInitialize(ViewMask.class, mask -> this.setViewMask((ViewMask)mask));
        this.blackboard.onInitialize(FogSettings.class, fogSettings -> this.setFogSettings((FogSettings)fogSettings));
        this.workers = (JobState)this.getState(this.workerPoolId, JobState.class);
        this.posRef = ((VersionedObject)this.blackboard.get("position")).createReference();
        this.world.addTileListener(this.pcObserver);
    }

    protected void cleanup(Application app) {
        this.world.removeTileListener(this.pcObserver);
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.viewRoot);
    }

    protected void onDisable() {
        this.viewRoot.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            TileGeometry[] pos = (TileGeometry[])this.posRef.get();
            this.updateTiles((Vec3d)pos);
            if (this.xzLockedCamera) {
                this.viewRoot.setLocalTranslation(-((float)(pos.x - (double)this.centerWorld.x)), 0.0f, -((float)(pos.z - (double)this.centerWorld.z)));
            } else {
                Vec3d columnPos = ColumnId.fromWorld((Vec3d)pos).getWorld(null).toVec3d();
                this.viewRoot.setLocalTranslation(-((float)(columnPos.x - (double)this.centerWorld.x)), 0.0f, -((float)(columnPos.z - (double)this.centerWorld.z)));
            }
        }
        if (this.fogSettingsRef != null && this.fogSettingsRef.update()) {
            this.resetFog();
        }
        for (TileGeometry tg : (TileGeometry[])this.fadingTiles.getArray()) {
            tg.update(tpf);
        }
        TileId toUpdate = null;
        while ((toUpdate = this.invalidTiles.poll()) != null) {
            for (Slot slot : this.slots) {
                TileGeometry tile = slot.tile;
                if (!Objects.equals(tile.id, toUpdate)) continue;
                tile.queued = true;
                this.workers.execute((Job)tile, this.basePriority);
            }
        }
        if (this.maskCenter.update()) {
            this.updateTileMasks((Vec3i)this.maskCenter.get());
        }
    }

    protected void updateTiles(Vec3d pos) {
        Vec3i newCenter = TileId.GRID.worldToCell(pos);
        if (newCenter.equals((Object)this.center)) {
            return;
        }
        this.center.set(newCenter);
        this.centerWorld = TileId.GRID.cellToWorld(this.center);
        System.out.println("Need to refresh point cloud tiles.... tile Center:" + this.center + "  world center:" + this.centerWorld);
        int radius = this.viewRadius;
        HashMap<TileId, TileGeometry> tileMap = new HashMap<TileId, TileGeometry>();
        for (Slot slot : this.slots) {
            TileGeometry tile = slot.tile;
            if (tile == null) continue;
            tileMap.put(tile.id, tile);
        }
        for (Slot slot : this.slots) {
            int xTile = this.centerWorld.x + slot.xTile;
            int yTile = this.centerWorld.y;
            int zTile = this.centerWorld.z + slot.zTile;
            TileId id = TileId.fromWorld(xTile, yTile, zTile);
            TileGeometry tile = (TileGeometry)tileMap.remove(id);
            if (tile == null) {
                tile = new TileGeometry(id, xTile, zTile);
                tile.setMaskCenter((Vec3i)this.maskCenter.get());
                int priority = this.basePriority + slot.priority;
                tile.queued = true;
                this.workers.execute((Job)tile, priority);
            }
            tile.setPosition(slot.xTile, 0.0f, slot.zTile);
            slot.tile = tile;
        }
        for (TileGeometry tile : tileMap.values()) {
            if (tile.queued && this.workers.cancel((Job)tile)) {
                tile.queued = false;
            }
            tile.release();
        }
    }

    protected void updateTileMasks(Vec3i center) {
        for (Slot slot : this.slots) {
            TileGeometry tile = slot.tile;
            if (tile == null) continue;
            tile.setMaskCenter(center);
        }
    }

    protected Vector2f colorToUv(int color) {
        int x = color & 7;
        int y = (color & 0x38) >> 3;
        float textureScale = 0.125f;
        float halfScale = textureScale * 0.5f;
        float s = (float)x * textureScale + halfScale;
        float t = 1.0f - ((float)y * textureScale + halfScale);
        return new Vector2f(s, t);
    }

    protected Vector4f lightToVec4(int light) {
        float s = (float)LightUtils.sun((int)light) / 15.0f;
        float r = (float)LightUtils.red((int)light) / 15.0f;
        float g = (float)LightUtils.green((int)light) / 15.0f;
        float b = (float)LightUtils.blue((int)light) / 15.0f;
        return new Vector4f(r, g, b, s);
    }

    protected Geometry createGeometry(PointCloudLayer layer) {
        PointType pointType = new PointType(0);
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Points);
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        ArrayList<Vector3f> norms = new ArrayList<Vector3f>();
        ArrayList<Vector2f> uvs = new ArrayList<Vector2f>();
        ArrayList<Vector4f> colors = new ArrayList<Vector4f>();
        int faces = 0;
        int maxCloudSize = 0;
        for (PointCloudData pc : layer.getPointClouds()) {
            int xBase = pc.getOriginX();
            int zBase = pc.getOriginZ();
            Point[] points = pc.getPoints(pointType);
            if (points == null || points.length == 0) continue;
            if (points.length > maxCloudSize) {
                maxCloudSize = points.length;
            }
            for (Point p : points) {
                if (p.index >= 65) continue;
                verts.add(new Vector3f((float)(xBase + p.x), (float)p.y, (float)(zBase + p.z)));
                float xd = 0.0f;
                float yd = 0.0f;
                float zd = 0.0f;
                byte mask = p.direction;
                if (DirectionMasks.hasEastOrWest((int)mask)) {
                    if (!DirectionMasks.hasEast((int)mask)) {
                        xd = 0.25f;
                        ++faces;
                    } else if (!DirectionMasks.hasWest((int)mask)) {
                        xd = 0.75f;
                        ++faces;
                    } else {
                        xd = 0.5f;
                        ++faces;
                        ++faces;
                    }
                }
                if (DirectionMasks.hasUpOrDown((int)mask)) {
                    if (!DirectionMasks.hasUp((int)mask)) {
                        yd = 0.25f;
                        ++faces;
                    } else if (!DirectionMasks.hasDown((int)mask)) {
                        yd = 0.75f;
                        ++faces;
                    } else {
                        yd = 0.5f;
                        ++faces;
                        ++faces;
                    }
                }
                if (DirectionMasks.hasNorthOrSouth((int)mask)) {
                    if (!DirectionMasks.hasSouth((int)mask)) {
                        zd = 0.25f;
                        ++faces;
                    } else if (!DirectionMasks.hasNorth((int)mask)) {
                        zd = 0.75f;
                        ++faces;
                    } else {
                        zd = 0.5f;
                        ++faces;
                        ++faces;
                    }
                }
                norms.add(new Vector3f(xd, yd, zd));
                uvs.add(this.colorToUv(p.index - 1));
                colors.add(this.lightToVec4(p.light));
            }
        }
        log.info("Cloud points count:" + verts.size() + "  visible faces:" + faces);
        log.info("Max cloud size:" + maxCloudSize);
        int vertCount = verts.size();
        FloatBuffer pb = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        FloatBuffer tb = BufferUtils.createFloatBuffer((int)(vertCount * 2));
        FloatBuffer nb = BufferUtils.createFloatBuffer((int)(vertCount * 3));
        FloatBuffer cb = BufferUtils.createFloatBuffer((int)(vertCount * 4));
        for (Vector3f v : verts) {
            pb.put(v.x);
            pb.put(v.y);
            pb.put(v.z);
        }
        for (Vector3f v : norms) {
            nb.put(v.x);
            nb.put(v.y);
            nb.put(v.z);
        }
        for (Vector2f v : uvs) {
            tb.put(v.x);
            tb.put(v.y);
        }
        for (Vector4f v : colors) {
            cb.put(v.x);
            cb.put(v.y);
            cb.put(v.z);
            cb.put(v.w);
        }
        mesh.setBuffer(VertexBuffer.Type.Position, 3, pb);
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, tb);
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        mesh.setBuffer(VertexBuffer.Type.Color, 4, cb);
        mesh.setStatic();
        mesh.updateBound();
        GuiGlobals globals = GuiGlobals.getInstance();
        Texture texture = globals.loadTexture("Textures/palette-desert.png", true, true);
        Geometry geom = new Geometry("pointCloud:" + layer.getTileId(), mesh);
        Material mat = this.materialFactory.apply(null);
        if (this.fogSettings != null) {
            this.fogSettings.apply(mat);
        }
        geom.setMaterial(mat);
        Camera cam = this.getApplication().getCamera();
        float c = cam.getProjectionMatrix().m00;
        mat.setFloat("Quadratic", c *= (float)cam.getWidth() * 0.5f);
        mat.setFloat("PointScale", this.pointScale);
        log.info("setting created material point scale to:" + this.pointScale);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        TerrainState.updateFogDistance((Spatial)geom, this.getFogDistance(), this.clipDistance);
        return geom;
    }

    private class PointCloudObserver
    implements TileListener {
        private PointCloudObserver() {
        }

        @Override
        public void tileChanged(TileChangeEvent event) {
            if (event.getResolution() != Resolution.High) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("tileChanged(" + event + ")");
            }
            PointCloudState.this.invalidTiles.add(event.getTileId());
        }
    }

    private class TileGeometry
    implements Job {
        TileId id;
        int xCorner;
        int zCorner;
        PointCloudLayer pointLayer;
        Geometry generatedGeom;
        Geometry geom;
        Vector3f position = new Vector3f();
        volatile boolean visible;
        boolean firstTime = true;
        private volatile boolean queued;
        Vector3f maskOffset = new Vector3f();
        float alpha;

        public TileGeometry(TileId id, int xCorner, int zCorner) {
            this.id = id;
            this.xCorner = xCorner;
            this.zCorner = zCorner;
            this.visible = true;
        }

        public void setPointScale(float pointScale) {
            if (this.geom != null) {
                this.geom.getMaterial().setFloat("PointScale", pointScale);
                log.info("setting material point scale to:" + pointScale);
            }
        }

        public void updateMaterial(Function<PointType, Material> materialFactory) {
            if (this.geom != null) {
                Material material = materialFactory.apply(null);
                if (PointCloudState.this.fogSettings != null) {
                    PointCloudState.this.fogSettings.apply(material);
                }
                this.geom.setMaterial(material);
                this.geom.getMaterial().setFloat("PointScale", PointCloudState.this.pointScale);
                log.info("setting updated material point scale to:" + PointCloudState.this.pointScale);
            }
        }

        public void updateViewMask() {
            Material material = this.geom.getMaterial();
            if (log.isTraceEnabled()) {
                log.trace(this.id + ".updateViewMask() viewMask:" + PointCloudState.this.viewMask + "  material:" + material);
            }
            if (PointCloudState.this.viewMask != null && material != null) {
                material.setTexture("MaskArray", PointCloudState.this.viewMask.getMaskTextures());
                material.setVector3("MaskOffset", this.maskOffset);
                material.setFloat("ViewMaskRadiusXZ", (float)((PointCloudState)PointCloudState.this).viewMask.getViewRadius().x);
                material.setFloat("ViewMaskRadiusY", (float)((PointCloudState)PointCloudState.this).viewMask.getViewRadius().y);
            }
        }

        public void setMaskCenter(Vec3i center) {
            Vec3i world = this.id.getWorld(null);
            if (log.isTraceEnabled()) {
                log.trace(this.id + ".setMaskCenter(" + center + ") world:" + world + "  corner:" + this.xCorner + ", " + this.zCorner);
            }
            this.maskOffset.x = center.x - world.x;
            this.maskOffset.y = center.y;
            this.maskOffset.z = center.z - world.z;
        }

        public void update(float tpf) {
            this.alpha += tpf;
            if (this.alpha >= 1.0f) {
                PointCloudState.this.fadingTiles.remove((Object)this);
                this.alpha = 1.0f;
            }
            this.geom.getMaterial().setFloat("Alpha", this.alpha);
        }

        public void setPosition(float x, float y, float z) {
            this.position.set(x, y, z);
            if (this.geom != null) {
                this.geom.setLocalTranslation(x, y, z);
            }
        }

        public void release() {
            this.visible = false;
            if (this.geom != null) {
                this.geom.removeFromParent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnWorker() {
            if (!this.visible) {
                return;
            }
            this.queued = false;
            this.pointLayer = PointCloudState.this.world.getPointCloudLayer(this.id, Resolution.High);
            Geometry temp = PointCloudState.this.createGeometry(this.pointLayer);
            if (temp != null) {
                temp.getMaterial().setVector3("MaskOffset", this.maskOffset);
            }
            TileGeometry tileGeometry = this;
            synchronized (tileGeometry) {
                this.generatedGeom = temp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double runOnUpdate() {
            if (this.visible) {
                if (this.geom != null) {
                    this.geom.removeFromParent();
                }
                TileGeometry tileGeometry = this;
                synchronized (tileGeometry) {
                    this.geom = this.generatedGeom;
                    this.updateViewMask();
                }
                PointCloudState.this.viewRoot.attachChild((Spatial)this.geom);
                this.geom.setLocalTranslation(this.position);
                if (this.firstTime) {
                    this.firstTime = false;
                    this.alpha = 0.0f;
                    PointCloudState.this.fadingTiles.add((Object)this);
                } else {
                    this.alpha = 1.0f;
                }
                this.geom.getMaterial().setFloat("Alpha", this.alpha);
                return 1.0;
            }
            return 0.0;
        }

        public String toString() {
            return "PointCloud[" + this.xCorner + ", " + this.zCorner + "]";
        }
    }

    private class Slot
    implements Comparable<Slot> {
        int xSlot;
        int zSlot;
        int xTile;
        int zTile;
        int priority;
        TileGeometry tile;

        public Slot(int xSlot, int zSlot) {
            this.xSlot = xSlot;
            this.zSlot = zSlot;
            this.xTile = xSlot * 1024;
            this.zTile = zSlot * 1024;
            this.priority = xSlot * xSlot + zSlot * zSlot;
        }

        @Override
        public int compareTo(Slot slot) {
            if (this.priority < slot.priority) {
                return -1;
            }
            if (this.priority > slot.priority) {
                return 1;
            }
            return 0;
        }
    }
}

