/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mythruna.character.FabricName;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricOption {
    static Logger log = LoggerFactory.getLogger(FabricOption.class);
    private String name;
    private FabricName targetFabric;
    private List<FabricName> fabrics;

    private FabricOption() {
    }

    public FabricOption(String name, FabricName targetFabric) {
        this.name = name;
        this.targetFabric = targetFabric;
        this.fabrics = new ArrayList<FabricName>();
    }

    public String getName() {
        return this.name;
    }

    public FabricName getTargetFabric() {
        return this.targetFabric;
    }

    public List<FabricName> getFabrics() {
        return this.fabrics;
    }

    public void expand() {
        ArrayList<FabricName> list = new ArrayList<FabricName>();
        for (FabricName fabric : this.fabrics) {
            if (fabric.getVariation() != null) {
                list.add(fabric);
                continue;
            }
            for (FabricType type : FabricTypeIndex.getVariations(fabric.getName())) {
                list.add(new FabricName(type.getName(), type.getVariation()));
            }
        }
        this.fabrics = list;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetFabric);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        FabricOption other = (FabricOption)o;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.targetFabric, other.targetFabric)) {
            return false;
        }
        return Objects.equals(this.fabrics, other.fabrics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("targetFabric", (Object)this.targetFabric).toString();
    }
}

