/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.mathd.Vec3d;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.SteeringPrimitive;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimtiveFleeBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(PrimtiveFleeBehavior.class);
    private String defaultAction;
    private Mob flee;
    private double maxWait;
    private double timeout;
    private double fleeDistance;
    private double speedScale;
    private SteeringPrimitive arrive;

    public PrimtiveFleeBehavior(Mob flee, String defaultAction, double maxWait) {
        this(flee, defaultAction, maxWait, 1.0);
    }

    public PrimtiveFleeBehavior(Mob flee, String defaultAction, double maxWait, double speedScale) {
        this.defaultAction = defaultAction;
        this.maxWait = maxWait;
        this.flee = flee;
        this.timeout = maxWait;
        this.fleeDistance = maxWait;
        this.speedScale = speedScale;
    }

    @Override
    protected void onStart(Brain brain) {
        log.info("onStart()");
        Vec3d dir = brain.getAgent().getLocation().subtract(this.flee.getLocation()).normalizeLocal();
        Vec3d target = brain.getAgent().getLocation().add(dir.mult(this.fleeDistance));
        target.y += 5.0;
        this.arrive = SteeringPrimitives.arrive(brain.getAgent(), target, 0.5);
        if (this.speedScale != 1.0) {
            this.arrive = SteeringPrimitives.scaleSpeed(this.arrive, this.speedScale);
        }
        brain.getAgent().setDefaultAction(this.defaultAction);
        brain.getAgent().setSteering(this.arrive);
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.flee == null) {
            return false;
        }
        this.timeout -= step;
        if (this.timeout < 0.0) {
            log.info("Got tired of following.");
            this.flee = null;
            return false;
        }
        this.getBrain().getAgent().setSteering(this.arrive);
        return true;
    }

    @Override
    protected void onStop() {
        log.info("onStop()");
    }
}

