/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.input;

import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import java.lang.reflect.Method;

public class StateMethodDelegate
implements StateFunctionListener {
    private Object target;
    private Method method;
    private boolean takesArgument;

    public StateMethodDelegate(Object target, String method) {
        this(target, method, false);
    }

    public StateMethodDelegate(Object target, String method, boolean takesArgument) {
        this.target = target;
        this.method = StateMethodDelegate.resolveMethod(target.getClass(), method, takesArgument);
        this.takesArgument = takesArgument;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    protected static Method resolveMethod(Class targetClass, String name, boolean takesArgument) {
        try {
            if (takesArgument) {
                return targetClass.getMethod(name, InputState.class);
            }
            return targetClass.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error resolving delegate method:" + name, e);
        }
    }

    protected void callMethod(InputState state) {
        try {
            if (this.takesArgument) {
                this.method.invoke(this.target, new Object[]{state});
            } else {
                this.method.invoke(this.target, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error calling method:" + this.method, e);
        }
    }

    @Override
    public void valueChanged(FunctionId func, InputState value, double tpf) {
        if (this.takesArgument || value == InputState.Off) {
            this.callMethod(value);
        }
    }
}

