/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionFiles {
    static Logger log = LoggerFactory.getLogger(RevisionFiles.class);
    private Path base;
    private Path revisionBase;

    public RevisionFiles(File base, File revisionBase) {
        this.base = base.toPath();
        this.revisionBase = revisionBase.toPath();
    }

    protected String revisionToString(long revision) {
        return String.valueOf(revision);
    }

    protected long stringToRevision(String revision) {
        return Long.parseLong(revision);
    }

    public Path getRevision(Path current, long revision) {
        Path rel = this.base.relativize(current);
        return this.revisionBase.resolve(this.revisionToString(revision)).resolve(rel);
    }

    public File getRevision(File current, long revision) {
        return this.getRevision(current.toPath(), revision).toFile();
    }

    public List<Long> getRevisions(File current) throws IOException {
        Path rel = this.base.relativize(current.toPath());
        return Files.list(this.revisionBase).map(d -> {
            Path rev = d.resolve(rel);
            if (Files.exists(rev, new LinkOption[0])) {
                return this.stringToRevision(d.getName(d.getNameCount() - 1).toString());
            }
            return null;
        }).filter(d -> d != null).collect(Collectors.toList());
    }

    public List<File> getBackups(File current) throws IOException {
        Path rel = this.base.relativize(current.toPath());
        return Files.list(this.revisionBase).map(d -> {
            Path rev = d.resolve(rel);
            if (Files.exists(rev, new LinkOption[0])) {
                return rev.toFile();
            }
            return null;
        }).filter(d -> d != null).collect(Collectors.toList());
    }

    public File backup(File current, long revision) throws IOException {
        if (!current.exists()) {
            throw new IllegalArgumentException("File does not exist:" + current);
        }
        Path path = current.toPath();
        Path target = this.getRevision(path, revision);
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        Files.move(path, target, new CopyOption[0]);
        return target.toFile();
    }
}

