/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.net;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.ethereal.net.ObjectState;
import com.simsilica.ethereal.net.ObjectStateProtocol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FrameState {
    public long legacySequence;
    public long time;
    public long columnId;
    public List<ObjectState> states = new ArrayList<ObjectState>();
    public long estimatedBitSize;

    public FrameState() {
        this(-1L, -1L, -1L);
    }

    public FrameState(long time, long legacySequence, long columnId) {
        this.time = time;
        this.legacySequence = legacySequence;
        this.columnId = columnId;
        this.estimatedBitSize = FrameState.getHeaderBitSize();
    }

    public static int getHeaderBitSize() {
        return 144;
    }

    public long getEstimatedBitSize() {
        return this.estimatedBitSize;
    }

    public void addState(ObjectState state, ObjectStateProtocol protocol) {
        if (state.networkId == -1) {
            throw new IllegalArgumentException("Incomplete state added to frame:" + state);
        }
        this.states.add(state);
        this.estimatedBitSize += (long)protocol.getEstimatedBitSize(state);
    }

    public FrameState split(long limit, ObjectStateProtocol protocol) {
        ObjectState s;
        int bits;
        int split;
        if (this.estimatedBitSize <= limit) {
            return null;
        }
        long size = FrameState.getHeaderBitSize();
        for (split = 0; split < this.states.size() && size + (long)(bits = protocol.getEstimatedBitSize(s = this.states.get(split))) <= limit; ++split) {
            size += (long)bits;
        }
        if (split == 0 || split == this.states.size()) {
            throw new RuntimeException("Error splitting message. split:" + split + " limit:" + limit);
        }
        long leftOverBits = this.estimatedBitSize - size;
        FrameState result = new FrameState(this.time, this.legacySequence + 1L, this.columnId);
        result.states = this.states.subList(split, this.states.size());
        result.estimatedBitSize += leftOverBits;
        this.estimatedBitSize = size;
        this.states = this.states.subList(0, split);
        return result;
    }

    public void writeBits(BitOutputStream out, ObjectStateProtocol protocol) throws IOException {
        out.writeLongBits(this.time, 64);
        out.writeLongBits(this.legacySequence, 64);
        out.writeLongBits(this.columnId, 64);
        out.writeBits(this.states.size(), 16);
        for (ObjectState s : this.states) {
            protocol.writeBits(s, out);
        }
    }

    public void readBits(BitInputStream in, ObjectStateProtocol protocol) throws IOException {
        this.time = in.readLongBits(64);
        this.legacySequence = in.readLongBits(64);
        this.columnId = in.readLongBits(64);
        int size = in.readBits(16);
        this.states.clear();
        for (int i = 0; i < size; ++i) {
            ObjectState s = protocol.readBits(in);
            this.states.add(s);
        }
    }

    public String toString() {
        return "FrameState[time=" + this.time + ", legacySequence=" + this.legacySequence + ", columnId=" + this.columnId + ", states=" + this.states + "]";
    }
}

