/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.zone;

import com.simsilica.ethereal.zone.StateBlock;
import com.simsilica.ethereal.zone.StateFrame;
import com.simsilica.ethereal.zone.Zone;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.AaBBox;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneManager {
    static Logger log = LoggerFactory.getLogger(ZoneManager.class);
    private ZoneGrid grid;
    private final Map<Long, ZoneRange> index = new HashMap<Long, ZoneRange>();
    private Set<Long> noUpdates;
    private long updateTime = -1L;
    private final Map<ZoneKey, Zone> zones = new ConcurrentHashMap<ZoneKey, Zone>(16, 0.75f, 2);
    private final Lock historyLock = new ReentrantLock();
    private final Set<Long> pendingRemoval = new HashSet<Long>();
    private boolean collectHistory = false;
    private int historyBacklog;
    private long[] historyIndex;
    private int historySize = 0;
    private long nextLog = 0L;
    private long updateStartTime = 0L;
    private long totalUpdateTime = 0L;
    private boolean dynamicZoneRange = false;
    private int frameUnderflowLimit = 60;
    private int frameOverflowLimit = 70;
    long frameCounter = 0L;
    long nextFrameTime = System.nanoTime() + 1000000000L;

    public ZoneManager(int zoneSize) {
        this(new ZoneGrid(zoneSize));
    }

    public ZoneManager(ZoneGrid grid) {
        this(grid, 12);
    }

    public ZoneManager(ZoneGrid grid, int historyBacklog) {
        this.grid = grid;
        this.historyBacklog = historyBacklog;
        this.historyIndex = new long[historyBacklog];
    }

    public ZoneGrid getGrid() {
        return this.grid;
    }

    public void setSupportLargeObjects(boolean b) {
        this.dynamicZoneRange = b;
    }

    public boolean getSupportLargeObjects() {
        return this.dynamicZoneRange;
    }

    public void setCollectHistory(boolean b) {
        this.collectHistory = b;
    }

    public boolean getCollectHistory() {
        return this.collectHistory;
    }

    public void setFrameRateLimits(int frameUnderflowLimit, int frameOverflowLimit) {
        if (frameUnderflowLimit < 0 || frameOverflowLimit < 0) {
            throw new IllegalArgumentException("Frame limits must be positive.");
        }
        if (frameUnderflowLimit > frameOverflowLimit) {
            throw new IllegalArgumentException("Frame underflow limit must be less than the overflow limit.");
        }
        this.frameUnderflowLimit = frameUnderflowLimit;
        this.frameOverflowLimit = frameOverflowLimit;
    }

    public void setFrameUnderflowLimit(int frameUnderflowLimit) {
        if (frameUnderflowLimit < 0) {
            throw new IllegalArgumentException("Frame underflow limit must be positive.");
        }
        if (frameUnderflowLimit > this.frameOverflowLimit) {
            throw new IllegalArgumentException("Frame underflow limit must be less than the overflow limit.");
        }
        this.frameUnderflowLimit = frameUnderflowLimit;
    }

    public int getFrameUnderflowLimit() {
        return this.frameUnderflowLimit;
    }

    public void setFrameOverflowLimit(int frameOverflowLimit) {
        if (frameOverflowLimit < 0) {
            throw new IllegalArgumentException("Frame overflow limit must be positive.");
        }
        if (frameOverflowLimit < this.frameUnderflowLimit) {
            throw new IllegalArgumentException("Frame overflow limit must be larger than the underflow limit.");
        }
        this.frameOverflowLimit = frameOverflowLimit;
    }

    public int getFrameOverflowLimit() {
        return this.frameOverflowLimit;
    }

    protected ZoneRange getZoneRange(Long id, boolean create) {
        ZoneRange result = this.index.get(id);
        if (result == null && create) {
            result = this.dynamicZoneRange ? new DynamicZoneRange(id) : new OctZoneRange(id);
            this.index.put(id, result);
        }
        return result;
    }

    public void beginUpdate(long time) {
        if (log.isTraceEnabled()) {
            log.trace("beginUpdate(" + time + ")");
        }
        this.updateStartTime = System.nanoTime();
        this.updateTime = time;
        ++this.frameCounter;
        if (this.updateStartTime > this.nextFrameTime) {
            if (this.frameCounter < (long)this.frameUnderflowLimit) {
                log.warn("zone update underflow FPS:" + this.frameCounter);
            } else if (this.frameCounter > (long)this.frameOverflowLimit) {
                log.warn("zone update overflow FPS:" + this.frameCounter);
            }
            this.frameCounter = 0L;
            this.nextFrameTime = System.nanoTime() + 1000000000L;
        }
        this.noUpdates = new HashSet<Long>(this.index.keySet());
        this.noUpdates.removeAll(this.pendingRemoval);
        for (Zone z : this.zones.values()) {
            z.beginUpdate(time);
        }
        for (Long id : this.pendingRemoval) {
            if (log.isDebugEnabled()) {
                log.debug("ZONE:  --- delayed deactivation:" + id);
            }
            ZoneRange range = this.index.remove(id);
            if (log.isDebugEnabled()) {
                log.debug("range:" + range);
            }
            if (range == null) continue;
            range.leave(id);
        }
        this.pendingRemoval.clear();
    }

    public void updateEntity(Long id, boolean active, Vec3d p, Quatd orientation, AaBBox bounds) {
        if (log.isTraceEnabled()) {
            log.trace("updateEntity(" + id + ", " + active + ", " + p + ")");
        }
        this.updateEntity(null, id, active, p, orientation, bounds);
    }

    public void updateEntity(Long parent, Long child, boolean active, Vec3d p, Quatd orientation, AaBBox bounds) {
        Vec3i maxZone;
        Vec3i minZone;
        ZoneRange parentRange;
        ZoneRange range = this.getZoneRange(child, true);
        range.setParent(parent);
        ZoneRange zoneRange = parentRange = parent == null ? null : this.getZoneRange(parent, false);
        if (parent != null && parentRange == null) {
            log.warn("Child:" + child + " has no active parent:" + parent);
        }
        if (parentRange == null) {
            range.setParent(null);
            minZone = this.grid.worldToZone(bounds.getMin());
            maxZone = this.grid.worldToZone(bounds.getMax());
        } else {
            minZone = parentRange.getMin();
            maxZone = parentRange.getMax();
        }
        if (!(minZone.equals((Object)range.getMin()) && maxZone.equals((Object)range.getMax()) || range.setRange(minZone, maxZone))) {
            log.error("Error setting range for object:" + child + " from bounds:" + bounds + " grid size:" + this.grid.getZoneSize() + " likely too small for object with extents:" + bounds.getExtents());
        }
        range.sendUpdate(p.clone(), orientation.clone());
        this.noUpdates.remove(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        log.trace("endUpdate()");
        if (!this.collectHistory) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("No-updates for keys:" + this.noUpdates);
        }
        if (this.noUpdates != null && !this.noUpdates.isEmpty()) {
            for (Long id : this.noUpdates) {
                ZoneRange range = this.getZoneRange(id, false);
                if (range == null) {
                    log.warn("No zone range found for no-change key:" + id);
                    continue;
                }
                range.sendNoChange();
            }
        }
        log.trace("writing history");
        this.historyLock.lock();
        try {
            if (this.historySize + 1 >= this.historyIndex.length) {
                log.warn("Pausing history collect.  Overflow detected, current history size:" + this.historySize + " max:" + this.historyBacklog);
                return;
            }
            this.historyIndex[this.historySize++] = this.updateTime;
            Iterator<Map.Entry<ZoneKey, Zone>> i = this.zones.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<ZoneKey, Zone> e = i.next();
                Zone z = e.getValue();
                if (z.commitUpdate() || !z.isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Zone no longer active:" + e.getKey() + "  active zones:" + this.zones.keySet());
                }
                i.remove();
            }
        }
        finally {
            log.trace("done writing history");
            this.historyLock.unlock();
        }
        this.updateTime = -1L;
        long end = System.nanoTime();
        this.totalUpdateTime += end - this.updateStartTime;
        if (end > this.nextLog) {
            this.nextLog = end + 1000000000L;
            this.totalUpdateTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateFrame[] purgeState() {
        this.historyLock.lock();
        try {
            int high = 5;
            if (this.historySize > high) {
                log.warn("Purging >" + high + " history frames:" + this.historySize);
            }
            StateFrame[] state = new StateFrame[this.historySize];
            for (Map.Entry<ZoneKey, Zone> e : this.zones.entrySet()) {
                Zone z = e.getValue();
                StateBlock[] history = z.purgeHistory();
                int h = 0;
                for (StateBlock b : history) {
                    if (b.getTime() < this.historyIndex[h]) {
                        throw new RuntimeException("StateBlock precedes history index. Time:" + b.getTime() + "  history index:" + h + "  history time:" + this.historyIndex[h]);
                    }
                    while (b.getTime() > this.historyIndex[h]) {
                        ++h;
                    }
                    if (state[h] == null) {
                        state[h] = new StateFrame(this.historyIndex[h], this.zones.size());
                    }
                    state[h].add(b);
                    state[h].addWarps(b.getWarps());
                }
            }
            this.historySize = 0;
            StateFrame[] stateFrameArray = state;
            return stateFrameArray;
        }
        finally {
            this.historyLock.unlock();
        }
    }

    public void add(Long id) {
        if (log.isDebugEnabled()) {
            log.debug("ZONE:  +++ activated:" + id);
        }
        this.pendingRemoval.remove(id);
    }

    public void remove(Long id) {
        if (log.isDebugEnabled()) {
            log.debug("ZONE:  --- deactivated:" + id);
        }
        ZoneRange range = this.index.get(id);
        if (log.isDebugEnabled()) {
            log.debug("range:" + range);
        }
        if (range == null) {
            return;
        }
        if (this.updateTime < 0L) {
            if (log.isDebugEnabled()) {
                log.debug("ZONE:  --- pending:" + id);
            }
            this.pendingRemoval.add(id);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("ZONE:  --- leaving zone:" + id);
            }
            this.index.remove(id);
            range.leave(id);
        }
    }

    protected Zone getZone(ZoneKey key, boolean create) {
        Zone result = this.zones.get(key);
        if (result == null && create) {
            result = new Zone(key, this.historyBacklog);
            if (this.updateTime >= 0L) {
                result.beginUpdate(this.updateTime);
            }
            this.zones.put(key, result);
        }
        return result;
    }

    protected void updateZoneObject(Long parent, Long id, Vec3d p, Quatd orientation, ZoneKey key) {
        Zone zone = this.getZone(key, false);
        if (zone == null) {
            log.warn("Body is updating a zone that does not exist, id:" + id + ", zone:" + key);
            return;
        }
        zone.update(parent, id, p, orientation);
    }

    protected void objectWarped(Long parent, Long id, ZoneKey key) {
        Zone zone;
        if (log.isDebugEnabled()) {
            log.debug("objectWarped(" + parent + ", " + id + ", " + key + ")");
        }
        if ((zone = this.getZone(key, false)) == null) {
            log.warn("Body is updating a zone that does not exist, id:" + id + ", zone:" + key);
            return;
        }
        zone.warp(parent, id);
    }

    protected void enterZone(Long id, ZoneKey key) {
        if (log.isDebugEnabled()) {
            log.debug("ZONE: enter zone:" + id + "  " + key);
        }
        Zone zone = this.getZone(key, true);
        zone.addChild(id);
    }

    protected void leaveZone(Long id, ZoneKey key) {
        Zone zone;
        if (log.isDebugEnabled()) {
            log.debug("ZONE: leave zone:" + id + "  " + key);
        }
        if ((zone = this.getZone(key, false)) == null) {
            log.warn("Body is leaving zone that does not exist, id:" + id + ", zone:" + key);
            return;
        }
        zone.removeChild(id);
        if (zone.isEmpty()) {
            // empty if block
        }
    }

    public static void main(String ... args) {
        ZoneGrid grid = new ZoneGrid(32);
        ZoneManager zones = new ZoneManager(grid);
        zones.beginUpdate(12345L);
        zones.updateEntity(1L, true, new Vec3d(0.0, 0.0, 0.0), new Quatd(), new AaBBox(10.0));
        zones.updateEntity(1L, true, new Vec3d(16.0, 16.0, 0.0), new Quatd(), new AaBBox(10.0));
        zones.updateEntity(1L, true, new Vec3d(32.0, 16.0, 0.0), new Quatd(), new AaBBox(10.0));
        zones.updateEntity(1L, true, new Vec3d(48.0, 16.0, 0.0), new Quatd(), new AaBBox(10.0));
    }

    private ZoneKey createKey(int x, int y, int z) {
        return new ZoneKey(this.grid, x, y, z);
    }

    protected final class DynamicZoneRange
    implements ZoneRange {
        Long id;
        Long parent;
        Vec3i min;
        Vec3i max;
        ZoneKey[] keys = new ZoneKey[0];
        int keyCount;
        Vec3d lastPosition;
        Quatd lastOrientation;

        public DynamicZoneRange(Long id) {
            this.id = id;
        }

        @Override
        public Vec3i getMin() {
            return this.min;
        }

        @Override
        public Vec3i getMax() {
            return this.max;
        }

        private boolean contains(int x, int y, int z) {
            if (x < this.min.x || y < this.min.y || z < this.min.z) {
                return false;
            }
            return x <= this.max.x && y <= this.max.y && z <= this.max.z;
        }

        @Override
        public void sendUpdate(Vec3d p, Quatd orientation) {
            this.lastPosition = p;
            this.lastOrientation = orientation;
            for (int i = 0; i < this.keyCount; ++i) {
                ZoneManager.this.updateZoneObject(this.parent, this.id, p, orientation, this.keys[i]);
            }
        }

        @Override
        public void sendNoChange() {
            this.sendUpdate(this.lastPosition, this.lastOrientation);
        }

        @Override
        public boolean setRange(Vec3i newMin, Vec3i newMax) {
            ZoneKey[] oldKeys = (ZoneKey[])this.keys.clone();
            int oldKeyCount = this.keyCount;
            int xSize = newMax.x - newMin.x + 1;
            int ySize = newMax.y - newMin.y + 1;
            int zSize = newMax.z - newMin.z + 1;
            int size = xSize * ySize * zSize;
            if (oldKeys.length < size || oldKeys.length > size * 2) {
                this.keys = new ZoneKey[size];
            }
            this.keyCount = size;
            int index = 0;
            for (int i = 0; i < xSize; ++i) {
                for (int j = 0; j < ySize; ++j) {
                    for (int k = 0; k < zSize; ++k) {
                        this.keys[index] = ZoneManager.this.createKey(newMin.x + i, newMin.y + j, newMin.z + k);
                        ++index;
                    }
                }
            }
            if (this.min == null) {
                this.min = newMin;
                this.max = newMax;
                this.enter(this.id);
                return true;
            }
            this.enterMissing(this.id, newMin, newMax, this.keys, this.keyCount);
            Vec3i oldMin = this.min;
            Vec3i oldMax = this.max;
            this.min = newMin;
            this.max = newMax;
            this.leaveMissing(this.id, oldMin, oldMax, oldKeys, oldKeyCount);
            return true;
        }

        private void enter(Long id) {
            for (int i = 0; i < this.keyCount; ++i) {
                ZoneManager.this.enterZone(id, this.keys[i]);
            }
        }

        @Override
        public void leave(Long id) {
            if (log.isDebugEnabled()) {
                log.debug("DynamicZoneRange.leave(" + id + ")  keys:" + Arrays.asList(this.keys));
            }
            if (id.longValue() != this.id.longValue()) {
                log.warn("How would this ever happen: id:" + id + "  this.id:" + this.id);
            }
            for (int i = 0; i < this.keyCount; ++i) {
                ZoneManager.this.leaveZone(id, this.keys[i]);
            }
        }

        private void enterMissing(Long id, Vec3i minZone, Vec3i maxZone, ZoneKey[] zoneKeys, int count) {
            int entered = 0;
            for (int i = 0; i < count; ++i) {
                ZoneKey key = zoneKeys[i];
                if (this.contains(key.x, key.y, key.z)) continue;
                ZoneManager.this.enterZone(id, key);
                ++entered;
            }
            if (entered == count && log.isTraceEnabled()) {
                log.trace("Probable warp has occurred, all zones are new.");
            }
        }

        private void leaveMissing(Long id, Vec3i minZone, Vec3i maxZone, ZoneKey[] zoneKeys, int count) {
            ZoneKey key;
            int i;
            int left = 0;
            for (i = 0; i < count; ++i) {
                key = zoneKeys[i];
                if (this.contains(key.x, key.y, key.z)) continue;
                ZoneManager.this.leaveZone(id, key);
                ++left;
            }
            if (left == count) {
                if (log.isTraceEnabled()) {
                    log.trace("Probable warp has occurred, exited all old zones.");
                }
                for (i = 0; i < count; ++i) {
                    key = zoneKeys[i];
                    ZoneManager.this.objectWarped(this.parent, id, key);
                }
            }
        }

        @Override
        public void setParent(Long parent) {
            this.parent = parent;
        }

        @Override
        public Long getParent() {
            return this.parent;
        }

        public String toString() {
            return "DynamicZoneRange[" + this.id + ", " + this.min + ", " + this.max + "]";
        }
    }

    protected final class OctZoneRange
    implements ZoneRange {
        Long id;
        Long parent;
        Vec3i min;
        Vec3i max;
        ZoneKey[] keys = new ZoneKey[8];
        Vec3d lastPosition;
        Quatd lastOrientation;

        public OctZoneRange(Long id) {
            this.id = id;
        }

        @Override
        public Vec3i getMin() {
            return this.min;
        }

        @Override
        public Vec3i getMax() {
            return this.max;
        }

        private boolean contains(int x, int y, int z) {
            if (x < this.min.x || y < this.min.y || z < this.min.z) {
                return false;
            }
            return x <= this.max.x && y <= this.max.y && z <= this.max.z;
        }

        @Override
        public void sendUpdate(Vec3d p, Quatd orientation) {
            this.lastPosition = p;
            this.lastOrientation = orientation;
            if (this.keys[0] != null) {
                ZoneManager.this.updateZoneObject(this.parent, this.id, p, orientation, this.keys[0]);
            }
            if (this.keys[1] != null) {
                ZoneManager.this.updateZoneObject(this.parent, this.id, p, orientation, this.keys[1]);
            }
            if (this.keys[2] != null) {
                ZoneManager.this.updateZoneObject(this.parent, this.id, p, orientation, this.keys[2]);
            }
            if (this.keys[3] != null) {
                ZoneManager.this.updateZoneObject(this.parent, this.id, p, orientation, this.keys[3]);
            }
        }

        @Override
        public void sendNoChange() {
            this.sendUpdate(this.lastPosition, this.lastOrientation);
        }

        @Override
        public boolean setRange(Vec3i newMin, Vec3i newMax) {
            boolean result = true;
            if (newMax.x - newMin.x > 1 || newMax.y - newMin.y > 1 || newMax.z - newMin.z > 1) {
                log.error("OctZoneRange: Range too big:" + newMin + " -> " + newMax);
                result = false;
            }
            ZoneKey[] oldKeys = (ZoneKey[])this.keys.clone();
            this.keys[0] = ZoneManager.this.createKey(newMin.x, newMin.y, newMin.z);
            this.keys[1] = newMin.x != newMax.x ? ZoneManager.this.createKey(newMax.x, newMin.y, newMin.z) : null;
            this.keys[3] = newMin.z != newMax.z ? ZoneManager.this.createKey(newMin.x, newMin.y, newMax.z) : null;
            this.keys[2] = this.keys[1] != null && this.keys[3] != null ? ZoneManager.this.createKey(newMax.x, newMin.y, newMax.z) : null;
            if (newMin.y != newMax.y) {
                this.keys[4] = this.keys[0] == null ? null : ZoneManager.this.createKey(this.keys[0].x, newMax.y, this.keys[0].z);
                this.keys[5] = this.keys[1] == null ? null : ZoneManager.this.createKey(this.keys[1].x, newMax.y, this.keys[1].z);
                this.keys[6] = this.keys[2] == null ? null : ZoneManager.this.createKey(this.keys[2].x, newMax.y, this.keys[2].z);
                this.keys[7] = this.keys[3] == null ? null : ZoneManager.this.createKey(this.keys[3].x, newMax.y, this.keys[3].z);
            } else {
                this.keys[4] = null;
                this.keys[5] = null;
                this.keys[6] = null;
                this.keys[7] = null;
            }
            if (this.min == null) {
                this.min = newMin;
                this.max = newMax;
                this.enter(this.id);
                return result;
            }
            this.enterMissing(this.id, newMin, newMax, this.keys);
            Vec3i oldMin = this.min;
            Vec3i oldMax = this.max;
            this.min = newMin;
            this.max = newMax;
            this.leaveMissing(this.id, oldMin, oldMax, oldKeys);
            return result;
        }

        private void enter(Long id) {
            for (ZoneKey key : this.keys) {
                if (key == null) continue;
                ZoneManager.this.enterZone(id, key);
            }
        }

        @Override
        public void leave(Long id) {
            if (log.isDebugEnabled()) {
                log.debug("OctZoneRange.leave(" + id + ")  keys:" + Arrays.asList(this.keys));
            }
            for (ZoneKey key : this.keys) {
                if (key == null) continue;
                ZoneManager.this.leaveZone(id, key);
            }
        }

        private void enterMissing(Long id, Vec3i minZone, Vec3i maxZone, ZoneKey[] zoneKeys) {
            for (ZoneKey key : zoneKeys) {
                if (key == null || this.contains(key.x, key.y, key.z)) continue;
                ZoneManager.this.enterZone(id, key);
            }
        }

        private void leaveMissing(Long id, Vec3i minZone, Vec3i maxZone, ZoneKey[] zoneKeys) {
            for (ZoneKey key : zoneKeys) {
                if (key == null || this.contains(key.x, key.y, key.z)) continue;
                ZoneManager.this.leaveZone(id, key);
            }
        }

        @Override
        public void setParent(Long parent) {
            this.parent = parent;
        }

        @Override
        public Long getParent() {
            return this.parent;
        }
    }

    protected static interface ZoneRange {
        public Vec3i getMin();

        public Vec3i getMax();

        public boolean setRange(Vec3i var1, Vec3i var2);

        public void sendUpdate(Vec3d var1, Quatd var2);

        public void sendNoChange();

        public void leave(Long var1);

        public void setParent(Long var1);

        public Long getParent();
    }
}

