/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TGALoader
implements AssetLoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        boolean flip = ((TextureKey)info.getKey()).isFlipY();
        try (InputStream in = null;){
            Image img;
            in = info.openStream();
            Image image = img = TGALoader.load(in, flip);
            return image;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image load(InputStream in, boolean flip) throws IOException {
        int i;
        Image.Format format;
        byte blue;
        byte green;
        byte red;
        int dl;
        boolean flipH = false;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        int idLength = dis.readUnsignedByte();
        int colorMapType = dis.readUnsignedByte();
        int imageType = dis.readUnsignedByte();
        dis.readShort();
        int cMapLength = TGALoader.flipEndian(dis.readShort());
        int cMapDepth = dis.readUnsignedByte();
        dis.readShort();
        dis.readShort();
        int width = TGALoader.flipEndian(dis.readShort());
        int height = TGALoader.flipEndian(dis.readShort());
        int pixelDepth = dis.readUnsignedByte();
        int imageDescriptor = dis.readUnsignedByte();
        if ((imageDescriptor & 0x20) != 0) {
            boolean bl = flip = !flip;
        }
        if ((imageDescriptor & 0x10) != 0) {
            boolean bl = flipH = !flipH;
        }
        if (idLength > 0) {
            dis.skip(idLength);
        }
        ColorMapEntry[] cMapEntries = null;
        if (colorMapType != 0) {
            int bytesInColorMap = cMapDepth * cMapLength >> 3;
            int bitsPerColor = Math.min(cMapDepth / 3, 8);
            byte[] cMapData = new byte[bytesInColorMap];
            dis.read(cMapData);
            if (imageType == 1 || imageType == 9) {
                cMapEntries = new ColorMapEntry[cMapLength];
                int alphaSize = cMapDepth - 3 * bitsPerColor;
                float scalar = 255.0f / (FastMath.pow(2.0f, bitsPerColor) - 1.0f);
                float alphaScalar = 255.0f / (FastMath.pow(2.0f, alphaSize) - 1.0f);
                for (int i2 = 0; i2 < cMapLength; ++i2) {
                    ColorMapEntry entry = new ColorMapEntry();
                    int offset = cMapDepth * i2;
                    entry.red = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset, bitsPerColor) * scalar);
                    entry.green = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset + bitsPerColor, bitsPerColor) * scalar);
                    entry.blue = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset + 2 * bitsPerColor, bitsPerColor) * scalar);
                    entry.alpha = alphaSize <= 0 ? (byte)-1 : (byte)((float)TGALoader.getBitsAsByte(cMapData, offset + 3 * bitsPerColor, alphaSize) * alphaScalar);
                    cMapEntries[i2] = entry;
                }
            }
        }
        byte[] rawData = null;
        if (pixelDepth == 32) {
            rawData = new byte[width * height * 4];
            dl = 4;
        } else {
            rawData = new byte[width * height * 3];
            dl = 3;
        }
        int rawDataIndex = 0;
        if (imageType == 2) {
            red = 0;
            green = 0;
            blue = 0;
            int alpha = 0;
            if (pixelDepth == 16) {
                byte[] data = new byte[2];
                float scalar = 8.225806f;
                for (int i3 = 0; i3 <= height - 1; ++i3) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i3) * width * dl;
                    }
                    for (int j = 0; j < width; ++j) {
                        data[1] = dis.readByte();
                        data[0] = dis.readByte();
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data, 1, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data, 6, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data, 11, 5) * scalar);
                        if (dl != 4) continue;
                        alpha = TGALoader.getBitsAsByte(data, 0, 1);
                        if (alpha == 1) {
                            alpha = -1;
                        }
                        rawData[rawDataIndex++] = alpha;
                    }
                }
                format = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
            } else if (pixelDepth == 24) {
                for (int y = 0; y < height; ++y) {
                    rawDataIndex = !flip ? (height - 1 - y) * width * dl : y * width * dl;
                    dis.readFully(rawData, rawDataIndex, width * dl);
                }
                format = Image.Format.BGR8;
            } else {
                if (pixelDepth != 32) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j = 0; j < width; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        rawData[rawDataIndex++] = alpha;
                    }
                }
                format = Image.Format.RGBA8;
            }
        } else if (imageType == 10) {
            red = 0;
            green = 0;
            blue = 0;
            byte alpha = 0;
            if (pixelDepth == 32) {
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j = 0; j < width; ++j) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = alpha;
                            }
                            continue;
                        }
                        j += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = alpha;
                        }
                    }
                }
                format = Image.Format.RGBA8;
            } else if (pixelDepth == 24) {
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j = 0; j < width; ++j) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                            }
                            continue;
                        }
                        j += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                        }
                    }
                }
                format = Image.Format.RGB8;
            } else {
                if (pixelDepth != 16) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                byte[] data = new byte[2];
                float scalar = 8.225806f;
                for (int i4 = 0; i4 <= height - 1; ++i4) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i4) * width * dl;
                    }
                    for (int j = 0; j < width; ++j) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j += (count &= 0x7F);
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)TGALoader.getBitsAsByte(data, 1, 5) * scalar);
                            green = (byte)((float)TGALoader.getBitsAsByte(data, 6, 5) * scalar);
                            red = (byte)((float)TGALoader.getBitsAsByte(data, 11, 5) * scalar);
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                            }
                            continue;
                        }
                        j += count;
                        while (count-- >= 0) {
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)TGALoader.getBitsAsByte(data, 1, 5) * scalar);
                            green = (byte)((float)TGALoader.getBitsAsByte(data, 6, 5) * scalar);
                            red = (byte)((float)TGALoader.getBitsAsByte(data, 11, 5) * scalar);
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                        }
                    }
                }
                format = Image.Format.RGB8;
            }
        } else {
            int j;
            int i5;
            if (imageType != 1) throw new IOException("Monochrome and RLE colormapped images are not supported");
            int bytesPerIndex = pixelDepth / 8;
            if (bytesPerIndex == 1) {
                for (i5 = 0; i5 <= height - 1; ++i5) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i5) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        int index = dis.readUnsignedByte();
                        if (index >= cMapEntries.length || index < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index);
                        }
                        ColorMapEntry entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.red;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            } else {
                if (bytesPerIndex != 2) throw new IOException("TGA: unknown colormap indexing size used: " + bytesPerIndex);
                for (i5 = 0; i5 <= height - 1; ++i5) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i5) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        short index = TGALoader.flipEndian(dis.readShort());
                        if (index >= cMapEntries.length || index < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index);
                        }
                        ColorMapEntry entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.red;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            }
            format = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
        }
        in.close();
        ByteBuffer scratch = BufferUtils.createByteBuffer(rawData.length);
        scratch.clear();
        scratch.put(rawData);
        scratch.rewind();
        Image textureImage = new Image();
        textureImage.setFormat(format);
        textureImage.setWidth(width);
        textureImage.setHeight(height);
        textureImage.setData(scratch);
        return textureImage;
    }

    private static byte getBitsAsByte(byte[] data, int offset, int length) {
        int offsetBytes = offset / 8;
        int indexBits = offset % 8;
        int rVal = 0;
        int i = length;
        while (--i >= 0) {
            int test;
            byte b = data[offsetBytes];
            int n = test = indexBits == 7 ? 1 : 2 << 6 - indexBits;
            if ((b & test) != 0) {
                rVal = i == 0 ? ++rVal : (rVal += 2 << i - 1);
            }
            if (++indexBits != 8) continue;
            indexBits = 0;
            ++offsetBytes;
        }
        return (byte)rVal;
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }
}

