

fixClaimAreaZones = {
    entityData.findEntities(null, ClaimArea).each {
        def area = it[ClaimArea];
        if( area.zoneId == 0 ) {
            log.info("Fixing:" + it + " area:" + area);
            area = area.changeDepth(area.depth);
            it << area;
        }
        entityData.removeComponent(it, LargeGridCell.class);
    }
}

def versionKey = "claimAreas.data.version";
def version = worldManager.worldEntity.vars.loadInt(versionKey, -1);
def latestVersion = 1;

log.info(versionKey + ":" + version);
if( version < 1 ) {
    log.info("Need to fix ClaimArea zones.");
    fixClaimAreaZones();
}

if( version < latestVersion ) {
    // Mark it as upgraded
    log.info("Setting " + versionKey + " to:" + latestVersion);
    worldManager.worldEntity.vars.storeInt(versionKey, latestVersion);
}




