/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import mythruna.GameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimArea
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ClaimArea.class);
    private static final Grid ZONE_GRID = GameConstants.LARGE_OBJECT_GRID;
    private Vec3i min;
    private Vec3i max;
    private short depth;
    private short height;
    private long zoneId;

    private ClaimArea() {
    }

    public ClaimArea(Vec3i min, Vec3i max) {
        this(min, max, -1, -1);
    }

    public ClaimArea(Vec3i min, Vec3i max, int depth, int height) {
        this.min = new Vec3i(Math.min(min.x, max.x), Math.min(min.y, max.y), Math.min(min.z, max.z));
        this.max = new Vec3i(Math.max(min.x, max.x), Math.max(min.y, max.y), Math.max(min.z, max.z));
        this.depth = (short)depth;
        this.height = (short)height;
        int xMid = min.x + (max.x - min.x) / 2;
        int zMid = min.z + (max.z - min.z) / 2;
        this.zoneId = ZONE_GRID.worldToId((double)xMid, (double)min.y, (double)zMid);
    }

    public static long calculateZoneId(Vec3d loc) {
        return ZONE_GRID.worldToId(loc);
    }

    public static Grid getZoneGrid() {
        return ZONE_GRID;
    }

    public static long calculateZoneId(Vec3i loc) {
        return ZONE_GRID.worldToId((double)loc.x, (double)loc.y, (double)loc.z);
    }

    public static long calculateZoneId(double x, double y, double z) {
        return ZONE_GRID.worldToId(x, y, z);
    }

    public static ComponentFilter<ClaimArea> zoneFilter(long zoneId) {
        return Filters.fieldEquals(ClaimArea.class, (String)"zoneId", (Object)zoneId);
    }

    public ClaimArea changeBounds(Vec3i min, Vec3i max) {
        return new ClaimArea(min, max, this.depth, this.height);
    }

    public ClaimArea moveCorner(Vec3i from, Vec3i to) {
        Vec3i newMin = this.min.clone();
        Vec3i newMax = this.max.clone();
        if (newMin.x == from.x) {
            newMin.x = to.x;
        }
        if (newMin.z == from.z) {
            newMin.z = to.z;
        }
        if (newMax.x == from.x) {
            newMax.x = to.x;
        }
        if (newMax.z == from.z) {
            newMax.z = to.z;
        }
        return new ClaimArea(newMin, newMax, this.depth, this.height);
    }

    public ClaimArea changeDepth(int depth) {
        return new ClaimArea(this.min, this.max, depth, this.height);
    }

    public ClaimArea changeHeight(int height) {
        return new ClaimArea(this.min, this.max, this.depth, height);
    }

    public boolean contains(Vec3i loc) {
        if (log.isDebugEnabled()) {
            log.debug("contains(" + loc + ") min:" + this.min + "  max:" + this.max);
        }
        if (loc.x < this.min.x || loc.z < this.min.z) {
            return false;
        }
        return loc.x <= this.max.x && loc.z <= this.max.z;
    }

    public boolean contains(Vec3d loc) {
        return this.contains(loc.floor());
    }

    public boolean intersects(ClaimArea area) {
        if (area == null) {
            return false;
        }
        if (area.max.x < this.min.x) {
            return false;
        }
        if (area.max.z < this.min.z) {
            return false;
        }
        if (area.min.x > this.max.x) {
            return false;
        }
        return area.min.z <= this.max.z;
    }

    public int getSizeX() {
        return this.max.x - this.min.x;
    }

    public int getSizeZ() {
        return this.max.z - this.min.z;
    }

    public int getArea() {
        return this.getSizeX() * this.getSizeZ();
    }

    public Vec3i getMin() {
        return this.min;
    }

    public Vec3i getMax() {
        return this.max;
    }

    public short getDepth() {
        return this.depth;
    }

    public short getHeight() {
        return this.height;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("min", (Object)this.min).add("max", (Object)this.max).add("depth", (int)this.depth).add("height", (int)this.height).add("zoneId", this.zoneId).toString();
    }
}

