/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.es.StringType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ClothingInfo.class);
    @IndexedField
    private EntityId parent;
    @StringType(maxLength=40)
    private String name;
    private long lastModified;

    public ClothingInfo() {
    }

    public ClothingInfo(EntityId parent, String name) {
        this(parent, name, System.currentTimeMillis());
    }

    public ClothingInfo(EntityId parent, String name, long lastModified) {
        this.parent = parent;
        this.name = name;
        this.lastModified = lastModified;
    }

    public ClothingInfo changeName(String name) {
        return new ClothingInfo(this.parent, name);
    }

    public ClothingInfo changeParent(EntityId parent) {
        return new ClothingInfo(parent, this.name);
    }

    public ClothingInfo changeLastModified() {
        return new ClothingInfo(this.parent, this.name);
    }

    public EntityId getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ClothingInfo other = (ClothingInfo)o;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return other.lastModified == this.lastModified;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.lastModified);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("parent", (Object)this.parent).add("name", (Object)this.name).add("lastModified", this.lastModified).toString();
    }
}

