/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.FilteredSignalHandler;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;
import mythruna.sim.ai.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSignalHandler<T>
implements SignalHandler<T> {
    static Logger log = LoggerFactory.getLogger(CompositeSignalHandler.class);
    private List<SignalHandler<T>> delegates = new ArrayList<SignalHandler<T>>();

    public void addDelegate(SignalHandler<T> handler) {
        this.delegates.add(handler);
    }

    public void addDelegate(String type, SignalHandler<T> handler) {
        this.delegates.add(new FilteredSignalHandler<T>(type, handler));
    }

    public void addDelegate(Class<Signal<T>> signalClass, String type, SignalHandler<T> handler) {
        this.delegates.add(new FilteredSignalHandler<T>(signalClass, type, handler));
    }

    public void removeDelegate(SignalHandler<T> handler) {
        if (this.delegates.remove(handler)) {
            return;
        }
        for (int i = 0; i < this.delegates.size(); ++i) {
            SignalHandler<T> check = this.delegates.get(i);
            if (!(check instanceof FilteredSignalHandler) || ((FilteredSignalHandler)check).getDelegate() != handler) continue;
            this.delegates.remove(i);
            return;
        }
    }

    public List<SignalHandler<T>> getDelegates() {
        return this.delegates;
    }

    @Override
    public Reaction generateReaction(Brain brain, Signal<? extends T> signal) {
        for (SignalHandler<? extends T> signalHandler : this.delegates) {
            Reaction reaction = signalHandler.generateReaction(brain, signal);
            if (reaction == null) continue;
            return reaction;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegates", this.delegates).toString();
    }
}

