/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import mythruna.world.TerrainTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopBlockType {
    static Logger log = LoggerFactory.getLogger(TopBlockType.class);
    public static final int TYPE_SAND = 0;
    public static final int TYPE_DIRT = 1;
    public static final int TYPE_GRASS = 2;
    public static final int TYPE_DRY_GRASS = 3;
    public static final int TYPE_STONE1 = 4;
    public static final int TYPE_STONE2 = 5;
    public static final int TYPE_STONE3 = 6;
    public static final int TYPE_STONE4 = 7;
    public static final int TYPE_STONE5 = 8;
    public static final int TYPE_ICE = 9;
    public int type;
    public int baseType;
    public int foliage;
    public int wetness;
    public boolean snow;

    public void configure(int elevation, int terrainType, int fluidLevel, int fluidType) {
        this.baseType = TerrainTypes.getBaseType(terrainType);
        this.foliage = TerrainTypes.getFoliageLevel(terrainType);
        this.wetness = TerrainTypes.getWetnessLevel(terrainType);
        this.snow = this.wetness == 0 ? false : TerrainTypes.isFrozen(terrainType);
        switch (this.baseType) {
            case 0: {
                this.type = 0;
                break;
            }
            case 1: {
                if (this.foliage == 0) {
                    this.type = 1;
                    break;
                }
                if (this.wetness < 1) {
                    this.type = 3;
                    break;
                }
                this.type = 2;
                break;
            }
            case 7: {
                this.type = 9;
                break;
            }
            case 2: {
                this.type = 4;
                break;
            }
            case 3: {
                this.type = 5;
                break;
            }
            case 4: {
                this.type = 6;
                break;
            }
            case 5: {
                this.type = 7;
                break;
            }
            default: {
                this.type = 8;
            }
        }
    }
}

