/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mathd.Vec3i;
import mythruna.world.BioInfo;
import mythruna.world.WorldFractal;
import mythruna.world.tile.MegatileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MegatileData {
    static Logger log = LoggerFactory.getLogger(MegatileData.class);
    public static final int METERS = 327680;
    public static final int SIZE = 2560;
    public static final int SPREAD = 128;
    private static final long serialVersionUID = 42L;
    private MegatileId id;
    private Vec3i origin;
    private short[] elevation = new short[0x640000];
    private int[] metaData = new int[this.elevation.length];

    public MegatileData(MegatileId id) {
        this.id = id;
        this.origin = id.getWorld(null);
    }

    public int getSize() {
        return 2560;
    }

    public int getSpread() {
        return 128;
    }

    public short getElevation(int x, int z) {
        int index = this.index(x, z);
        return this.elevation[index];
    }

    public int getMetaData(int x, int z) {
        int index = this.index(x, z);
        return this.metaData[index];
    }

    public double getTemperature(int metaData) {
        return (double)(metaData >> 24 & 0xFF) / 255.0;
    }

    public double getPrecipitation(int metaData) {
        return (double)(metaData >> 16 & 0xFF) / 255.0;
    }

    public double getSoilQuality(int metaData) {
        return (double)(metaData >> 8 & 0xFF) / 255.0;
    }

    public double getVegetationLevel(int metaData) {
        return (double)(metaData & 0xFF) / 255.0;
    }

    public static int toMetaData(BioInfo info) {
        return MegatileData.toMetaData(info.temperature, info.precipitation, info.soilQuality, info.vegetationLevel);
    }

    public static int toMetaData(double temperature, double precipitation, double soil, double vegetation) {
        int v;
        int s;
        int p;
        int t = (int)(temperature * 255.0);
        if (t < 0) {
            t = 0;
        }
        if ((p = (int)(precipitation * 255.0)) < 0) {
            p = 0;
        }
        if ((s = (int)(soil * 255.0)) < 0) {
            s = 0;
        }
        if ((v = (int)(vegetation * 255.0)) < 0) {
            v = 0;
        }
        int result = t & 0xFF;
        result = result << 8 | p & 0xFF;
        result = result << 8 | s & 0xFF;
        result = result << 8 | v & 0xFF;
        return result;
    }

    private int index(int x, int z) {
        return z * 2560 + x;
    }

    public void initialize(WorldFractal fractal) {
        BioInfo info = new BioInfo();
        for (int i = 0; i < 2560; ++i) {
            for (int j = 0; j < 2560; ++j) {
                double x = this.origin.x + i * 128;
                double z = this.origin.z + j * 128;
                double y = fractal.getElevation(x, z);
                fractal.getBioInfo(x, y, z, info);
                int index = this.index(i, j);
                this.elevation[index] = (short)y;
                this.metaData[index] = MegatileData.toMetaData(info);
            }
        }
    }
}

