/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MegatileId
implements GridBasedId,
Serializable {
    static Logger log = LoggerFactory.getLogger(MegatileId.class);
    public static final int SIZE = 327680;
    public static final Grid MEGATILE_GRID;
    public static final Grid GRID;
    public static final int OFFSET = 163840;
    private static final long serialVersionUID = 42L;
    private long id;

    public MegatileId(long id) {
        this.id = id;
    }

    public static MegatileId fromWorld(Vec3i world) {
        return MegatileId.fromWorld(world.x, world.y, world.z);
    }

    public static MegatileId fromWorld(Vec3d world) {
        return MegatileId.fromWorld(world.x, world.y, world.z);
    }

    public static MegatileId fromWorld(double x, double y, double z) {
        long id = GRID.worldToId(x + 163840.0, y, z + 163840.0);
        return new MegatileId(id);
    }

    public static MegatileId fromWorld(int x, int y, int z) {
        long id = GRID.worldToId((double)(x + 163840), (double)y, (double)(z + 163840));
        return new MegatileId(id);
    }

    public static MegatileId fromCell(int xCell, int zCell) {
        long id = GRID.cellToId(xCell, 0, zCell);
        return new MegatileId(id);
    }

    public long getId() {
        return this.id;
    }

    public Vec3i getWorld(Vec3i store) {
        Vec3i loc = GRID.idToCell(this.id, store);
        loc = GRID.cellToWorld(loc, loc);
        loc.addLocal(-163840, 0, -163840);
        return loc;
    }

    public Vec3i getCell(Vec3i store) {
        return GRID.idToCell(this.id, store);
    }

    public GridCell getGridCell() {
        return this.getGrid().getContainingCell(this.getWorld(null));
    }

    public Grid getGrid() {
        return GRID;
    }

    public Grid getParentGrid() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        MegatileId other = (MegatileId)o;
        return other.id == this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }

    static {
        GRID = MEGATILE_GRID = new Grid(327680, 1024, 327680);
    }
}

