@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  Mythruna-server-java8 startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and MYTHRUNA_SERVER_JAVA8_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-ea" "-Xmx3g" "-Xms512m" "-XX:MaxDirectMemorySize=3g"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\server-1.0.0.jar;%APP_HOME%\lib\core-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\fractal-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\crig-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\bpos-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\sio2-mblock-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\sio2-mphys-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\blockset-1.0.0.jar;%APP_HOME%\lib\modelset-1.0.0.jar;%APP_HOME%\lib\mblock-physb-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mworld-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mmod-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\groovy-ext-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\sio2-1.9.0-SNAPSHOT.jar;%APP_HOME%\lib\zay-es-net-1.7.0-SNAPSHOT.jar;%APP_HOME%\lib\zay-es-1.7.0-SNAPSHOT.jar;%APP_HOME%\lib\mphys-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mblock-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\action-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\maccount-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\io-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\mprogress-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\namegen-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\namesets-1.0.0-SNAPSHOT.jar;%APP_HOME%\lib\lemur-1.17.0-SNAPSHOT.jar;%APP_HOME%\lib\guava-21.0.jar;%APP_HOME%\lib\sim-ethereal-1.8.1-SNAPSHOT.jar;%APP_HOME%\lib\sim-math-1.6.1-SNAPSHOT.jar;%APP_HOME%\lib\log4j-slf4j-impl-2.17.1.jar;%APP_HOME%\lib\slf4j-api-1.7.36.jar;%APP_HOME%\lib\jme3-networking-3.6.0-SNAPSHOT.jar;%APP_HOME%\lib\groovy-all-2.4.11.jar;%APP_HOME%\lib\gson-2.13.1.jar;%APP_HOME%\lib\log4j-core-2.17.1.jar;%APP_HOME%\lib\log4j-api-2.17.1.jar;%APP_HOME%\lib\hsqldb-2.5.1.jar;%APP_HOME%\lib\jme3-core-3.6.0-SNAPSHOT.jar;%APP_HOME%\lib\error_prone_annotations-2.38.0.jar


@rem Execute Mythruna-server-java8
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %MYTHRUNA_SERVER_JAVA8_OPTS%  -classpath "%CLASSPATH%" mythruna.server.ServerLauncher %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable MYTHRUNA_SERVER_JAVA8_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%MYTHRUNA_SERVER_JAVA8_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
