/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CachedUrlStream
implements PhysicalOggStream {
    private boolean closed = false;
    private URLConnection source;
    private InputStream sourceStream;
    private Object drainLock = new Object();
    private RandomAccessFile drain;
    private byte[] memoryCache;
    private ArrayList pageOffsets = new ArrayList();
    private ArrayList pageLengths = new ArrayList();
    private long numberOfSamples = -1L;
    private long cacheLength;
    private HashMap logicalStreams = new HashMap();
    private LoaderThread loaderThread;

    public CachedUrlStream(URL source) throws OggFormatException, IOException {
        this(source, null);
    }

    public CachedUrlStream(URL source, RandomAccessFile drain) throws OggFormatException, IOException {
        this.source = source.openConnection();
        if (drain == null) {
            int contentLength = this.source.getContentLength();
            if (contentLength == -1) {
                throw new IOException("The URLConncetion's content length must be set when operating with a in-memory cache.");
            }
            this.memoryCache = new byte[contentLength];
        }
        this.drain = drain;
        this.sourceStream = this.source.getInputStream();
        this.loaderThread = new LoaderThread(this.sourceStream, drain, this.memoryCache);
        new Thread(this.loaderThread).start();
        while (!this.loaderThread.isBosDone() || this.pageOffsets.size() < 20) {
            System.out.print("pageOffsets.size(): " + this.pageOffsets.size() + "\r");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
        System.out.println("caching " + this.pageOffsets.size() + "/20 pages\r");
    }

    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    public long getCacheLength() {
        return this.cacheLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OggPage getOggPage(int index) throws IOException {
        Object object = this.drainLock;
        synchronized (object) {
            Long offset = (Long)this.pageOffsets.get(index);
            Long length = (Long)this.pageLengths.get(index);
            if (offset != null) {
                if (this.drain != null) {
                    this.drain.seek(offset);
                    return OggPage.create(this.drain);
                }
                byte[] tmpArray = new byte[length.intValue()];
                System.arraycopy(this.memoryCache, offset.intValue(), tmpArray, 0, length.intValue());
                return OggPage.create(tmpArray);
            }
            return null;
        }
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return (LogicalOggStream)this.logicalStreams.get(new Integer(serialNumber));
    }

    public void setTime(long granulePosition) throws IOException {
        Iterator iter = this.logicalStreams.values().iterator();
        while (iter.hasNext()) {
            LogicalOggStream los = (LogicalOggStream)iter.next();
            los.setTime(granulePosition);
        }
    }

    public boolean isSeekable() {
        return true;
    }

    public class LoaderThread
    implements Runnable {
        private InputStream source;
        private RandomAccessFile drain;
        private byte[] memoryCache;
        private boolean bosDone = false;
        private int pageNumber;

        public LoaderThread(InputStream source, RandomAccessFile drain, byte[] memoryCache) {
            this.source = source;
            this.drain = drain;
            this.memoryCache = memoryCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean eos = false;
                byte[] buffer = new byte[8192];
                while (!eos) {
                    LogicalOggStreamImpl los;
                    OggPage op = OggPage.create(this.source);
                    Object object = CachedUrlStream.this.drainLock;
                    synchronized (object) {
                        int listSize = CachedUrlStream.this.pageOffsets.size();
                        long pos = listSize > 0 ? (Long)CachedUrlStream.this.pageOffsets.get(listSize - 1) + (Long)CachedUrlStream.this.pageLengths.get(listSize - 1) : 0L;
                        byte[] arr1 = op.getHeader();
                        byte[] arr2 = op.getSegmentTable();
                        byte[] arr3 = op.getData();
                        if (this.drain != null) {
                            this.drain.seek(pos);
                            this.drain.write(arr1);
                            this.drain.write(arr2);
                            this.drain.write(arr3);
                        } else {
                            System.arraycopy(arr1, 0, this.memoryCache, (int)pos, arr1.length);
                            System.arraycopy(arr2, 0, this.memoryCache, (int)pos + arr1.length, arr2.length);
                            System.arraycopy(arr3, 0, this.memoryCache, (int)pos + arr1.length + arr2.length, arr3.length);
                        }
                        CachedUrlStream.this.pageOffsets.add(new Long(pos));
                        CachedUrlStream.this.pageLengths.add(new Long(arr1.length + arr2.length + arr3.length));
                    }
                    if (!op.isBos()) {
                        this.bosDone = true;
                    }
                    if (op.isEos()) {
                        eos = true;
                    }
                    if ((los = (LogicalOggStreamImpl)CachedUrlStream.this.getLogicalStream(op.getStreamSerialNumber())) == null) {
                        los = new LogicalOggStreamImpl(CachedUrlStream.this, op.getStreamSerialNumber());
                        CachedUrlStream.this.logicalStreams.put(new Integer(op.getStreamSerialNumber()), los);
                        los.checkFormat(op);
                    }
                    los.addPageNumberMapping(this.pageNumber);
                    los.addGranulePosition(op.getAbsoluteGranulePosition());
                    ++this.pageNumber;
                    CachedUrlStream.this.cacheLength = op.getAbsoluteGranulePosition();
                }
            }
            catch (EndOfOggStreamException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isBosDone() {
            return this.bosDone;
        }
    }
}

