/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.crig.RigShape;
import com.simsilica.crig.sim.AnimPump;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockContact;
import mythruna.sim.Activity;
import mythruna.sim.SwingMotion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingDownActivity
implements Activity {
    static Logger log = LoggerFactory.getLogger(SwingDownActivity.class);
    private RigShape rigShape;
    private AnimPump animPump;
    private double speed = 1.0;
    private double kinematicScale = 0.0;
    private SwingMotion motion;
    private boolean blocked;

    public SwingDownActivity(RigShape rigShape, AnimPump animPump) {
        this.rigShape = rigShape;
        this.animPump = animPump;
        this.motion = new SwingMotion(0.1, 0.2, 0.4, 0.1);
    }

    @Override
    public double getKinematicScale() {
        return this.kinematicScale;
    }

    @Override
    public void reset() {
        this.motion.reset();
        this.blocked = false;
    }

    @Override
    public void newContact(MBlockContact<EntityId> contact, int type1, int type2, Vec3d kVelocity) {
        this.blocked = true;
    }

    @Override
    public void update(long frameTime, double step, Vec3d view) {
        if (this.blocked) {
            this.motion.blocked();
            this.blocked = false;
        }
        this.motion.update(step * this.speed);
        double y = this.motion.getSwingTime();
        this.kinematicScale = this.motion.getStrength();
        this.animPump.setCurrentAction("SwingDownRightShoulder", 0.0);
        this.animPump.setTime(y);
        this.rigShape.update();
    }
}

