/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3i;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import mythruna.world.local.BasisData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBasisData<K, V>
implements BasisData<V> {
    static Logger log = LoggerFactory.getLogger(AbstractBasisData.class);
    private AtomicReference<K> keyRef = new AtomicReference();
    private AtomicReference<V> dataRef = new AtomicReference();
    private AtomicLong version = new AtomicLong();

    protected AbstractBasisData() {
    }

    public K getKey() {
        return this.keyRef.get();
    }

    protected abstract K positionToKey(Vec3i var1);

    protected abstract V loadData(K var1);

    @Override
    public boolean updatePosition(Vec3i pos) {
        K newKey = this.positionToKey(pos);
        if (Objects.equals(newKey, this.keyRef.get())) {
            return false;
        }
        this.invalidate(newKey);
        return true;
    }

    @Override
    public boolean isInvalid() {
        return this.dataRef.get() == null;
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public V getData() {
        return this.dataRef.get();
    }

    protected synchronized void invalidate(K key) {
        this.keyRef.set(key);
        this.dataRef.set(null);
    }

    protected synchronized void validate(K key, V data) {
        if (!Objects.equals(key, this.keyRef.get())) {
            return;
        }
        this.dataRef.set(data);
        this.version.incrementAndGet();
    }

    @Override
    public void reload() {
        K key = this.keyRef.get();
        this.validate(key, this.loadData(key));
    }
}

