/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mythruna.client.character.CharacterDecorator;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(ColorDecorator.class);
    private String type;
    private String targetMaterial;
    private Spatial spatial;
    private List<Material> affectedMaterials = new ArrayList<Material>();
    private ShapeName colorName;
    private volatile boolean needsApply;

    public ColorDecorator(String type, String targetMaterial) {
        this.type = type;
        this.targetMaterial = targetMaterial;
    }

    @Override
    public void setSpatial(Spatial spatial) {
        if (this.spatial == spatial) {
            return;
        }
        this.spatial = spatial;
        this.affectedMaterials.clear();
        spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                String matDefName = mat.getMaterialDef().getAssetName();
                String matName = mat.getName();
                if (!ColorDecorator.this.targetMaterial.equals(matName)) {
                    return;
                }
                ColorDecorator.this.affectedMaterials.add(mat);
            }
        });
        this.needsApply = true;
    }

    @Override
    public void setShapeName(ShapeName name) {
        this.setColorName(this.find(this.type, name));
    }

    protected void setColorName(ShapeName colorName) {
        if (Objects.equals(this.colorName, colorName)) {
            return;
        }
        this.colorName = colorName;
        this.needsApply = true;
    }

    @Override
    public boolean apply() {
        if (!this.needsApply) {
            return false;
        }
        if (this.colorName == null) {
            return false;
        }
        int colorArgb = (int)Long.parseUnsignedLong(this.colorName.getName(), 16);
        ColorRGBA color = new ColorRGBA().fromIntARGB(colorArgb |= 0xFF000000);
        for (Material mat : this.affectedMaterials) {
            mat.setColor("Diffuse", color);
            mat.setColor("Ambient", color);
        }
        this.needsApply = false;
        return true;
    }

    protected ShapeName find(String type, ShapeName name) {
        if (type.equals(name.getType())) {
            return name;
        }
        for (ShapeName sub : name.getAddOns()) {
            if (!type.equals(sub.getType())) continue;
            return sub;
        }
        return null;
    }
}

