/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrassBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(GrassBlockFactory.class);
    private float[][] texOffsets = new float[][]{{0.0f, 0.235f}, {0.25f, 0.485f}, {0.5f, 0.735f}, {0.75f, 0.985f}};
    private MaterialType mt1;
    private float height;
    private Vec3d min;
    private Vec3d max;

    public GrassBlockFactory(MaterialType mt1, double height) {
        this.mt1 = mt1;
        this.height = (float)height;
        this.min = new Vec3d(0.0, 0.0, 0.0);
        this.max = new Vec3d(1.0, height * 0.5, 1.0);
    }

    protected float perturb(GeomPartBuffer buffer) {
        return (float)(buffer.nextRandom() * 0.3) - 0.15f;
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        float width = 1.2f;
        float innerOffset = width * 11.0f / 15.0f - 0.5f;
        float outerOffset = width * 0.5f;
        int texIndex = (xWorld % 4 + yWorld % 3) % 4;
        float xCenter = 0.5f;
        float zCenter = 0.5f;
        float yBase = 0.0f;
        GeomPart part = new GeomPart(this.mt1, Direction.Up.ordinal(), true);
        part.setCoords(new float[]{xCenter - innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter + outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter + outerOffset, this.height, zCenter + innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), this.height, zCenter - outerOffset});
        part.setTexCoords(new float[]{0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        buffer.addPart(i, j, k, part);
        part = new GeomPart(this.mt1, Direction.Up.ordinal(), true);
        part.setCoords(new float[]{xCenter + innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter - outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter - outerOffset, this.height, zCenter + innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), this.height, zCenter - outerOffset});
        part.setTexCoords(new float[]{0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        buffer.addPart(i, j, k, part);
        part = new GeomPart(this.mt1, Direction.Up.ordinal(), true);
        part.setCoords(new float[]{xCenter - outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter + innerOffset + this.perturb(buffer), this.height, zCenter + outerOffset, xCenter - outerOffset, this.height, zCenter - innerOffset + this.perturb(buffer)});
        part.setTexCoords(new float[]{0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        buffer.addPart(i, j, k, part);
        part = new GeomPart(this.mt1, Direction.Up.ordinal(), true);
        part.setCoords(new float[]{xCenter + outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter - innerOffset + this.perturb(buffer), this.height, zCenter + outerOffset, xCenter + outerOffset, this.height, zCenter - innerOffset + this.perturb(buffer)});
        part.setTexCoords(new float[]{0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]});
        part.setIndexes(new int[]{0, 1, 2, 0, 2, 3});
        buffer.addPart(i, j, k, part);
        return 4;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 1.0;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return this.min;
    }

    public Vec3d getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GrassBlockFactory other = (GrassBlockFactory)o;
        if (!Objects.equals(other.mt1, this.mt1)) {
            return false;
        }
        return other.height == this.height;
    }

    public int hashCode() {
        return Objects.hash(this.mt1, Float.valueOf(this.height));
    }

    public BlockFactory rotate(int dirDelta) {
        return this;
    }
}

