/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.service;

import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Server;
import com.jme3.network.service.HostedService;
import com.jme3.network.service.Service;
import com.jme3.network.service.ServiceManager;

public class HostedServiceManager
extends ServiceManager<HostedServiceManager> {
    private Server server;
    private ConnectionObserver connectionObserver;

    public HostedServiceManager(Server server) {
        this.server = server;
        this.connectionObserver = new ConnectionObserver();
        server.addConnectionListener(this.connectionObserver);
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    protected final HostedServiceManager getParent() {
        return this;
    }

    @Override
    public void addService(HostedService s) {
        super.addService(s);
    }

    public void addServices(HostedService ... services) {
        for (HostedService s : services) {
            super.addService(s);
        }
    }

    @Override
    public void removeService(HostedService s) {
        super.removeService(s);
    }

    protected void addConnection(HostedConnection hc) {
        for (Service s : this.getServices()) {
            ((HostedService)s).connectionAdded(this.server, hc);
        }
    }

    protected void removeConnection(HostedConnection hc) {
        for (Service s : this.getServices()) {
            ((HostedService)s).connectionRemoved(this.server, hc);
        }
    }

    protected class ConnectionObserver
    implements ConnectionListener {
        protected ConnectionObserver() {
        }

        @Override
        public void connectionAdded(Server server, HostedConnection hc) {
            HostedServiceManager.this.addConnection(hc);
        }

        @Override
        public void connectionRemoved(Server server, HostedConnection hc) {
            HostedServiceManager.this.removeConnection(hc);
        }
    }
}

