/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.gext;

import com.jme3.math.Vector2f;
import java.util.List;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vector2fGroovyMethods {
    static Logger log = LoggerFactory.getLogger(Vector2fGroovyMethods.class);

    public static Vector2f plus(Vector2f v1, Vector2f v2) {
        return v1.add(v2);
    }

    public static Vector2f plus(Vector2f v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        Vector2f result = new Vector2f(v1);
        result.x += v2.get(0).floatValue();
        result.y = result.y + (v2.size() > 1 ? v2.get(1).floatValue() : 0.0f);
        return result;
    }

    public static Vector2f minus(Vector2f v1, Vector2f v2) {
        return v1.subtract(v2);
    }

    public static Vector2f minus(Vector2f v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        Vector2f result = new Vector2f(v1);
        result.x -= v2.get(0).floatValue();
        result.y = result.y - (v2.size() > 1 ? v2.get(1).floatValue() : 0.0f);
        return result;
    }

    public static Vector2f multiply(Number n, Vector2f v) {
        return v.mult(n.floatValue());
    }

    public static Vector2f multiply(Vector2f v, Number n) {
        return v.mult(n.floatValue());
    }

    public static Vector2f multiply(Vector2f v1, Vector2f v2) {
        Vector2f result = new Vector2f(v1);
        result.x *= v2.x;
        result.y *= v2.y;
        return result;
    }

    public static Vector2f multiply(Vector2f v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        float x = v2.get(0).floatValue();
        float y = v2.size() > 1 ? v2.get(1).floatValue() : 1.0f;
        return new Vector2f(x, y).multLocal(v1);
    }

    public static Vector2f div(Vector2f v, Number n) {
        return v.divide(n.floatValue());
    }

    public static Vector2f div(Vector2f v1, Vector2f v2) {
        Vector2f result = new Vector2f(v1);
        result.x /= v2.x;
        result.y /= v2.y;
        return result;
    }

    public static Vector2f div(Vector2f v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        float x = v2.get(0).floatValue();
        float y = v2.size() > 1 ? v2.get(1).floatValue() : 1.0f;
        return new Vector2f(v1.x / x, v1.y / y);
    }

    public static Object asType(Vector2f v, Class type) {
        if (type == Vector2f.class) {
            return v;
        }
        throw new GroovyCastException("Cannot convert:" + v + " to:" + type);
    }
}

