/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNeighborhood {
    static Logger log = LoggerFactory.getLogger(TreeNeighborhood.class);
    private World world;
    private ColumnId centerColumnId;
    private int radius;
    private Map<TileId, TreeLayer> treeIndex = new HashMap<TileId, TreeLayer>();
    private List<ColumnTrees> columnTrees = new ArrayList<ColumnTrees>();

    public TreeNeighborhood(World world, ColumnId centerColumnId, int radius) {
        this.world = world;
        this.centerColumnId = centerColumnId;
        this.radius = radius;
        this.reload();
    }

    public ColumnId getColumnId() {
        return this.centerColumnId;
    }

    public void visitTrees(BiConsumer<Vec3i, Tree> visitor) {
        for (ColumnTrees col : this.columnTrees) {
            Vec3i treeOrigin = col.treeOrigin;
            for (Tree tree : col.trees) {
                visitor.accept(treeOrigin, tree);
            }
        }
    }

    protected void reload() {
        Vec3i center = this.centerColumnId.getWorld(null);
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                Vec3i pos = center.add(x * 32, 0, z * 32);
                ColumnId id = ColumnId.fromWorld((Vec3i)pos);
                TileId tileId = id.getTileId();
                TreeLayer treeLayer = this.getTreeLayer(tileId);
                this.columnTrees.add(new ColumnTrees(this, id, tileId.getWorld(null), treeLayer.getTrees(id)));
            }
        }
    }

    protected TreeLayer getTreeLayer(TileId tileId) {
        TreeLayer result = this.treeIndex.get(tileId);
        if (result == null) {
            result = this.world.getTrees(tileId, null);
            this.treeIndex.put(tileId, result);
        }
        return result;
    }

    public class ColumnTrees {
        private ColumnId id;
        private Vec3i treeOrigin;
        private List<Tree> trees;

        protected ColumnTrees(TreeNeighborhood this$0, ColumnId id, Vec3i treeOrigin, List<Tree> trees) {
            this.id = id;
            this.treeOrigin = treeOrigin;
            this.trees = trees;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.id + "]";
        }
    }
}

