/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mblock.CellArray;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;

public class LightDataProtocol
implements ObjectProtocol<LightData> {
    private int protocolVersion = 1;
    private CellArrayProtocol cellProtocol = new CellArrayProtocol();

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void write(LightData lightData, BitOutputStream out) throws IOException {
        assert (lightData.checkCounts());
        out.writeBits(this.protocolVersion, 8);
        out.writeLongBits(lightData.getLeafId().getId(), 64);
        out.writeLongBits(-1L, 64);
        out.writeBits(lightData.getSunCellCount(), 16);
        out.writeBits(lightData.getEmptyCellCount(), 16);
        int[] array = lightData.getArray();
        if (array == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.cellProtocol.writeRleData(array, -1, 0, 32, out);
    }

    @Override
    public LightData read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        LeafId leafId = new LeafId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        int sunCellCount = in.readBits(16);
        int emptyCellCount = in.readBits(16);
        int nullBit = in.readBits(1);
        if (nullBit == 0) {
            return new LightData(leafId, null, emptyCellCount, sunCellCount);
        }
        CellArray cells = new CellArray(32);
        this.cellProtocol.readRleData(cells.getArray(), -1, 0, 32, in);
        return new LightData(leafId, cells, emptyCellCount, sunCellCount);
    }
}

