/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.Query;
import com.simsilica.es.StringIndex;
import com.simsilica.es.WatchedEntity;
import com.simsilica.es.base.CompositeQuery;
import com.simsilica.es.base.DefaultEntitySet;
import com.simsilica.es.base.DefaultWatchedEntity;
import com.simsilica.es.server.ComponentVisibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDataWrapper
implements ObservableEntityData {
    static Logger log = LoggerFactory.getLogger(EntityDataWrapper.class);
    private final ObservableEntityData delegate;
    private final ChangeObserver listener = new ChangeObserver();
    private final Map<Class, ComponentVisibility> visibilityFilters = new HashMap<Class, ComponentVisibility>();
    private final List<LocalEntitySet> entitySets = new CopyOnWriteArrayList<LocalEntitySet>();
    private final List<EntityComponentListener> entityListeners = new CopyOnWriteArrayList<EntityComponentListener>();
    private final ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();

    public EntityDataWrapper(ObservableEntityData delegate) {
        this.delegate = delegate;
        delegate.addEntityComponentListener((EntityComponentListener)this.listener);
    }

    public void registerComponentVisibility(ComponentVisibility visibility) {
        this.visibilityFilters.put(visibility.getComponentType(), visibility);
        visibility.initialize((EntityData)this.delegate);
    }

    public Class<? extends EntityComponent>[] getTypes(EntitySet set) {
        return ((LocalEntitySet)set).getTypes();
    }

    public Set<EntityId> getPurgedEntities(EntitySet set) {
        return ((LocalEntitySet)set).getPurgedEntities();
    }

    public EntityId createEntity() {
        return this.delegate.createEntity();
    }

    public void removeEntity(EntityId entityId) {
        this.delegate.removeEntity(entityId);
    }

    public void setComponent(EntityId entityId, EntityComponent component) {
        this.delegate.setComponent(entityId, component);
    }

    public void setComponents(EntityId entityId, EntityComponent ... components) {
        this.delegate.setComponents(entityId, components);
    }

    public <T extends EntityComponent> boolean removeComponent(EntityId entityId, Class<T> type) {
        return this.delegate.removeComponent(entityId, type);
    }

    public void removeComponents(EntityId entityId, Class ... types) {
        this.delegate.removeComponents(entityId, types);
    }

    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        ComponentVisibility visibility;
        if (log.isTraceEnabled()) {
            log.trace("getComponent(" + entityId + ", " + type + ")");
        }
        if ((visibility = this.visibilityFilters.get(type)) != null) {
            return visibility.getComponent(entityId, type);
        }
        return (T)this.delegate.getComponent(entityId, type);
    }

    public Entity getEntity(EntityId entityId, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("getEntity(" + entityId + ", " + Arrays.asList(types) + ")");
        }
        return this.delegate.getEntity(entityId, types);
    }

    public EntityId findEntity(ComponentFilter filter, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("findEntity(" + filter + ", " + Arrays.asList(types) + ")");
        }
        return this.delegate.findEntity(filter, types);
    }

    public EntityId findEntity(EntityCriteria criteria) {
        if (log.isTraceEnabled()) {
            log.trace("findEntity(" + criteria + ")");
        }
        Query query = this.createQuery(criteria);
        return query.findFirst();
    }

    protected ComponentFilter forType(ComponentFilter filter, Class type) {
        if (filter == null || filter.getComponentType() != type) {
            return null;
        }
        return filter;
    }

    public Set<EntityId> findEntities(ComponentFilter filter, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("findEntities(" + filter + ", " + Arrays.asList(types) + ")");
        }
        if (this.visibilityFilters.isEmpty()) {
            return this.delegate.findEntities(filter, types);
        }
        if (types == null || types.length == 0) {
            types = new Class[]{filter.getComponentType()};
        }
        int visIndex = -1;
        ComponentVisibility visibility = null;
        for (int i = 0; i < types.length; ++i) {
            visibility = this.visibilityFilters.get(types[i]);
            if (visibility == null) continue;
            visIndex = i;
            break;
        }
        if (visibility == null) {
            return this.delegate.findEntities(filter, types);
        }
        Set<EntityId> first = visibility.getEntityIds(this.forType(filter, types[visIndex]));
        if (first.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 0; i < types.length; ++i) {
            if (i == visIndex) continue;
            Set sub = this.delegate.findEntities(filter, new Class[]{types[i]});
            if (sub.isEmpty()) {
                return Collections.emptySet();
            }
            and.retainAll(sub);
        }
        return and;
    }

    public <T extends EntityComponent> Query createQuery(final ComponentFilter<T> filter, Class<T> type) {
        final ComponentVisibility visibility = this.visibilityFilters.get(type);
        if (visibility != null) {
            return new Query(){

                public Set<EntityId> execute() {
                    return visibility.getEntityIds(filter);
                }
            };
        }
        return this.delegate.createQuery(filter, type);
    }

    public Query createQuery(EntityCriteria criteria) {
        ComponentFilter[] filters = criteria.toFilterArray();
        Class[] types = criteria.toTypeArray();
        ArrayList<Query> subQueries = new ArrayList<Query>();
        for (int i = 0; i < types.length; ++i) {
            Query query = this.createQuery(filters[i], types[i]);
            ListIterator<Query> it = subQueries.listIterator();
            while (it.hasNext()) {
                Query sub = (Query)it.next();
                Query merged = sub.join(query);
                if (merged == null) continue;
                query = null;
                it.set(merged);
                break;
            }
            if (query == null) continue;
            subQueries.add(query);
        }
        if (subQueries.size() == 1) {
            return (Query)subQueries.get(0);
        }
        return new CompositeQuery(subQueries);
    }

    public Set<EntityId> findEntities(EntityCriteria criteria) {
        if (this.visibilityFilters.isEmpty()) {
            return this.delegate.findEntities(criteria);
        }
        Query query = this.createQuery(criteria);
        return query.execute();
    }

    public EntitySet getEntities(Class ... types) {
        return this.getEntities((ComponentFilter)null, types);
    }

    public EntitySet getEntities(ComponentFilter filter, Class ... types) {
        return this.getEntities(new EntityCriteria().add(types));
    }

    public EntitySet getEntities(EntityCriteria criteria) {
        LocalEntitySet result = new LocalEntitySet((EntityData)this, criteria);
        result.loadEntities(false);
        this.entitySets.add(result);
        return result;
    }

    public WatchedEntity watchEntity(EntityId entityId, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("watchEntity(" + entityId + ", " + Arrays.asList(types) + ")");
        }
        return new DefaultWatchedEntity((EntityData)this, entityId, types);
    }

    public StringIndex getStrings() {
        return this.delegate.getStrings();
    }

    public void addEntityComponentListener(EntityComponentListener l) {
        this.entityListeners.add(l);
    }

    public void removeEntityComponentListener(EntityComponentListener l) {
        this.entityListeners.remove(l);
    }

    public void close() {
        this.delegate.removeEntityComponentListener((EntityComponentListener)this.listener);
    }

    public boolean applyChanges(List<EntityChange> updates) {
        EntityChange change;
        if (!this.visibilityFilters.isEmpty()) {
            for (ComponentVisibility vis : this.visibilityFilters.values()) {
                vis.collectChanges(this.changes);
            }
        }
        if (this.changes.isEmpty()) {
            return false;
        }
        while ((change = this.changes.poll()) != null) {
            updates.add(change);
            this.entityChange(change);
        }
        return true;
    }

    protected void entityChange(EntityChange change) {
        for (EntityComponentListener l : this.entityListeners) {
            l.componentChange(change);
        }
        for (LocalEntitySet set : this.entitySets) {
            set.entityChange(change);
        }
    }

    private class ChangeObserver
    implements EntityComponentListener {
        private ChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            EntityDataWrapper.this.changes.add(change);
        }
    }

    protected class LocalEntitySet
    extends DefaultEntitySet {
        private Set<EntityId> purged;

        public LocalEntitySet(EntityData ed, EntityCriteria criteria) {
            super(ed, criteria);
            this.purged = new HashSet<EntityId>();
        }

        public Set<EntityId> getPurgedEntities() {
            return this.purged;
        }

        public void clearChangeSets() {
            super.clearChangeSets();
            this.purged.clear();
        }

        protected void onEntityPurged(Entity e) {
            this.purged.add(e.getId());
        }

        protected Class<? extends EntityComponent>[] getTypes() {
            return super.getTypes();
        }

        protected void loadEntities(boolean reload) {
            super.loadEntities(reload);
        }

        protected void entityChange(EntityChange change) {
            super.entityChange(change);
        }

        public void release() {
            EntityDataWrapper.this.entitySets.remove((Object)this);
            super.release();
        }
    }
}

