/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.google.common.base.MoreObjects;
import com.jme3.scene.Spatial;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3i;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item {
    static Logger log = LoggerFactory.getLogger(Item.class);
    private static final InventorySize2d DEFAULT_ITEM_SIZE = new InventorySize2d();
    private EntityId entityId;
    private Object type;
    private VersionedHolder<Spatial> model = new VersionedHolder();
    private VersionedHolder<InventorySize2d> itemSize = new VersionedHolder((Object)DEFAULT_ITEM_SIZE);
    private VersionedHolder<Vec3i> slot = new VersionedHolder((Object)new Vec3i());
    private VersionedHolder<Integer> count = new VersionedHolder((Object)1);
    private VersionedHolder<Integer> maxCount = new VersionedHolder((Object)1);

    public Item(EntityId entityId, Object type) {
        this.entityId = entityId;
        this.type = type;
    }

    public Object getType() {
        return this.type;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setModel(Spatial spatial) {
        this.model.updateObject((Object)spatial);
    }

    public Spatial getModel() {
        return (Spatial)this.model.getObject();
    }

    public VersionedReference<Spatial> createModelRef() {
        return this.model.createReference();
    }

    public void setItemSize(InventorySize2d itemSize) {
        this.itemSize.updateObject((Object)itemSize);
    }

    public InventorySize2d getItemSize() {
        return (InventorySize2d)this.itemSize.getObject();
    }

    public VersionedReference<InventorySize2d> createItemSizeRef() {
        return this.itemSize.createReference();
    }

    public void setSlot(Vec3i slot) {
        log.info("setSlot(" + slot + ") replacing:" + this.slot.getObject());
        this.slot.setObject((Object)slot);
    }

    public Vec3i getSlot() {
        return (Vec3i)this.slot.getObject();
    }

    public VersionedReference<Vec3i> createSlotRef() {
        return this.slot.createReference();
    }

    public void setCount(int count) {
        this.count.updateObject((Object)count);
    }

    public int getCount() {
        return (Integer)this.count.getObject();
    }

    public VersionedReference<Integer> createCountRef() {
        return this.count.createReference();
    }

    public void setMaxCount(int maxCount) {
        this.maxCount.updateObject((Object)maxCount);
    }

    public int getMaxCount() {
        return (Integer)this.maxCount.getObject();
    }

    public VersionedReference<Integer> createMaxCountRef() {
        return this.maxCount.createReference();
    }

    public boolean contains(int xSlot, int ySlot) {
        Vec3i slot = this.getSlot();
        if (xSlot < slot.x || ySlot < slot.y) {
            return false;
        }
        InventorySize2d size = this.getItemSize();
        return xSlot < slot.x + size.getXSlots() && ySlot < slot.y + size.getYSlots();
    }

    public boolean intersects(Item item) {
        Vec3i itemSlot = item.getSlot();
        InventorySize2d size = item.getItemSize();
        return this.intersects(itemSlot.x, itemSlot.y, size.getXSlots(), size.getYSlots());
    }

    public boolean intersects(int xSlot, int ySlot, int width, int height) {
        Vec3i slot = this.getSlot();
        if (xSlot + width <= slot.x) {
            return false;
        }
        if (ySlot + height <= slot.y) {
            return false;
        }
        InventorySize2d size = this.getItemSize();
        return xSlot < slot.x + size.getXSlots() && ySlot < slot.y + size.getYSlots();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("entityId", (Object)this.entityId).add("model", (Object)this.getModel()).add("itemSize", (Object)this.getItemSize()).add("slot", (Object)this.getSlot()).toString();
    }
}

