/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.base;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityId;
import com.simsilica.es.Query;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeQuery
implements Query {
    static Logger log = LoggerFactory.getLogger(CompositeQuery.class);
    private List<Query> children;

    public CompositeQuery(List<Query> children) {
        this.children = children;
    }

    @Override
    public Set<EntityId> execute() {
        if (this.children.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EntityId> results = null;
        for (Query q : this.children) {
            Set<EntityId> sub = q.execute();
            if (sub.isEmpty()) {
                return Collections.emptySet();
            }
            if (results == null) {
                results = new HashSet<EntityId>(sub);
                continue;
            }
            results.retainAll(sub);
        }
        return results;
    }

    @Override
    public EntityId findFirst() {
        if (this.children.isEmpty()) {
            return null;
        }
        if (this.children.size() == 1) {
            return this.children.get(0).findFirst();
        }
        Set<EntityId> all = this.execute();
        if (all.isEmpty()) {
            return null;
        }
        return all.iterator().next();
    }

    @Override
    public Query join(Query other) {
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("children", this.children).toString();
    }
}

