/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstanceCounter
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(SubstanceCounter.class);
    private static final double EPSILON = 1.0E-6;
    private EntityId target;
    private int typeId;
    private double amount;
    private double max;

    private SubstanceCounter() {
    }

    public SubstanceCounter(EntityId target, int typeId, double amount, double max) {
        this.target = target;
        this.typeId = typeId;
        this.amount = amount;
        this.max = max;
    }

    public static SubstanceCounter create(EntityId target, String typeName, double amount, double max, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return new SubstanceCounter(target, id, amount, max);
    }

    public static ComponentFilter<SubstanceCounter> targetFilter(EntityId target) {
        return Filters.fieldEquals(SubstanceCounter.class, (String)"target", (Object)target);
    }

    public static ComponentFilter<SubstanceCounter> typeFilter(EntityId target, int typeId) {
        ComponentFilter<SubstanceCounter> targetFilter = SubstanceCounter.targetFilter(target);
        ComponentFilter typeFilter = Filters.fieldEquals(SubstanceCounter.class, (String)"typeId", (Object)typeId);
        return Filters.and(SubstanceCounter.class, (ComponentFilter[])new ComponentFilter[]{targetFilter, typeFilter});
    }

    public static ComponentFilter<SubstanceCounter> typeNameFilter(EntityId target, String typeName, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return SubstanceCounter.typeFilter(target, id);
    }

    public SubstanceCounter changeAmount(double amount) {
        if (amount > this.max) {
            throw new IllegalArgumentException("Amount:" + amount + " exceeds max:" + this.max);
        }
        return new SubstanceCounter(this.target, this.typeId, amount, this.max);
    }

    public EntityId getTarget() {
        return this.target;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getMax() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.target, this.typeId, this.amount, this.max);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SubstanceCounter other = (SubstanceCounter)o;
        if (!Objects.equals(this.target, other.target)) {
            return false;
        }
        if (Math.abs(this.amount - other.amount) > 1.0E-6) {
            return false;
        }
        return this.max != other.max;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.typeId) : this.getTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("target", (Object)this.target).add("typeId", (Object)s).add("amount", this.amount).add("max", this.max).toString();
    }
}

