/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.OptionPanel;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.style.ElementId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionPanelState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(OptionPanelState.class);
    private OptionPanel current;
    private String style;
    private ElementId defaultElementId = new ElementId("optionPanel");

    public OptionPanelState() {
    }

    public OptionPanelState(String style) {
        this.style = style;
    }

    public OptionPanelState(ElementId defaultElementId, String style) {
        this.defaultElementId = defaultElementId;
        this.style = style;
    }

    public OptionPanelState(Node guiNode) {
        if (guiNode != null) {
            log.warn("guiNode constructor now ignores the guiNode parameter, see: PopupState");
        }
    }

    public void show(String title, String message, Action ... options) {
        this.show(title, message, this.defaultElementId, options);
    }

    public void show(String title, String message, ElementId elementId, Action ... options) {
        this.show(new OptionPanel(title, message, elementId, this.style, options));
    }

    protected String getName(Throwable t) {
        String name = t.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        boolean last = true;
        sb.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean upper = Character.isUpperCase(c);
            if (upper && !last) {
                sb.append(" ");
                last = true;
            }
            sb.append(c);
            last = upper;
        }
        return sb.toString();
    }

    public void showError(String title, Throwable t) {
        this.show(title, this.getName(t) + "\n" + t.getMessage(), this.defaultElementId, new Action[0]);
    }

    public void showError(String title, Throwable t, ElementId elementId) {
        this.show(title, this.getName(t) + "\n" + t.getMessage(), elementId, new Action[0]);
    }

    public void show(OptionPanel panel) {
        if (this.current != null) {
            this.current.close();
        }
        this.current = panel;
        Vector2f screen = ((PopupState)this.getState(PopupState.class)).getGuiSize();
        Vector3f pref = this.current.getPreferredSize();
        Vector3f pos = new Vector3f(screen.x, screen.y, 0.0f).multLocal(0.5f);
        pos.x -= pref.x * 0.5f;
        pos.y += pref.y * 0.5f;
        this.current.setLocalTranslation(pos);
        ((PopupState)this.getState(PopupState.class)).showModalPopup((Spatial)this.current);
    }

    public void close() {
        if (this.current != null) {
            ((PopupState)this.getState(PopupState.class)).closePopup((Spatial)this.current);
            this.current = null;
        }
    }

    public OptionPanel getCurrent() {
        return this.current;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setGuiNode(Node guiNode) {
        if (guiNode != null) {
            log.warn("guiNode parameter ignored, uses PopupState's guiNode instead, see: PopupState");
        }
    }

    public Node getGuiNode() {
        return ((PopupState)this.getState(PopupState.class)).getGuiNode();
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
    }
}

