/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.input;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.net.client.WorldClientService;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.client.GameSessionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.WorldMarkerState;
import mythruna.client.view.input.BlockTypeSelectionState;
import mythruna.client.view.input.HandManipulator;
import mythruna.client.view.object.ClaimViewState;
import mythruna.client.view.object.ModelViewState;
import mythruna.es.ClaimPermissions;
import mythruna.sim.BlockHit;
import mythruna.sim.ObjectHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockManipulator
extends HandManipulator {
    static Logger log = LoggerFactory.getLogger(BlockManipulator.class);
    private GameSessionState sessionState;
    private WorldClientService world;
    private AvatarState avatar;
    private WorldMarkerState markers;
    private float timer = 0.0f;
    private float timeout = 0.1f;
    private boolean valid = false;
    private Vec3i lastMarkerLoc;

    public BlockManipulator(GameSessionState sessionState, AvatarState avatar, ModelViewState models, Consumer<String> defaultAction) {
        super(sessionState.getGameSession(), avatar, models, defaultAction);
        this.sessionState = sessionState;
        this.world = (WorldClientService)sessionState.getWorld();
        this.avatar = avatar;
        this.markers = (WorldMarkerState)avatar.getState(WorldMarkerState.class);
    }

    @Override
    public void setTarget(EntityId target) {
        super.setTarget(target);
        if (target == null) {
            this.highlightBlock(null, null, null);
        }
    }

    @Override
    public void update(float tpf) {
        super.update(tpf);
        if (!this.valid) {
            this.timer += tpf;
            if (this.timer > this.timeout) {
                this.validate();
            }
        }
    }

    protected void invalidate() {
        this.valid = false;
        this.timer = 0.0f;
    }

    protected void validate() {
        if (this.valid) {
            return;
        }
        this.valid = true;
        HandManipulator.WorldHit hit = this.pickWorld(10);
        if (hit.blockHit != null && hit.object == null) {
            BlockType type = BlockTypeIndex.get((int)hit.blockHit.type);
            this.highlightBlock(hit.blockHit.block, type, hit.blockHit.normal);
        } else {
            this.highlightBlock(null, null, null);
        }
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        super.viewChanged(pos, facing);
        this.invalidate();
    }

    protected void highlightBlock(Vec3i loc, BlockType type, Vec3d normal) {
        if (Objects.equals(this.lastMarkerLoc, loc)) {
            return;
        }
        if (this.lastMarkerLoc != null) {
            this.markers.removeBlockMarker(this.lastMarkerLoc);
        }
        this.lastMarkerLoc = loc;
        if (this.lastMarkerLoc != null) {
            this.markers.addBlockMarker(this.lastMarkerLoc, type, normal);
        }
    }

    @Override
    protected void mainClickObject(ObjectHit object) {
        super.mainClickObject(object);
        log.info("mainClickObject() invalidate()");
        this.invalidate();
    }

    @Override
    protected void altClickObject(ObjectHit object) {
        super.altClickObject(object);
        log.info("mainClickObject() invalidate()");
        this.invalidate();
    }

    @Override
    protected void mainPressBlock(BlockHit hit) {
        this.runAction("startRemoving", hit);
        this.startRemoving(hit);
    }

    @Override
    protected void mainClickBlock(BlockHit hit) {
        this.runAction("stopRemoving", hit);
        this.stopRemoving(hit);
    }

    protected Vec3d getFillLocation(BlockHit hit) {
        return hit.block.toVec3d().addLocal(hit.normal);
    }

    @Override
    protected void altPressBlock(BlockHit hit) {
        int type = ((BlockTypeSelectionState)this.avatar.getState(BlockTypeSelectionState.class)).getSelectedType();
        if (type <= 0) {
            return;
        }
        Vec3d pos = this.getFillLocation(hit);
        log.info("pressed:" + hit + " fill:" + pos);
        this.runAction("startFilling", hit, pos, type);
        this.startFilling(hit, pos, type);
    }

    @Override
    protected void altClickBlock(BlockHit hit) {
        BlockType existingType;
        int type = ((BlockTypeSelectionState)this.avatar.getState(BlockTypeSelectionState.class)).getSelectedType();
        if (type <= 0) {
            return;
        }
        Vec3d pos = this.getFillLocation(hit);
        log.info("released:" + hit + " fill:" + pos);
        int existing = MaskUtils.getType((int)this.world.getWorldCell(pos));
        if (existing != 0 && (existingType = BlockTypeIndex.get((int)existing)) != null && existingType.getColliderType() != null) {
            log.info("already a solid block there");
            return;
        }
        Vec3i loc = pos.floor();
        log.info("adjusted hit:" + loc + "  existing value:" + existing);
        this.runAction("stopFilling", hit, pos, type);
        this.stopFilling(hit, pos, type);
    }

    protected void startRemoving(BlockHit hit) {
    }

    protected void stopRemoving(BlockHit hit) {
        log.info("hit:" + hit);
        ClaimPermissions perms = this.getPerms(hit.block);
        if (!perms.canRemoveBlock()) {
            log.info("Not allowed to remove");
            return;
        }
        log.info("Removing block from:" + hit.block);
        long start = System.nanoTime();
        boolean result = this.world.setLocalWorldCell(hit.block, 0);
        long end = System.nanoTime();
        log.info("set local world cell result:" + result + "  in:" + (double)(end - start) / 1000000.0 + " ms");
        this.invalidate();
    }

    protected void startFilling(BlockHit hit, Vec3d pos, int type) {
    }

    protected void stopFilling(BlockHit hit, Vec3d pos, int type) {
        ClaimPermissions perms = this.getPerms(hit.block);
        if (!perms.canAddBlock()) {
            log.info("Not allowed to add");
            return;
        }
        log.info("Setting block:" + pos + "  to:" + type);
        long start = System.nanoTime();
        boolean result = this.world.setLocalWorldCell(pos.floor(), type);
        long end = System.nanoTime();
        log.info("set local world cell result:" + result + "  in:" + (double)(end - start) / 1000000.0 + " ms");
        this.invalidate();
    }

    @Override
    public void change(int delta) {
        ((BlockTypeSelectionState)this.avatar.getState(BlockTypeSelectionState.class)).adjustRotation(delta);
        super.change(delta);
    }

    protected ClaimPermissions getPerms(Vec3i loc) {
        return ((ClaimViewState)this.avatar.getState(ClaimViewState.class)).getPerms(loc);
    }
}

